/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.List;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;

public abstract class JDBCFeatureWriterOnlineTest
extends JDBCTestSupport {
    public void testNext() throws Exception {
        SimpleFeature feature;
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);){
            JDBCFeatureWriterOnlineTest.assertTrue((boolean)writer.hasNext());
            feature = (SimpleFeature)writer.next();
            JDBCFeatureWriterOnlineTest.assertTrue((boolean)feature.getAttribute(0).toString().equals("POINT (0 0)"));
            JDBCFeatureWriterOnlineTest.assertTrue(((Integer)feature.getAttribute(1) == 0 ? 1 : 0) != 0);
            JDBCFeatureWriterOnlineTest.assertTrue(((Double)feature.getAttribute(2) == 0.0 ? 1 : 0) != 0);
            JDBCFeatureWriterOnlineTest.assertTrue((boolean)((String)feature.getAttribute(3)).equals("zero"));
        }
        writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);
        try {
            JDBCFeatureWriterOnlineTest.assertTrue((boolean)writer.hasNext());
            feature = (SimpleFeature)writer.next();
            List attributes = feature.getAttributes();
            for (int k = 0; k < attributes.size(); ++k) {
                JDBCFeatureWriterOnlineTest.assertTrue((attributes.get(k) != null ? 1 : 0) != 0);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

