/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCFeatureSourceOnlineTest
extends JDBCTestSupport {
    protected JDBCFeatureStore featureSource;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.featureSource = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.featureSource.getSchema();
        JDBCFeatureSourceOnlineTest.assertEquals((String)this.tname("ft1"), (String)schema.getTypeName());
        JDBCFeatureSourceOnlineTest.assertEquals((String)this.dataStore.getNamespaceURI(), (String)schema.getName().getNamespaceURI());
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areCRSEqual(this.getWGS84(), schema.getCoordinateReferenceSystem()));
        JDBCFeatureSourceOnlineTest.assertEquals((int)4, (int)schema.getAttributeCount());
        JDBCFeatureSourceOnlineTest.assertNotNull((Object)schema.getDescriptor(this.aname("geometry")));
        JDBCFeatureSourceOnlineTest.assertNotNull((Object)schema.getDescriptor(this.aname("intProperty")));
        JDBCFeatureSourceOnlineTest.assertNotNull((Object)schema.getDescriptor(this.aname("stringProperty")));
        JDBCFeatureSourceOnlineTest.assertNotNull((Object)schema.getDescriptor(this.aname("doubleProperty")));
    }

    public void testBounds() throws Exception {
        ReferencedEnvelope bounds = this.featureSource.getBounds();
        JDBCFeatureSourceOnlineTest.assertEquals((long)0L, (long)Math.round(bounds.getMinX()));
        JDBCFeatureSourceOnlineTest.assertEquals((long)0L, (long)Math.round(bounds.getMinY()));
        JDBCFeatureSourceOnlineTest.assertEquals((long)2L, (long)Math.round(bounds.getMaxX()));
        JDBCFeatureSourceOnlineTest.assertEquals((long)2L, (long)Math.round(bounds.getMaxY()));
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areCRSEqual(this.getWGS84(), bounds.getCoordinateReferenceSystem()));
    }

    public void testBoundsWithQuery() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        ReferencedEnvelope bounds = this.featureSource.getBounds(query);
        JDBCFeatureSourceOnlineTest.assertEquals((long)1L, (long)Math.round(bounds.getMinX()));
        JDBCFeatureSourceOnlineTest.assertEquals((long)1L, (long)Math.round(bounds.getMinY()));
        JDBCFeatureSourceOnlineTest.assertEquals((long)1L, (long)Math.round(bounds.getMaxX()));
        JDBCFeatureSourceOnlineTest.assertEquals((long)1L, (long)Math.round(bounds.getMaxY()));
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areCRSEqual(this.getWGS84(), bounds.getCoordinateReferenceSystem()));
    }

    protected CoordinateReferenceSystem getWGS84() throws FactoryException {
        return CRS.decode((String)"EPSG:4326");
    }

    public void testCount() throws Exception {
        JDBCFeatureSourceOnlineTest.assertEquals((int)3, (int)this.featureSource.getCount(Query.ALL));
    }

    public void testCountWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(query));
    }

    public void testCountWithOffsetLimit() throws Exception {
        Query query = new Query();
        query.setStartIndex(Integer.valueOf(1));
        query.setMaxFeatures(1);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(query));
    }

    public void testGetFeatures() throws Exception {
        ContentFeatureCollection features = this.featureSource.getFeatures();
        JDBCFeatureSourceOnlineTest.assertEquals((int)3, (int)features.size());
    }

    public void testGetFeaturesWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"one", (Object)feature.getAttribute(this.aname("stringProperty")));
            JDBCFeatureSourceOnlineTest.assertEquals((Object)1.1, (Object)feature.getAttribute(this.aname("doubleProperty")));
        }
    }

    public void testGetFeaturesWithInvalidFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try (SimpleFeatureIterator fi = this.featureSource.getFeatures((Filter)f).features();){
            JDBCFeatureSourceOnlineTest.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    public void testGetFeaturesWithLogicFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo property = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        BBOX bbox = ff.bbox(this.aname("geometry"), -20.0, -20.0, 20.0, 20.0, "EPSG:4326");
        And filter = ff.and((Filter)property, (Filter)bbox);
        ContentFeatureCollection features = this.featureSource.getFeatures((Filter)filter);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"one", (Object)feature.getAttribute(this.aname("stringProperty")));
            JDBCFeatureSourceOnlineTest.assertEquals((Object)1.1, (Object)feature.getAttribute(this.aname("doubleProperty")));
        }
    }

    public void testCaseInsensitiveFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo sensitive = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"OnE"), true);
        PropertyIsEqualTo insensitive = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"OnE"), false);
        JDBCFeatureSourceOnlineTest.assertEquals((int)0, (int)this.featureSource.getCount(new Query(null, (Filter)sensitive)));
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(new Query(null, (Filter)insensitive)));
    }

    public void testGetFeaturesWithQuery() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setPropertyNames(new String[]{this.aname("doubleProperty"), this.aname("intProperty")});
        query.setFilter((Filter)filter);
        ContentFeatureCollection features = this.featureSource.getFeatures(query);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            SimpleFeature feature = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((int)2, (int)feature.getAttributeCount());
            JDBCFeatureSourceOnlineTest.assertEquals((Object)1.1, (Object)feature.getAttribute(this.aname("doubleProperty")));
            JDBCFeatureSourceOnlineTest.assertNotNull((Object)feature.getAttribute(this.aname("intProperty")));
        }
    }

    public void testGetFeaturesWithInvalidQuery() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try (SimpleFeatureIterator fi = this.featureSource.getFeatures(new Query("ft1", (Filter)f)).features();){
            JDBCFeatureSourceOnlineTest.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetFeaturesWithSort() throws Exception {
        SimpleFeature f;
        FilterFactory ff = this.dataStore.getFilterFactory();
        SortBy sort = ff.sort(this.aname("stringProperty"), SortOrder.ASCENDING);
        Query query = new Query();
        query.setSortBy(new SortBy[]{sort});
        ContentFeatureCollection features = this.featureSource.getFeatures(query);
        JDBCFeatureSourceOnlineTest.assertEquals((int)3, (int)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"one", (Object)f.getAttribute(this.aname("stringProperty")));
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"zero", (Object)f.getAttribute(this.aname("stringProperty")));
        }
        sort = ff.sort(this.aname("stringProperty"), SortOrder.DESCENDING);
        query.setSortBy(new SortBy[]{sort});
        features = this.featureSource.getFeatures(query);
        iterator = features.features();
        try {
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"zero", (Object)f.getAttribute(this.aname("stringProperty")));
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)iterator.hasNext());
            f = (SimpleFeature)iterator.next();
            JDBCFeatureSourceOnlineTest.assertEquals((Object)"one", (Object)f.getAttribute(this.aname("stringProperty")));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public void testGetFeaturesWithMax() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setMaxFeatures(2);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        JDBCFeatureSourceOnlineTest.assertEquals((int)2, (int)features.size());
        try (SimpleFeatureIterator it = features.features();){
            int count = 0;
            ReferencedEnvelope env = new ReferencedEnvelope(((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem());
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                env.expandToInclude((Envelope)ReferencedEnvelope.reference((org.opengis.geometry.Envelope)f.getBounds()));
                ++count;
            }
            JDBCFeatureSourceOnlineTest.assertEquals((int)2, (int)count);
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(env, features.getBounds()));
        }
    }

    public void testGetFeaturesWithOffset() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{this.dataStore.getFilterFactory().sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        q.setStartIndex(Integer.valueOf(2));
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator it = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            ReferencedEnvelope fe = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)f.getBounds());
            JDBCFeatureSourceOnlineTest.assertEquals((int)2, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCFeatureSourceOnlineTest.assertFalse((boolean)it.hasNext());
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(fe, features.getBounds()));
        }
    }

    public void testGetFeaturesWithOffsetLimit() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setStartIndex(Integer.valueOf(1));
        q.setMaxFeatures(1);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator it = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            ReferencedEnvelope fe = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)f.getBounds());
            JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCFeatureSourceOnlineTest.assertFalse((boolean)it.hasNext());
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(fe, features.getBounds()));
        }
    }

    public void testGetFeaturesWithOffsetLimitAndPostFilter() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.literal((Object)"one"), (Expression)ff.function("strToLowerCase", new Expression[]{ff.property(this.aname("stringProperty"))}), true);
        q.setFilter((Filter)filter);
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(1);
        ContentFeatureCollection features = this.featureSource.getFeatures(q);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)features.size());
        try (SimpleFeatureIterator it = features.features();){
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            ReferencedEnvelope fe = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)f.getBounds());
            JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCFeatureSourceOnlineTest.assertFalse((boolean)it.hasNext());
            JDBCFeatureSourceOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(fe, features.getBounds()));
        }
    }

    public void testRendererBehaviour() throws Exception {
        Query query = new Query(this.featureSource.getSchema().getTypeName());
        query.setHints(new Hints((RenderingHints)new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory())));
        ContentFeatureCollection fc = this.featureSource.getFeatures(query);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                fi.next();
            }
        }
    }

    public void testQueryCapabilitiesSort() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        QueryCapabilities caps = this.featureSource.getQueryCapabilities();
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)}));
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("stringProperty"), SortOrder.DESCENDING)}));
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("doubleProperty"), SortOrder.ASCENDING)}));
        JDBCFeatureSourceOnlineTest.assertFalse((boolean)caps.supportsSorting(new SortBy[]{ff.sort(this.aname("geometry"), SortOrder.ASCENDING)}));
    }

    public void testQueryCapabilitiesReliableFid() throws Exception {
        QueryCapabilities caps = this.featureSource.getQueryCapabilities();
        JDBCFeatureSourceOnlineTest.assertTrue((boolean)caps.isReliableFIDSupported());
    }

    public void testNaturalSortingAsc() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        try (SimpleFeatureIterator features = this.featureSource.getFeatures(q).features();){
            String prevId = null;
            while (features.hasNext()) {
                String currId = ((SimpleFeature)features.next()).getID();
                if (prevId != null) {
                    JDBCFeatureSourceOnlineTest.assertTrue((prevId.compareTo(currId) <= 0 ? 1 : 0) != 0);
                }
                prevId = currId;
            }
        }
    }

    public void testNaturalSortingdesc() throws Exception {
        Query q = new Query(this.featureSource.getSchema().getTypeName());
        q.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        try (SimpleFeatureIterator features = this.featureSource.getFeatures(q).features();){
            String prevId = null;
            while (features.hasNext()) {
                String currId = ((SimpleFeature)features.next()).getID();
                if (prevId != null) {
                    JDBCFeatureSourceOnlineTest.assertTrue((prevId.compareTo(currId) >= 0 ? 1 : 0) != 0);
                }
                prevId = currId;
            }
        }
    }

    public void testFeatureIteratorNextContract() throws Exception {
        try (SimpleFeatureIterator features = this.featureSource.getFeatures().features();){
            SimpleFeature f = (SimpleFeature)features.next();
            JDBCFeatureSourceOnlineTest.assertNotNull((Object)f);
        }
    }

    public void testFeatureIteratorEmptyContract() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"not_there"));
        try (SimpleFeatureIterator features = this.featureSource.getFeatures((Filter)filter).features();){
            SimpleFeature f = (SimpleFeature)features.next();
            JDBCFeatureSourceOnlineTest.assertNotNull((Object)f);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLikeFilter() throws Exception {
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        PropertyIsLike caseSensitiveLike = ff.like((Expression)ff.property(this.aname("stringProperty")), "Z*", "*", "?", "\\", true);
        PropertyIsLike caseInsensitiveLike = ff.like((Expression)ff.property(this.aname("stringProperty")), "Z*", "*", "?", "\\", false);
        PropertyIsLike caseInsensitiveLike2 = ff.like((Expression)ff.property(this.aname("stringProperty")), "z*", "*", "?", "\\", false);
        JDBCFeatureSourceOnlineTest.assertEquals((int)0, (int)this.featureSource.getCount(new Query(null, (Filter)caseSensitiveLike)));
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(new Query(null, (Filter)caseInsensitiveLike)));
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(new Query(null, (Filter)caseInsensitiveLike2)));
    }

    public void testConversionFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.add((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal((Object)"0.1")));
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(new Query(null, (Filter)f)));
    }

    public void testNotFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"), true);
        f = ff.not((Filter)f);
        JDBCFeatureSourceOnlineTest.assertEquals((int)(this.featureSource.getCount(Query.ALL) - 1), (int)this.featureSource.getCount(new Query(null, (Filter)f)));
    }

    public void testGeometryFactoryHint() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"one"));
        Query query = new Query();
        query.setFilter((Filter)filter);
        GeometryFactory gf1 = new GeometryFactory();
        query.setHints(new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf1));
        SimpleFeature f1 = (SimpleFeature)DataUtilities.first((FeatureCollection)this.featureSource.getFeatures(query));
        JDBCFeatureSourceOnlineTest.assertSame((Object)gf1, (Object)((Geometry)f1.getDefaultGeometry()).getFactory());
        GeometryFactory gf2 = new GeometryFactory();
        query.setHints(new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf2));
        SimpleFeature f2 = (SimpleFeature)DataUtilities.first((FeatureCollection)this.featureSource.getFeatures(query));
        JDBCFeatureSourceOnlineTest.assertSame((Object)gf2, (Object)((Geometry)f2.getDefaultGeometry()).getFactory());
    }

    public void testGetFeaturesWithArithmeticOpFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        Subtract sub = ff.subtract((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(0.1));
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)sub);
        JDBCFeatureSourceOnlineTest.assertTrue((this.featureSource.getCount(new Query(null, (Filter)filter)) > 0 ? 1 : 0) != 0);
    }

    public void testAcceptsVisitor() throws Exception {
        class TotalVisitor
        implements FeatureVisitor {
            int total = 0;

            TotalVisitor() {
            }

            public void visit(Feature feature) {
                ++this.total;
            }
        }
        TotalVisitor visitor = new TotalVisitor();
        int count = this.featureSource.getCount(Query.ALL);
        this.featureSource.accepts(Query.ALL, (FeatureVisitor)visitor, null);
        JDBCFeatureSourceOnlineTest.assertEquals((int)count, (int)visitor.total);
        visitor.total = 0;
        JDBCFeatureStore ft1 = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        try (DefaultTransaction transaction = new DefaultTransaction();){
            ft1.setTransaction((Transaction)transaction);
            Connection connection = ft1.getDataStore().getConnection(ft1.getState());
            JDBCFeatureSourceOnlineTest.assertFalse((String)"connection established", (boolean)connection.isClosed());
            ft1.accepts(Query.ALL, (FeatureVisitor)visitor, null);
            JDBCFeatureSourceOnlineTest.assertFalse((String)"connection maintained", (boolean)connection.isClosed());
        }
    }

    public void testSimpleEncodeIn() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        String property = this.aname("stringProperty");
        PropertyName p = ff.property(property);
        Or orFilter = ff.or(Arrays.asList(ff.equal((Expression)p, (Expression)ff.literal((Object)"zero"), true), ff.equal((Expression)p, (Expression)ff.literal((Object)"one"), true), ff.equal((Expression)p, (Expression)ff.literal((Object)"two"), true)));
        Filter[] filters = this.featureSource.getFeatureSource().splitFilter((Filter)orFilter);
        JDBCFeatureSourceOnlineTest.assertEquals((Object)filters[1], (Object)Filter.INCLUDE);
        SQLDialect dialect = this.featureSource.getDataStore().getSQLDialect();
        if (dialect instanceof BasicSQLDialect) {
            FilterToSQL filterToSQL = ((BasicSQLDialect)dialect).createFilterToSQL();
            String sql = filterToSQL.encodeToString(filters[0]);
            String escapedProperty = filterToSQL.escapeName(property);
            JDBCFeatureSourceOnlineTest.assertEquals((String)("WHERE (" + escapedProperty + " IN ('zero', 'one', 'two') AND " + escapedProperty + " IS NOT NULL )"), (String)sql);
        } else if (dialect instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL filterToSQL = ((PreparedStatementSQLDialect)dialect).createPreparedFilterToSQL();
            filterToSQL.setFeatureType(this.featureSource.getSchema());
            String sql = filterToSQL.encodeToString(filters[0]);
            String escapedProperty = filterToSQL.escapeName(property);
            JDBCFeatureSourceOnlineTest.assertEquals((String)("WHERE (" + escapedProperty + " IN (?, ?, ?) AND " + escapedProperty + " IS NOT NULL )"), (String)sql);
            List literals = filterToSQL.getLiteralValues();
            JDBCFeatureSourceOnlineTest.assertEquals(Arrays.asList("zero", "one", "two"), (Object)literals);
        } else {
            JDBCFeatureSourceOnlineTest.fail((String)("Unexpected dialect type: " + dialect));
        }
    }

    protected List<Object> getTestMixedEncodeInExpected() {
        return Arrays.asList("zero", "two", 1, 2, 0.0);
    }

    public void testMixedEncodeIn() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        String sp = this.aname("stringProperty");
        PropertyName spp = ff.property(sp);
        String ip = this.aname("intProperty");
        PropertyName ipp = ff.property(ip);
        String dp = this.aname("doubleProperty");
        PropertyName dpp = ff.property(dp);
        Or orFilter = ff.or(Arrays.asList(ff.equal((Expression)spp, (Expression)ff.literal((Object)"zero"), true), ff.equal((Expression)ipp, (Expression)ff.literal(1), true), ff.equal((Expression)dpp, (Expression)ff.literal(0.0), true), ff.equal((Expression)spp, (Expression)ff.literal((Object)"two"), true), ff.equal((Expression)ipp, (Expression)ff.literal(2), true)));
        Filter[] filters = this.featureSource.getFeatureSource().splitFilter((Filter)orFilter);
        JDBCFeatureSourceOnlineTest.assertEquals((Object)filters[1], (Object)Filter.INCLUDE);
        SQLDialect dialect = this.featureSource.getDataStore().getSQLDialect();
        if (dialect instanceof BasicSQLDialect) {
            FilterToSQL filterToSQL = ((BasicSQLDialect)dialect).createFilterToSQL();
            String sql = filterToSQL.encodeToString(filters[0]);
            String spe = filterToSQL.escapeName(sp);
            String ipe = filterToSQL.escapeName(ip);
            String dpe = filterToSQL.escapeName(dp);
            JDBCFeatureSourceOnlineTest.assertEquals((String)("WHERE ((" + spe + " IN ('zero', 'two') AND " + spe + " IS NOT NULL ) OR (" + ipe + " IN (1, 2) AND " + ipe + " IS NOT NULL ) OR (" + dpe + " = 0.0 AND " + dpe + " IS NOT NULL ))"), (String)sql);
        } else if (dialect instanceof PreparedStatementSQLDialect) {
            PreparedFilterToSQL filterToSQL = ((PreparedStatementSQLDialect)dialect).createPreparedFilterToSQL();
            filterToSQL.setFeatureType(this.featureSource.getSchema());
            String sql = filterToSQL.encodeToString(filters[0]);
            String spe = filterToSQL.escapeName(sp);
            String ipe = filterToSQL.escapeName(ip);
            String dpe = filterToSQL.escapeName(dp);
            JDBCFeatureSourceOnlineTest.assertEquals((String)("WHERE ((" + spe + " IN (?, ?) AND " + spe + " IS NOT NULL ) OR (" + ipe + " IN (?, ?) AND " + ipe + " IS NOT NULL ) OR (" + dpe + " = ? AND " + dpe + " IS NOT NULL ))"), (String)sql);
            List literals = filterToSQL.getLiteralValues();
            JDBCFeatureSourceOnlineTest.assertEquals(this.getTestMixedEncodeInExpected(), (Object)literals);
        } else {
            JDBCFeatureSourceOnlineTest.fail((String)("Unexpected dialect, supports basic or prepared, but was a : " + dialect));
        }
    }

    public void testStringFunction() throws Exception {
        if (!this.dataStore.getFilterCapabilities().supports(FilterFunction_strToLowerCase.class)) {
            LOGGER.info("Ignoring testStringFunction test");
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        Function function = ff.function("strToLowerCase", new Expression[]{ff.property("stringProperty")});
        PropertyIsLike likeWithStringFunction = ff.like((Expression)function, "z%", "%", "-", "\\", true);
        JDBCFeatureSourceOnlineTest.assertEquals((int)1, (int)this.featureSource.getCount(new Query(null, (Filter)likeWithStringFunction)));
    }
}

