/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.List;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCTestSupport;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCFeatureReaderOnlineTest
extends JDBCTestSupport {
    public void testNext() throws Exception {
        Query query = new Query(this.tname("ft1"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            JDBCFeatureReaderOnlineTest.assertTrue((boolean)reader.hasNext());
            SimpleFeature feature = (SimpleFeature)reader.next();
            JDBCFeatureReaderOnlineTest.assertEquals((Object)feature.getName(), (Object)reader.getFeatureType().getName());
            int i = 0;
            for (PropertyDescriptor desc : reader.getFeatureType().getDescriptors()) {
                JDBCFeatureReaderOnlineTest.assertTrue((i < feature.getAttributeCount() ? 1 : 0) != 0);
                JDBCFeatureReaderOnlineTest.assertEquals((Object)feature.getAttribute(desc.getName()), (Object)feature.getAttribute(i++));
            }
            List attrs = feature.getAttributes();
            try {
                attrs.set(2, 1.1);
                feature.setAttributes(attrs);
            }
            catch (Exception e) {
                JDBCFeatureReaderOnlineTest.fail();
            }
            JDBCFeatureReaderOnlineTest.assertEquals(attrs.get(2), (Object)feature.getAttribute(2));
            Geometry g = (Geometry)feature.getDefaultGeometry();
            JDBCFeatureReaderOnlineTest.assertNotNull((Object)g);
            JDBCFeatureReaderOnlineTest.assertTrue((boolean)(g.getUserData() instanceof CoordinateReferenceSystem));
        }
    }
}

