/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Collections;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCFeatureLockingOnlineTest
extends JDBCTestSupport {
    JDBCFeatureStore store;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.store = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        this.store.setFeatureLock(FeatureLock.TRANSACTION);
    }

    public void testLockFeatures() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            SimpleFeature feature;
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            int locked = this.store.lockFeatures();
            JDBCFeatureLockingOnlineTest.assertTrue((locked > 0 ? 1 : 0) != 0);
            Query query = new Query(this.tname("ft1"));
            try (FeatureReader reader = this.dataStore.getFeatureReader(query, (Transaction)tx);){
                int count = 0;
                while (reader.hasNext()) {
                    ++count;
                    reader.next();
                }
                JDBCFeatureLockingOnlineTest.assertTrue((count > 0 ? 1 : 0) != 0);
            }
            try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);){
                JDBCFeatureLockingOnlineTest.assertTrue((boolean)writer.hasNext());
                feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                try {
                    writer.write();
                    JDBCFeatureLockingOnlineTest.fail((String)"should have thrown feature lock exception");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            tx.addAuthorization(lock.getAuthorization());
            writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
            try {
                JDBCFeatureLockingOnlineTest.assertTrue((boolean)writer.hasNext());
                feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                writer.write();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testLockFeaturesWithFilter() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
            int locked = this.store.lockFeatures((Filter)f);
            JDBCFeatureLockingOnlineTest.assertEquals((int)1, (int)locked);
            boolean failure = false;
            try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);){
                while (writer.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    Number old = (Number)feature.getAttribute(this.aname("intProperty"));
                    feature.setAttribute(this.aname("intProperty"), (Object)100);
                    if (Integer.valueOf(1).equals(old.intValue())) {
                        try {
                            writer.write();
                            JDBCFeatureLockingOnlineTest.fail((String)"writer should have thrown exception for locked feature");
                            continue;
                        }
                        catch (FeatureLockException e) {
                            failure = true;
                            continue;
                        }
                    }
                    writer.write();
                }
            }
            JDBCFeatureLockingOnlineTest.assertTrue((boolean)failure);
            return;
        }
    }

    public void testLockFeaturesWithInvalidFilter() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
            try {
                this.store.lockFeatures((Filter)f);
                JDBCFeatureLockingOnlineTest.fail((String)"Should have failed with an exception, the filter is not valid");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testLockFeaturesWithInvalidQuery() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
            try {
                this.store.lockFeatures(new Query(this.store.getSchema().getTypeName(), (Filter)f));
                JDBCFeatureLockingOnlineTest.fail((String)"Should have failed with an exception, the filter is not valid");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testUnlockFeatures() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            SimpleFeature feature;
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            this.store.lockFeatures();
            try (FeatureWriter writer2 = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);){
                JDBCFeatureLockingOnlineTest.assertTrue((boolean)writer2.hasNext());
                feature = (SimpleFeature)writer2.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                try {
                    writer2.write();
                    JDBCFeatureLockingOnlineTest.fail((String)"write should have thrown exception");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            try {
                this.store.unLockFeatures();
                JDBCFeatureLockingOnlineTest.fail((String)"unlock should have thrown an exception");
            }
            catch (FeatureLockException writer2) {
                // empty catch block
            }
            tx.addAuthorization(lock.getAuthorization());
            this.store.unLockFeatures();
            writer2 = this.dataStore.getFeatureWriter(this.tname("ft1"), (Transaction)tx);
            try {
                JDBCFeatureLockingOnlineTest.assertTrue((boolean)writer2.hasNext());
                feature = (SimpleFeature)writer2.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                writer2.write();
            }
            finally {
                if (writer2 != null) {
                    writer2.close();
                }
            }
        }
    }

    public void testUnlockFeaturesInvalidFilter() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            tx.addAuthorization(lock.getAuthorization());
            this.store.lockFeatures();
            FilterFactory ff = this.dataStore.getFilterFactory();
            PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("invalidProperty")), (Expression)ff.literal(1));
            try {
                this.store.unLockFeatures(new Query(this.store.getSchema().getTypeName(), (Filter)f));
                JDBCFeatureLockingOnlineTest.fail((String)"Should have failed with an exception, the filter is not valid");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.store.unLockFeatures();
        }
    }

    public void testDeleteLockedFeatures() throws Exception {
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            tx.addAuthorization(lock.getAuthorization());
            FilterFactory ff = this.dataStore.getFilterFactory();
            Id f1 = ff.id(Collections.singleton(ff.featureId(this.tname("ft1") + ".1")));
            JDBCFeatureLockingOnlineTest.assertEquals((int)1, (int)this.store.lockFeatures((Filter)f1));
            try (DefaultTransaction tx1 = new DefaultTransaction();){
                this.store.setTransaction((Transaction)tx1);
                try {
                    this.store.removeFeatures((Filter)f1);
                    JDBCFeatureLockingOnlineTest.fail((String)"Locked feature should not be deleted.");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            this.store.setTransaction((Transaction)tx);
            this.store.removeFeatures((Filter)f1);
            tx.commit();
        }
    }

    public void testModifyLockedFeatures() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f0 = ff.equal((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1000), true);
        JDBCFeatureLockingOnlineTest.assertEquals((int)0, (int)this.store.getCount(new Query(this.tname("ft1"), (Filter)f0)));
        FeatureLock lock = new FeatureLock(this.tname("ft1"), 3600000L);
        try (DefaultTransaction tx = new DefaultTransaction();){
            Integer v;
            this.store.setTransaction((Transaction)tx);
            this.store.setFeatureLock(lock);
            tx.addAuthorization(lock.getAuthorization());
            Id f1 = ff.id(Collections.singleton(ff.featureId(this.tname("ft1") + ".1")));
            this.store.lockFeatures((Filter)f1);
            NameImpl intProperty = new NameImpl(this.aname("intProperty"));
            try (DefaultTransaction tx1 = new DefaultTransaction();){
                this.store.setTransaction((Transaction)tx1);
                v = 1000;
                try {
                    this.store.modifyFeatures((Name)intProperty, (Object)v, (Filter)f1);
                    JDBCFeatureLockingOnlineTest.fail((String)"Locked feature should not be modified.");
                }
                catch (FeatureLockException featureLockException) {
                    // empty catch block
                }
            }
            this.store.setTransaction((Transaction)tx);
            this.store.modifyFeatures((Name)intProperty, (Object)v, (Filter)f1);
            tx.commit();
            JDBCFeatureLockingOnlineTest.assertEquals((int)1, (int)this.store.getCount(new Query(this.tname("ft1"), (Filter)f0)));
        }
    }
}

