/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCFeatureCollectionOnlineTest
extends JDBCTestSupport {
    SimpleFeatureCollection collection;
    JDBCFeatureStore source;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.source = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        this.collection = this.source.getFeatures();
    }

    public void testIterator() throws Exception {
        SimpleFeatureIterator i = this.collection.features();
        JDBCFeatureCollectionOnlineTest.assertNotNull((Object)i);
        this.assertFeatureIterator(0, 3, i, (JDBCTestSupport.FeatureAssertion)new JDBCTestSupport.SimpleFeatureAssertion(){

            @Override
            public int toIndex(SimpleFeature feature) {
                return ((Number)feature.getAttribute(JDBCFeatureCollectionOnlineTest.this.aname("intProperty"))).intValue();
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                TestCase.assertNotNull((Object)feature);
                String fid = feature.getID();
                int id = Integer.parseInt(fid.substring(fid.indexOf(46) + 1));
                TestCase.assertEquals((int)index, (int)id);
            }
        });
    }

    public void testBounds() throws IOException {
        ReferencedEnvelope bounds = this.collection.getBounds();
        JDBCFeatureCollectionOnlineTest.assertNotNull((Object)bounds);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)0.0, (double)bounds.getMinX(), (double)0.1);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)0.0, (double)bounds.getMinY(), (double)0.1);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)2.0, (double)bounds.getMaxX(), (double)0.1);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)2.0, (double)bounds.getMaxY(), (double)0.1);
    }

    public void testSize() throws IOException {
        JDBCFeatureCollectionOnlineTest.assertEquals((int)3, (int)this.collection.size());
    }

    public void testSubCollection() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        SimpleFeatureCollection sub = this.collection.subCollection((Filter)f);
        JDBCFeatureCollectionOnlineTest.assertNotNull((Object)sub);
        JDBCFeatureCollectionOnlineTest.assertEquals((int)1, (int)sub.size());
        ReferencedEnvelope exp = new ReferencedEnvelope(1.0, 1.0, 1.0, 1.0, CRS.decode((String)"EPSG:4326"));
        ReferencedEnvelope act = sub.getBounds();
        JDBCFeatureCollectionOnlineTest.assertEquals((double)exp.getMinX(), (double)act.getMinX(), (double)0.1);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)exp.getMinY(), (double)act.getMinY(), (double)0.1);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)exp.getMaxX(), (double)act.getMaxX(), (double)0.1);
        JDBCFeatureCollectionOnlineTest.assertEquals((double)exp.getMaxY(), (double)act.getMaxY(), (double)0.1);
    }

    public void testAdd() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)this.collection.getSchema());
        b.set(this.aname("intProperty"), (Object)3);
        b.set(this.aname("doubleProperty"), (Object)3.3);
        b.set(this.aname("stringProperty"), (Object)"three");
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        SimpleFeature feature = b.buildFeature(null);
        JDBCFeatureCollectionOnlineTest.assertEquals((int)3, (int)this.collection.size());
        this.source.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        JDBCFeatureCollectionOnlineTest.assertEquals((int)4, (int)this.collection.size());
        try (SimpleFeatureIterator i = this.collection.features();){
            boolean found = false;
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                if (!"three".equals(f.getAttribute(this.aname("stringProperty")))) continue;
                JDBCFeatureCollectionOnlineTest.assertEquals((double)((Double)feature.getAttribute(this.aname("doubleProperty"))), (double)((Double)f.getAttribute(this.aname("doubleProperty"))), (double)1.0E-5);
                JDBCFeatureCollectionOnlineTest.assertEquals((Object)feature.getAttribute(this.aname("stringProperty")), (Object)f.getAttribute(this.aname("stringProperty")));
                JDBCFeatureCollectionOnlineTest.assertEquals((Object)feature.getAttribute(this.aname("geometry")), (Object)f.getAttribute(this.aname("geometry")));
                found = true;
            }
            JDBCFeatureCollectionOnlineTest.assertTrue((boolean)found);
        }
    }
}

