/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.jdbc.JDBCEscapingTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCEscapingOnlineTest
extends JDBCTestSupport {
    protected SimpleFeatureType escapingSchema;
    protected static final String ESCAPING = "esca\"ping";
    protected static final String ID = "i\"d";
    protected static final String NAME = "na\"me";

    @Override
    protected abstract JDBCEscapingTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.escapingSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + ESCAPING), (String)"i\"d:0,na\"me:String");
    }

    public void testEscaping() throws Exception {
        this.dataStore.createSchema(this.escapingSchema);
        this.assertFeatureTypesEqual(this.escapingSchema, this.dataStore.getSchema(this.tname(ESCAPING)));
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname(ESCAPING), Transaction.AUTO_COMMIT);){
            SimpleFeature f = (SimpleFeature)fw.next();
            f.setAttribute(this.aname(ID), (Object)1);
            f.setAttribute(this.aname(NAME), (Object)"abc");
            fw.write();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(ESCAPING)).getFeatures();
        JDBCEscapingOnlineTest.assertEquals((int)1, (int)fc.size());
        try (SimpleFeatureIterator fr = fc.features();){
            JDBCEscapingOnlineTest.assertTrue((boolean)fr.hasNext());
            fr.next();
            JDBCEscapingOnlineTest.assertFalse((boolean)fr.hasNext());
        }
    }
}

