/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCEmptyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;

public abstract class JDBCEmptyOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCEmptyTestSetup createTestSetup();

    public void testFeatureSource() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("empty"));
        JDBCEmptyOnlineTest.assertNotNull((Object)fs);
        ReferencedEnvelope bounds = fs.getBounds();
        JDBCEmptyOnlineTest.assertTrue((boolean)bounds.isNull());
        int count = fs.getCount(Query.ALL);
        JDBCEmptyOnlineTest.assertEquals((int)0, (int)count);
    }

    public void testFeatureCollection() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("empty"));
        FeatureCollection features = fs.getFeatures();
        JDBCEmptyOnlineTest.assertTrue((boolean)features.getBounds().isNull());
        JDBCEmptyOnlineTest.assertEquals((int)0, (int)features.size());
        try (FeatureIterator i = features.features();){
            JDBCEmptyOnlineTest.assertFalse((boolean)i.hasNext());
        }
    }
}

