/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.jdbc.JDBCFunctionOnlineTest;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.DWithin;

public abstract class JDBCDistanceFiltersTest
extends JDBCTestSupport {
    static final Point REFERENCE_POINT = new GeometryFactory().createPoint(new Coordinate(3.0, 3.0));
    static final Logger LOGGER = Logging.getLogger(JDBCFunctionOnlineTest.class);

    public void testDWithinGeographicKm() throws IOException {
        double pointDistance = 111.0 * Math.sqrt(2.0);
        this.assertDWithinFilter(0, pointDistance * 0.1, "km");
        this.assertDWithinFilter(0, pointDistance * 0.9, "km");
        this.assertDWithinFilter(1, pointDistance * 1.1, "km");
        this.assertDWithinFilter(2, pointDistance * 2.1, "km");
        this.assertDWithinFilter(3, pointDistance * 3.1, "km");
    }

    public void testDWithinGeographicMeter() throws IOException {
        double pointDistance = 111000.0 * Math.sqrt(2.0);
        this.assertDWithinFilter(0, pointDistance * 0.1, "m");
        this.assertDWithinFilter(0, pointDistance * 0.9, "m");
        this.assertDWithinFilter(1, pointDistance * 1.1, "m");
        this.assertDWithinFilter(2, pointDistance * 2.1, "m");
        this.assertDWithinFilter(3, pointDistance * 3.1, "m");
    }

    public void testDWithinGeographicMile() throws IOException {
        double pointDistance = 69.0 * Math.sqrt(2.0);
        this.assertDWithinFilter(0, pointDistance * 0.1, "mi");
        this.assertDWithinFilter(0, pointDistance * 0.9, "mi");
        this.assertDWithinFilter(1, pointDistance * 1.1, "mi");
        this.assertDWithinFilter(2, pointDistance * 2.1, "mi");
        this.assertDWithinFilter(3, pointDistance * 3.1, "mi");
    }

    public void testDWithinGeographicFeet() throws IOException {
        double pointDistance = 364320.0 * Math.sqrt(2.0);
        this.assertDWithinFilter(0, pointDistance * 0.1, "ft");
        this.assertDWithinFilter(0, pointDistance * 0.9, "ft");
        this.assertDWithinFilter(1, pointDistance * 1.1, "ft");
        this.assertDWithinFilter(2, pointDistance * 2.1, "ft");
        this.assertDWithinFilter(3, pointDistance * 3.1, "ft");
    }

    public void testBeyondGeographicKm() throws IOException {
        double pointDistance = 111.0 * Math.sqrt(2.0);
        this.assertBeyondFilter(3, pointDistance * 0.1, "km");
        this.assertBeyondFilter(3, pointDistance * 0.9, "km");
        this.assertBeyondFilter(2, pointDistance * 1.1, "km");
        this.assertBeyondFilter(1, pointDistance * 2.1, "km");
        this.assertBeyondFilter(0, pointDistance * 3.1, "km");
    }

    public void testBeyondGeographicMeter() throws IOException {
        double pointDistance = 111000.0 * Math.sqrt(2.0);
        this.assertBeyondFilter(3, pointDistance * 0.1, "m");
        this.assertBeyondFilter(3, pointDistance * 0.9, "m");
        this.assertBeyondFilter(2, pointDistance * 1.1, "m");
        this.assertBeyondFilter(1, pointDistance * 2.1, "m");
        this.assertBeyondFilter(0, pointDistance * 3.1, "m");
    }

    public void testBeyondGeographicMile() throws IOException {
        double pointDistance = 69.0 * Math.sqrt(2.0);
        this.assertBeyondFilter(3, pointDistance * 0.1, "mi");
        this.assertBeyondFilter(3, pointDistance * 0.9, "mi");
        this.assertBeyondFilter(2, pointDistance * 1.1, "mi");
        this.assertBeyondFilter(1, pointDistance * 2.1, "mi");
        this.assertBeyondFilter(0, pointDistance * 3.1, "mi");
    }

    public void testBeyondGeographicFeet() throws IOException {
        double pointDistance = 364320.0 * Math.sqrt(2.0);
        this.assertBeyondFilter(3, pointDistance * 0.1, "ft");
        this.assertBeyondFilter(3, pointDistance * 0.9, "ft");
        this.assertBeyondFilter(2, pointDistance * 1.1, "ft");
        this.assertBeyondFilter(1, pointDistance * 2.1, "ft");
        this.assertBeyondFilter(0, pointDistance * 3.1, "ft");
    }

    protected boolean areDistanceUnitsSupported() {
        LOGGER.info("Skipping dWithin with unit of measure calculation tests");
        return false;
    }

    private void assertDWithinFilter(int expectedMatches, double distance, String unit) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyName geomProperty = ff.property(this.aname("geometry"));
        ContentFeatureSource features = this.dataStore.getFeatureSource(this.tname("ft1"));
        DWithin filter = ff.dwithin((Expression)geomProperty, (Expression)ff.literal((Object)REFERENCE_POINT), distance, unit);
        ContentFeatureCollection fc = features.getFeatures((Filter)filter);
        JDBCDistanceFiltersTest.assertEquals((int)expectedMatches, (int)fc.size());
    }

    private void assertBeyondFilter(int expectedMatches, double distance, String unit) throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyName geomProperty = ff.property(this.aname("geometry"));
        ContentFeatureSource features = this.dataStore.getFeatureSource(this.tname("ft1"));
        Beyond filter = ff.beyond((Expression)geomProperty, (Expression)ff.literal((Object)REFERENCE_POINT), distance, unit);
        ContentFeatureCollection fc = features.getFeatures((Filter)filter);
        JDBCDistanceFiltersTest.assertEquals((int)expectedMatches, (int)fc.size());
    }
}

