/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCDateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCDateOnlineTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCDateTestSetup createTestSetup();

    public void testMappings() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("dates"));
        JDBCDateOnlineTest.assertEquals(Date.class, (Object)ft.getDescriptor(this.aname("d")).getType().getBinding());
        JDBCDateOnlineTest.assertEquals(Timestamp.class, (Object)ft.getDescriptor(this.aname("dt")).getType().getBinding());
        JDBCDateOnlineTest.assertEquals(Time.class, (Object)ft.getDescriptor(this.aname("t")).getType().getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFiltersByDate() throws Exception {
        boolean simple = false;
        if (this.dataStore.dialect instanceof PreparedStatementSQLDialect) {
            simple = true;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-dd-MM");
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone[] zones = new TimeZone[]{TimeZone.getTimeZone("Etc/GMT+12"), TimeZone.getTimeZone("PST"), TimeZone.getTimeZone("EST"), TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("CET"), TimeZone.getTimeZone("Etc/GMT-12"), TimeZone.getTimeZone("Etc/GMT-14")};
        if (simple) {
            zones = new TimeZone[]{originalTimeZone};
        }
        try {
            for (TimeZone zone : zones) {
                ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
                TimeZone.setDefault(zone);
                this.setup.setUpData();
                df.setTimeZone(zone);
                PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property(this.aname("d")), (Expression)ff.literal((Object)df.parse("2009-28-06")));
                JDBCDateOnlineTest.assertEquals((String)("wrong number of records for " + zone.getDisplayName()), (int)2, (int)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
            }
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
            this.setup.setUpData();
        }
    }

    public void testFilterByTimeStamp() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)"2009-06-28 15:12:41"));
        JDBCDateOnlineTest.assertEquals((int)1, (int)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
        f = ff.equals((Expression)ff.property(this.aname("dt")), (Expression)ff.literal((Object)new SimpleDateFormat("HH:mm:ss,dd-yyyy-MM").parse("15:12:41,28-2009-06")));
        JDBCDateOnlineTest.assertEquals((int)1, (int)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
    }

    public void testFilterByTime() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsGreaterThanOrEqualTo f = ff.greaterOrEqual((Expression)ff.property(this.aname("t")), (Expression)ff.literal((Object)"13:10:12"));
        JDBCDateOnlineTest.assertEquals((int)3, (int)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
        f = ff.greaterOrEqual((Expression)ff.property(this.aname("t")), (Expression)ff.literal((Object)new SimpleDateFormat("ss:HH:mm").parse("12:13:10")));
        JDBCDateOnlineTest.assertEquals((int)3, (int)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
    }
}

