/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.Index;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCDataStoreOnlineTest
extends JDBCTestSupport {
    public void testGetNames() throws IOException {
        String[] typeNames = this.dataStore.getTypeNames();
        JDBCDataStoreOnlineTest.assertTrue((boolean)new HashSet<String>(Arrays.asList(typeNames)).contains(this.tname("ft1")));
    }

    public void testGetSchema() throws Exception {
        SimpleFeatureType ft1 = this.dataStore.getSchema(this.tname("ft1"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft1);
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft1.getDescriptor(this.aname("geometry")));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft1.getDescriptor(this.aname("intProperty")));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft1.getDescriptor(this.aname("doubleProperty")));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft1.getDescriptor(this.aname("stringProperty")));
        JDBCDataStoreOnlineTest.assertTrue((boolean)Geometry.class.isAssignableFrom(ft1.getDescriptor(this.aname("geometry")).getType().getBinding()));
        JDBCDataStoreOnlineTest.assertTrue((boolean)Number.class.isAssignableFrom(ft1.getDescriptor(this.aname("intProperty")).getType().getBinding()));
        JDBCDataStoreOnlineTest.assertEquals(Double.class, (Object)ft1.getDescriptor(this.aname("doubleProperty")).getType().getBinding());
        JDBCDataStoreOnlineTest.assertEquals(String.class, (Object)ft1.getDescriptor(this.aname("stringProperty")).getType().getBinding());
    }

    public void testCreateSchema() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("dateProperty"), Date.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        this.assertEqualsLax(ft2, featureType);
        JDBCDataStoreOnlineTest.assertNotSame((Object)ft2, (Object)featureType);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ");
        if (this.dataStore.getDatabaseSchema() != null) {
            this.dataStore.getSQLDialect().encodeSchemaName(this.dataStore.getDatabaseSchema(), sql);
            sql.append(".");
        }
        this.dataStore.getSQLDialect().encodeTableName("ft2", sql);
        try (Connection cx = this.dataStore.createConnection();
             Statement st = cx.createStatement();){
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs != null) {
                rs.close();
            }
        }
    }

    public void testCreateSchemaWithConstraints() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(CRS.decode((String)"EPSG:4326"));
        builder.add(this.aname("geometry"), Geometry.class);
        builder.nillable(false).add(this.aname("intProperty"), Integer.class);
        builder.length(5).add(this.aname("stringProperty"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        try (FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("ft2"), Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            f.setAttribute(1, (Object)0);
            f.setAttribute(2, (Object)"hello");
            w.write();
            w.hasNext();
            f = (SimpleFeature)w.next();
            f.setAttribute(1, null);
            try {
                w.write();
                JDBCDataStoreOnlineTest.fail((String)"null value for intProperty should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            f.setAttribute(1, (Object)1);
            f.setAttribute(2, (Object)"hello!");
            try {
                w.write();
                JDBCDataStoreOnlineTest.fail((String)"string greather than 5 chars should have failed");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testRemoveSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("ft1"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft);
        this.dataStore.removeSchema(this.tname("ft1"));
        try {
            this.dataStore.getSchema(this.tname("ft1"));
            JDBCDataStoreOnlineTest.fail((String)"getSchema() should fail if table was deleted");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSimpleIndex() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("ft1"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft);
        String ft1TypeName = ft.getTypeName();
        List indexes = this.dataStore.getIndexes(ft1TypeName);
        JDBCDataStoreOnlineTest.assertNotNull((Object)indexes);
        int initialSize = indexes.size();
        String indexName = "ft1_str_index";
        Index stringIndex = new Index(ft1TypeName, indexName, false, new String[]{this.aname("stringProperty")});
        this.dataStore.createIndex(stringIndex);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        JDBCDataStoreOnlineTest.assertEquals((int)(initialSize + 1), (int)indexes.size());
        for (Index index : indexes) {
            JDBCDataStoreOnlineTest.assertEquals((String)ft1TypeName, (String)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            List attributes = index.getAttributes();
            JDBCDataStoreOnlineTest.assertEquals((int)1, (int)attributes.size());
            JDBCDataStoreOnlineTest.assertEquals((String)this.aname("stringProperty"), (String)((String)attributes.get(0)));
            JDBCDataStoreOnlineTest.assertFalse((boolean)index.isUnique());
        }
        this.dataStore.dropIndex(ft1TypeName, indexName);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        JDBCDataStoreOnlineTest.assertEquals((int)initialSize, (int)indexes.size());
        for (Index index : indexes) {
            JDBCDataStoreOnlineTest.assertEquals((String)ft1TypeName, (String)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            JDBCDataStoreOnlineTest.fail((String)"the index has not been removed");
        }
    }

    public void testMultiColumnIndex() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("ft1"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft);
        String ft1TypeName = ft.getTypeName();
        List indexes = this.dataStore.getIndexes(ft1TypeName);
        JDBCDataStoreOnlineTest.assertNotNull((Object)indexes);
        int initialSize = indexes.size();
        String indexName = "ft1_str_index";
        Index stringIndex = new Index(ft1TypeName, indexName, false, new String[]{this.aname("stringProperty"), this.aname("intProperty")});
        this.dataStore.createIndex(stringIndex);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        JDBCDataStoreOnlineTest.assertEquals((int)(initialSize + 1), (int)indexes.size());
        for (Index index : indexes) {
            JDBCDataStoreOnlineTest.assertEquals((String)ft1TypeName, (String)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            List attributes = index.getAttributes();
            JDBCDataStoreOnlineTest.assertEquals((int)2, (int)attributes.size());
            JDBCDataStoreOnlineTest.assertEquals((String)this.aname("stringProperty"), (String)((String)attributes.get(0)));
            JDBCDataStoreOnlineTest.assertEquals((String)this.aname("intProperty"), (String)((String)attributes.get(1)));
        }
        this.dataStore.dropIndex(ft1TypeName, indexName);
        indexes = this.dataStore.getIndexes(ft1TypeName);
        JDBCDataStoreOnlineTest.assertEquals((int)initialSize, (int)indexes.size());
        for (Index index : indexes) {
            JDBCDataStoreOnlineTest.assertEquals((String)ft1TypeName, (String)index.getTypeName());
            if (!index.getIndexName().equals(indexName)) continue;
            JDBCDataStoreOnlineTest.fail((String)"the index has not been removed");
        }
    }

    public void testCreateSchemaUTMCRS() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(this.getUTMCRS());
        builder.add(this.aname("geometry"), Point.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("stringProperty"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft2);
        try (FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("ft2"), Transaction.AUTO_COMMIT);){
            w.hasNext();
            SimpleFeature f = (SimpleFeature)w.next();
            Geometry g = new WKTReader().read("POINT(593493 4914730)");
            g.setSRID(26713);
            f.setAttribute(0, (Object)g);
            f.setAttribute(1, (Object)0);
            f.setAttribute(2, (Object)"hello");
            w.write();
        }
        this.dataStore.getEntry((Name)new NameImpl(this.dataStore.getNamespaceURI(), this.tname("ft2"))).dispose();
        ft2 = this.dataStore.getSchema(this.tname("ft2"));
        JDBCDataStoreOnlineTest.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)this.getUTMCRS(), (Object)ft2.getCoordinateReferenceSystem()));
    }

    protected CoordinateReferenceSystem getUTMCRS() throws FactoryException {
        return CRS.decode((String)"EPSG:26713");
    }

    public void testCreateSchemaFidColumn() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.tname("ft2"));
        builder.setNamespaceURI(this.dataStore.getNamespaceURI());
        builder.setCRS(this.getUTMCRS());
        builder.add(this.aname("geometry"), Point.class);
        builder.add(this.aname("intProperty"), Integer.class);
        builder.add(this.aname("stringProperty"), String.class);
        builder.add(this.aname("fid"), String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        this.dataStore.createSchema(featureType);
        SimpleFeatureType ft2 = this.dataStore.getSchema(this.tname("ft2"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)ft2.getDescriptor(this.aname("fid")));
    }

    void assertEqualsLax(SimpleFeatureType e, SimpleFeatureType a) {
        if (e.equals(a)) {
            return;
        }
        JDBCDataStoreOnlineTest.assertEquals((int)e.getAttributeCount(), (int)a.getAttributeCount());
        for (int i = 0; i < e.getAttributeCount(); ++i) {
            AttributeDescriptor att1 = e.getDescriptor(i);
            AttributeDescriptor att2 = a.getDescriptor(i);
            JDBCDataStoreOnlineTest.assertEquals((Object)att1.getName(), (Object)att2.getName());
            JDBCDataStoreOnlineTest.assertEquals((int)att1.getMinOccurs(), (int)att2.getMinOccurs());
            JDBCDataStoreOnlineTest.assertEquals((int)att1.getMaxOccurs(), (int)att2.getMaxOccurs());
            JDBCDataStoreOnlineTest.assertEquals((boolean)att1.isNillable(), (boolean)att2.isNillable());
            JDBCDataStoreOnlineTest.assertEquals((Object)att1.getDefaultValue(), (Object)att2.getDefaultValue());
            AttributeType t1 = att1.getType();
            AttributeType t2 = att2.getType();
            JDBCDataStoreOnlineTest.assertEquals((Object)t1.getName(), (Object)t2.getName());
            JDBCDataStoreOnlineTest.assertEquals((Object)t1.getDescription(), (Object)t2.getDescription());
            JDBCDataStoreOnlineTest.assertEquals((Object)t1.getRestrictions(), (Object)t2.getRestrictions());
            if (t1.getBinding().equals(t2.getBinding())) continue;
            if (Number.class.isAssignableFrom(t1.getBinding())) {
                JDBCDataStoreOnlineTest.assertTrue((boolean)Number.class.isAssignableFrom(t2.getBinding()));
            }
            if (!Date.class.isAssignableFrom(t2.getBinding())) continue;
            JDBCDataStoreOnlineTest.assertTrue((boolean)Date.class.isAssignableFrom(t2.getBinding()));
        }
    }

    public void testGetFeatureSource() throws Exception {
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname("ft1"));
        JDBCDataStoreOnlineTest.assertNotNull((Object)featureSource);
    }

    public void testGetFeatureReader() throws Exception {
        final GeometryFactory gf = this.dataStore.getGeometryFactory();
        Query query = new Query(this.tname("ft1"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            this.assertFeatureReader(0, 3, reader, new JDBCTestSupport.SimpleFeatureAssertion(){

                @Override
                public int toIndex(SimpleFeature feature) {
                    return ((Number)feature.getAttribute(JDBCDataStoreOnlineTest.this.aname("intProperty"))).intValue();
                }

                @Override
                public void check(int index, SimpleFeature feature) {
                    TestCase.assertEquals((int)4, (int)feature.getAttributeCount());
                    Point p = gf.createPoint(new Coordinate((double)index, (double)index));
                    TestCase.assertTrue((boolean)p.equalsExact((Geometry)feature.getAttribute(JDBCDataStoreOnlineTest.this.aname("geometry"))));
                    Number ip = (Number)feature.getAttribute(JDBCDataStoreOnlineTest.this.aname("intProperty"));
                    TestCase.assertEquals((int)index, (int)ip.intValue());
                }
            });
        }
        query.setPropertyNames(new String[]{this.aname("intProperty")});
        reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);
        try {
            for (int i = 0; i < 3; ++i) {
                JDBCDataStoreOnlineTest.assertTrue((boolean)reader.hasNext());
                SimpleFeature feature = (SimpleFeature)reader.next();
                JDBCDataStoreOnlineTest.assertEquals((int)1, (int)feature.getAttributeCount());
            }
            JDBCDataStoreOnlineTest.assertFalse((boolean)reader.hasNext());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        query.setFilter((Filter)f);
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            for (int i = 0; i < 1; ++i) {
                JDBCDataStoreOnlineTest.assertTrue((boolean)reader.hasNext());
                SimpleFeature simpleFeature = (SimpleFeature)reader.next();
            }
            JDBCDataStoreOnlineTest.assertFalse((boolean)reader.hasNext());
        }
    }

    public void testGetFeatureWriter() throws IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("stringProperty"), (Object)"foo");
                writer.write();
            }
        }
        Query query = new Query(this.tname("ft1"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(query, Transaction.AUTO_COMMIT);){
            JDBCDataStoreOnlineTest.assertTrue((boolean)reader.hasNext());
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                JDBCDataStoreOnlineTest.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
            }
        }
    }

    public void testGetFeatureWriterWithFilter() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(100));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures((Filter)f);
        JDBCDataStoreOnlineTest.assertEquals((int)0, (int)features.size());
        f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), (Filter)f, Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)100);
                writer.write();
            }
        }
        f = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(100));
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures((Filter)f);
        JDBCDataStoreOnlineTest.assertEquals((int)1, (int)features.size());
    }

    public void testGetFeatureWriterAppend() throws IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), Transaction.AUTO_COMMIT);){
            for (int i = 3; i < 6; ++i) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute(this.aname("intProperty"), (Object)i);
                writer.write();
            }
        }
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        JDBCDataStoreOnlineTest.assertEquals((int)6, (int)features.size());
    }

    @Override
    protected HashMap createDataStoreFactoryParams() throws Exception {
        HashMap params = super.createDataStoreFactoryParams();
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 1);
        return params;
    }
}

