/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.FilterFunction_geometryType;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStoreAPITestSetup;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.TestData;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCDataStoreAPIOnlineTest
extends JDBCTestSupport {
    private static final int LOCK_DURATION = 3600000;
    protected TestData td;
    protected boolean forceLongitudeFirst = false;

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.td == null) {
            this.td = new TestData(((JDBCDataStoreAPITestSetup)this.setup).getInitialPrimaryKeyValue());
            this.td.forceLongitudeFirst = this.forceLongitudeFirst;
            this.td.ROAD = this.tname(this.td.ROAD);
            this.td.ROAD_ID = this.aname(this.td.ROAD_ID);
            this.td.ROAD_GEOM = this.aname(this.td.ROAD_GEOM);
            this.td.ROAD_NAME = this.aname(this.td.ROAD_NAME);
            this.td.RIVER = this.tname(this.td.RIVER);
            this.td.RIVER_ID = this.aname(this.td.RIVER_ID);
            this.td.RIVER_GEOM = this.aname(this.td.RIVER_GEOM);
            this.td.RIVER_FLOW = this.aname(this.td.RIVER_FLOW);
            this.td.RIVER_RIVER = this.aname(this.td.RIVER_RIVER);
            this.td.build();
        }
        if (this.setup.canResetSchema()) {
            this.dataStore.setDatabaseSchema(null);
        }
    }

    @Override
    protected abstract JDBCDataStoreAPITestSetup createTestSetup();

    public void testGetFeatureTypes() {
        try {
            Object[] names = this.dataStore.getTypeNames();
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(names, this.tname("road")));
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.contains(names, this.tname("river")));
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            JDBCDataStoreAPIOnlineTest.fail((String)"An IOException has been thrown!");
        }
    }

    public void testGetSchemaRoad() throws IOException {
        SimpleFeatureType expected = this.td.roadType;
        SimpleFeatureType actual = this.dataStore.getSchema(this.tname("road"));
        JDBCDataStoreAPIOnlineTest.assertEquals((String)"name", (Object)this.aname(expected.getName()), (Object)actual.getName());
        JDBCDataStoreAPIOnlineTest.assertEquals((String)"attributeCount", (int)expected.getAttributeCount(), (int)actual.getAttributeCount());
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            AttributeDescriptor expectedAttribute = expected.getDescriptor(i);
            AttributeDescriptor actualAttribute = actual.getDescriptor(i);
            this.assertAttributesEqual(expectedAttribute, actualAttribute);
        }
        GeometryDescriptor dg = actual.getGeometryDescriptor();
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)dg.isNillable());
        JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)dg.getMinOccurs());
    }

    public void testGetSchemaRiver() throws IOException {
        SimpleFeatureType expected = this.td.riverType;
        SimpleFeatureType actual = this.dataStore.getSchema(this.tname("river"));
        JDBCDataStoreAPIOnlineTest.assertEquals((String)"name", (Object)this.aname(expected.getName()), (Object)actual.getName());
        JDBCDataStoreAPIOnlineTest.assertEquals((String)"attributeCount", (int)expected.getAttributeCount(), (int)actual.getAttributeCount());
        this.assertFeatureTypesEqual(expected, actual);
    }

    public void testCreateSchema() throws Exception {
        String featureTypeName = this.tname("building");
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326", (boolean)this.forceLongitudeFirst);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(featureTypeName);
        ftb.add(this.aname("id"), Integer.class);
        ftb.add(this.aname("name"), String.class);
        ftb.add(this.aname("the_geom"), Point.class, crs);
        SimpleFeatureType newFT = ftb.buildFeatureType();
        this.dataStore.createSchema(newFT);
        SimpleFeatureType newSchema = this.dataStore.getSchema(featureTypeName);
        JDBCDataStoreAPIOnlineTest.assertNotNull((Object)newSchema);
        JDBCDataStoreAPIOnlineTest.assertEquals((int)3, (int)newSchema.getAttributeCount());
    }

    public void testGetFeatureReader() throws IOException, IllegalAttributeException {
        this.assertCovered(this.td.roadFeatures, this.reader(this.tname("road")));
        JDBCDataStoreAPIOnlineTest.assertEquals((int)3, (int)this.count(this.reader(this.tname("road"))));
    }

    public void testGeometryFactoryHintsGF() throws IOException {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("road"));
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_GEOMETRY_FACTORY));
        Query q = new Query(this.tname("road"));
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY, (Object)gf);
        q.setHints(hints);
        try (SimpleFeatureIterator it = fs.getFeatures(q).features();){
            it.hasNext();
            SimpleFeature f = (SimpleFeature)it.next();
            LineString ls = (LineString)f.getDefaultGeometry();
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)(ls.getCoordinateSequence() instanceof LiteCoordinateSequence));
        }
    }

    public void testGeometryFactoryHintsCS() throws IOException {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("road"));
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        Query q = new Query(this.tname("road"));
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        try (SimpleFeatureIterator it = fs.getFeatures(q).features();){
            it.hasNext();
            SimpleFeature f = (SimpleFeature)it.next();
            LineString ls = (LineString)f.getDefaultGeometry();
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)(ls.getCoordinateSequence() instanceof LiteCoordinateSequence));
        }
    }

    public void testGetFeatureReaderLake() throws IOException, IllegalFilterException {
        try (DefaultTransaction t = new DefaultTransaction();
             FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("lake")), (Transaction)t);){
            JDBCDataStoreAPIOnlineTest.assertNotNull((Object)reader);
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            JDBCDataStoreAPIOnlineTest.assertNotNull((Object)reader.next());
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        }
    }

    public void testGetFeatureReaderFilterPrePost() throws IOException, IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
        geomTypeExpr.setParameters(Collections.singletonList(factory.property(this.aname("geom"))));
        PropertyIsEqualTo filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"Polygon"));
        try (DefaultTransaction t = new DefaultTransaction();){
            try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)filter), (Transaction)t);){
                JDBCDataStoreAPIOnlineTest.assertNotNull((Object)reader);
                JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
            }
            filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"LineString"));
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)filter), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void testGetFeatureReaderFilterPrePostWithNoGeometry() throws IOException, IllegalFilterException {
        try (DefaultTransaction t = new DefaultTransaction();){
            FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
            FilterFunction_geometryType geomTypeExpr = new FilterFunction_geometryType();
            geomTypeExpr.setParameters(Collections.singletonList(factory.property(this.aname("geom"))));
            PropertyIsEqualTo filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"Polygon"));
            Query query = new Query(this.tname("road"), (Filter)filter);
            query.setPropertyNames(Collections.singletonList(this.aname("id")));
            try (FeatureReader reader = this.dataStore.getFeatureReader(query, (Transaction)t);){
                JDBCDataStoreAPIOnlineTest.assertNotNull((Object)reader);
            }
            filter = factory.equals((Expression)geomTypeExpr, (Expression)factory.literal((Object)"LineString"));
            query.setFilter((Filter)filter);
            reader = this.dataStore.getFeatureReader(query, (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void testGetFeatureReaderFilterWithAttributesNotRequested() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("river"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property(this.aname("flow")), (Expression)ff.literal(4.5));
        Query q = new Query(this.tname("river"));
        q.setPropertyNames(new String[]{this.aname("geom")});
        q.setFilter((Filter)f);
        try (DefaultTransaction t = new DefaultTransaction();
             FeatureReader reader = this.dataStore.getFeatureReader(q, (Transaction)t);){
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)((SimpleFeatureType)reader.getFeatureType()).getAttributeCount());
            reader.next();
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        }
    }

    public void testGetFeatureReaderFilterWithAttributesNotRequested2() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("river"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        FilterFunction_ceil ceil = new FilterFunction_ceil();
        ceil.setParameters(Collections.singletonList(ff.property(this.aname("flow"))));
        PropertyIsEqualTo f = ff.equals((Expression)ceil, (Expression)ff.literal(5));
        Query q = new Query(this.tname("river"));
        q.setPropertyNames(new String[]{this.aname("geom")});
        q.setFilter((Filter)f);
        try (DefaultTransaction t = new DefaultTransaction();
             FeatureReader reader = this.dataStore.getFeatureReader(q, (Transaction)t);){
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)reader.hasNext());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)((SimpleFeatureType)reader.getFeatureType()).getAttributeCount());
            reader.next();
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
        }
    }

    public void testGetFeatureInvalidFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        Query q = new Query(this.tname("river"));
        q.setPropertyNames(new String[]{this.aname("geom")});
        q.setFilter((Filter)f);
        try (FeatureReader reader = this.dataStore.getFeatureReader(q, Transaction.AUTO_COMMIT);){
            JDBCDataStoreAPIOnlineTest.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderMutability() throws IOException, IllegalAttributeException {
        SimpleFeature feature;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader(this.tname("road"));){
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                feature.setAttribute(this.aname("name"), null);
            }
        }
        try {
            reader = this.reader(this.tname("road"));
            try {
                while (reader.hasNext()) {
                    feature = (SimpleFeature)reader.next();
                    JDBCDataStoreAPIOnlineTest.assertNotNull((Object)feature.getAttribute(this.aname("name")));
                }
                reader.close();
                reader.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetFeatureReaderConcurrency() throws NoSuchElementException, IOException {
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader1 = this.reader(this.tname("road"));
             FeatureReader<SimpleFeatureType, SimpleFeature> reader2 = this.reader(this.tname("road"));
             FeatureReader<SimpleFeatureType, SimpleFeature> reader3 = this.reader(this.tname("river"));){
            while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
                this.assertContains(this.td.roadFeatures, (SimpleFeature)reader1.next());
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)reader2.hasNext());
                this.assertContains(this.td.roadFeatures, (SimpleFeature)reader2.next());
                if (!reader3.hasNext()) continue;
                this.assertContains(this.td.riverFeatures, (SimpleFeature)reader3.next());
            }
            try {
                JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader1.hasNext());
                reader1.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an NoSuchElementException");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader2.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an NoSuchElementException");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reader3.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an NoSuchElementException");
            }
            catch (Exception exception) {
                // empty catch block
            }
            reader1.close();
            reader2.close();
            reader3.close();
            try {
                reader1.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader2.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader3.next();
                JDBCDataStoreAPIOnlineTest.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("road"));
        try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);){
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)this.td.roadFeatures.length, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
        }
        reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        try {
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), Transaction.AUTO_COMMIT);
        try {
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException, IllegalAttributeException {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("road"));
        try (DefaultTransaction t = new DefaultTransaction();){
            try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), (Transaction)t);){
                JDBCDataStoreAPIOnlineTest.assertFalse((boolean)reader.hasNext());
                JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
                JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
                JDBCDataStoreAPIOnlineTest.assertEquals((int)this.td.roadFeatures.length, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)reader.getFeatureType());
                JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.INCLUDE, (Transaction)t);){
                while (writer.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    if (!feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                    writer.remove();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((int)(this.td.roadFeatures.length - 1), (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t.rollback();
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.EXCLUDE), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((int)this.td.roadFeatures.length, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), this.td.rd1Filter), (Transaction)t);
            try {
                JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count((FeatureReader<SimpleFeatureType, SimpleFeature>)reader));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void testGetFeatureWriterClose() throws Exception {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);){
            writer.close();
            try {
                JDBCDataStoreAPIOnlineTest.assertFalse((boolean)writer.hasNext());
                JDBCDataStoreAPIOnlineTest.fail((String)"Should not be able to use a closed writer");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JDBCDataStoreAPIOnlineTest.assertNull((Object)writer.next());
                JDBCDataStoreAPIOnlineTest.fail((String)"Should not be able to use a closed writer");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testGetFeatureWriterRemove() throws IOException {
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(this.tname("road"));){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                writer.remove();
            }
        }
        JDBCDataStoreAPIOnlineTest.assertEquals((int)(this.td.roadFeatures.length - 1), (int)this.count(this.tname("road")));
    }

    public void testGetFeatureWriterRemoveAll() throws IOException {
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(this.tname("road"));){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                writer.remove();
            }
        }
        JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count(this.tname("road")));
    }

    public void testGetFeaturesWriterAdd() throws IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), Transaction.AUTO_COMMIT);){
            SimpleFeature feature;
            while (writer.hasNext()) {
                feature = (SimpleFeature)writer.next();
            }
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)writer.hasNext());
            feature = (SimpleFeature)writer.next();
            feature.setAttributes(this.td.newRoad.getAttributes());
            writer.write();
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)writer.hasNext());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)(this.td.roadFeatures.length + 1), (int)this.count(this.tname("road")));
        }
    }

    public void testGetFeaturesWriterModify() throws IOException {
        try (FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer(this.tname("road"));){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                feature.setAttribute(this.aname("name"), (Object)"changed");
                writer.write();
            }
        }
        SimpleFeature feature = this.feature(this.tname("road"), this.td.roadFeatures[0].getID());
        JDBCDataStoreAPIOnlineTest.assertNotNull((Object)feature);
        JDBCDataStoreAPIOnlineTest.assertEquals((Object)"changed", (Object)feature.getAttribute(this.aname("name")));
    }

    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), Transaction.AUTO_COMMIT);){
            JDBCDataStoreAPIOnlineTest.assertEquals((int)this.td.roadFeatures.length, (int)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
    }

    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        try (FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("road"), Transaction.AUTO_COMMIT);){
            JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
    }

    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.EXCLUDE, Transaction.AUTO_COMMIT);){
            JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
        writer = this.dataStore.getFeatureWriter(this.tname("road"), (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
        try {
            JDBCDataStoreAPIOnlineTest.assertEquals((int)this.td.roadFeatures.length, (int)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        writer = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, Transaction.AUTO_COMMIT);
        try {
            JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void testGetFeatureWriterInvalidFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        try (FeatureWriter writer = this.dataStore.getFeatureWriter("river", (Filter)f, Transaction.AUTO_COMMIT);){
            JDBCDataStoreAPIOnlineTest.fail((String)"This query should have failed, it contains an invalid filter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTransactionIsolation() throws Exception {
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();){
            SimpleFeature[] ORIGINAL = this.td.roadFeatures;
            SimpleFeature[] REMOVE = new SimpleFeature[ORIGINAL.length - 1];
            SimpleFeature[] ADD = new SimpleFeature[ORIGINAL.length + 1];
            SimpleFeature[] FINAL = new SimpleFeature[ORIGINAL.length];
            try (FeatureWriter writer1 = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, (Transaction)t1);
                 FeatureWriter writer2 = this.dataStore.getFeatureWriterAppend(this.tname("road"), (Transaction)t2);){
                SimpleFeature feature;
                int i;
                int index = 0;
                for (i = 0; i < ORIGINAL.length; ++i) {
                    feature = ORIGINAL[i];
                    if (feature.getID().equals(this.td.roadFeatures[0].getID())) continue;
                    REMOVE[index++] = feature;
                }
                for (i = 0; i < ORIGINAL.length; ++i) {
                    ADD[i] = ORIGINAL[i];
                }
                ADD[i] = this.td.newRoad;
                for (i = 0; i < REMOVE.length; ++i) {
                    FINAL[i] = REMOVE[i];
                }
                FINAL[i] = this.td.newRoad;
                try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);){
                    JDBCDataStoreAPIOnlineTest.assertTrue((String)"Sanity check failed: before modification reader didn't match original content", (boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
                }
                while (writer1.hasNext()) {
                    feature = (SimpleFeature)writer1.next();
                    JDBCDataStoreAPIOnlineTest.assertEquals((String)this.td.roadFeatures[0].getID(), (String)feature.getID());
                    writer1.remove();
                }
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
                try {
                    JDBCDataStoreAPIOnlineTest.assertTrue((String)"Feature deletion managed to leak out of transaction?", (boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
                try {
                    JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                writer1.close();
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
                try {
                    JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
                try {
                    JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                feature = (SimpleFeature)writer2.next();
                feature.setAttributes(this.td.newRoad.getAttributes());
                writer2.write();
            }
            try (FeatureReader reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);){
                ADD[ADD.length - 1] = this.td.newRoad = this.findFeature((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, this.aname("name"), "r4");
                FINAL[FINAL.length - 1] = this.td.newRoad;
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                this.assertMatched(ADD, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t1.commit();
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t2.commit();
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t1);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.dataStore.getFeatureReader(new Query(this.tname("road"), (Filter)Filter.INCLUDE), (Transaction)t2);
            try {
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public void testGetFeatureWriterConcurrency() throws Exception {
        try (Connection conn = this.dataStore.getDataSource().getConnection();){
            int major = conn.getMetaData().getDatabaseMajorVersion();
            int minor = conn.getMetaData().getDatabaseMinorVersion();
            if (major <= 8 && (major != 8 || minor < 1)) {
                return;
            }
        }
        try (DefaultTransaction t1 = new DefaultTransaction();
             FeatureWriter writer1 = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, (Transaction)t1);){
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)writer1.hasNext());
            SimpleFeature f1 = (SimpleFeature)writer1.next();
            f1.setAttribute("name", (Object)new String("r1_"));
            writer1.write();
            try (DefaultTransaction t2 = new DefaultTransaction();
                 FeatureWriter writer2 = this.dataStore.getFeatureWriter(this.tname("road"), this.td.rd1Filter, (Transaction)t2);){
                JDBCDataStoreAPIOnlineTest.assertTrue((boolean)writer2.hasNext());
                SimpleFeature f2 = (SimpleFeature)writer2.next();
                f2.setAttribute("name", (Object)new String("r1__"));
                try {
                    writer2.write();
                    JDBCDataStoreAPIOnlineTest.fail((String)"Feature lock should have failed");
                }
                catch (FeatureLockException e) {
                    JDBCDataStoreAPIOnlineTest.assertEquals((String)(this.tname("road") + ".rd1"), (String)e.getFeatureID());
                }
                t1.rollback();
                t2.rollback();
            }
        }
    }

    public void testGetFeatureSourceRoad() throws Exception {
        ContentFeatureSource road = this.dataStore.getFeatureSource(this.tname("road"));
        this.assertFeatureTypesEqual(this.td.roadType, (SimpleFeatureType)road.getSchema());
        JDBCDataStoreAPIOnlineTest.assertSame((Object)this.dataStore, (Object)road.getDataStore());
        int count = road.getCount(Query.ALL);
        JDBCDataStoreAPIOnlineTest.assertTrue((count == 3 || count == -1 ? 1 : 0) != 0);
        ReferencedEnvelope bounds = road.getBounds(Query.ALL);
        JDBCDataStoreAPIOnlineTest.assertTrue((bounds == null || this.areReferencedEnvelopesEqual(bounds, this.td.roadBounds) ? 1 : 0) != 0);
        SimpleFeatureCollection all = road.getFeatures();
        JDBCDataStoreAPIOnlineTest.assertEquals((int)3, (int)all.size());
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.roadBounds, all.getBounds()));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.td.roadFeatures);
        this.assertCovers("all", expected, all);
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.roadBounds, all.getBounds()));
        SimpleFeatureCollection some = road.getFeatures(this.td.rd12Filter);
        JDBCDataStoreAPIOnlineTest.assertEquals((int)2, (int)some.size());
        ReferencedEnvelope e = new ReferencedEnvelope(CRS.decode((String)"EPSG:4326", (boolean)this.forceLongitudeFirst));
        e.include(this.td.roadFeatures[0].getBounds());
        e.include(this.td.roadFeatures[1].getBounds());
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(e, some.getBounds()));
        JDBCDataStoreAPIOnlineTest.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        Query query = new Query(this.tname("road"), this.td.rd12Filter, new String[]{this.aname("name")});
        SimpleFeatureCollection half = road.getFeatures(query);
        JDBCDataStoreAPIOnlineTest.assertEquals((int)2, (int)half.size());
        JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        try (SimpleFeatureIterator reader = half.features();){
            SimpleFeatureType type = (SimpleFeatureType)half.getSchema();
            SimpleFeatureType actual = ((SimpleFeature)reader.next()).getFeatureType();
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)type.getName(), (Object)actual.getName());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)type.getAttributeCount(), (int)actual.getAttributeCount());
            for (int i = 0; i < type.getAttributeCount(); ++i) {
                JDBCDataStoreAPIOnlineTest.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
            }
            JDBCDataStoreAPIOnlineTest.assertNull((Object)type.getGeometryDescriptor());
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)type, (Object)actual);
            ReferencedEnvelope b = half.getBounds();
            ReferencedEnvelope expectedBounds = this.td.roadBounds;
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(expectedBounds, b));
        }
    }

    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException, IllegalAttributeException {
        ContentFeatureSource river = this.dataStore.getFeatureSource(this.tname("river"));
        this.assertFeatureTypesEqual(this.td.riverType, (SimpleFeatureType)river.getSchema());
        JDBCDataStoreAPIOnlineTest.assertSame((Object)this.dataStore, (Object)river.getDataStore());
        SimpleFeatureCollection all = river.getFeatures();
        JDBCDataStoreAPIOnlineTest.assertEquals((int)2, (int)all.size());
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.riverBounds, all.getBounds()));
        JDBCDataStoreAPIOnlineTest.assertTrue((String)"rivers", (boolean)this.covers(all.features(), this.td.riverFeatures));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.td.riverFeatures);
        this.assertCovers("all", expected, all);
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.areReferencedEnvelopesEqual(this.td.riverBounds, all.getBounds()));
    }

    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        Integer changed = 5;
        road.modifyFeatures((Name)new NameImpl(this.aname("id")), (Object)changed, this.td.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.td.rd1Filter);
        try (SimpleFeatureIterator features = results.features();){
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)features.hasNext());
            JDBCDataStoreAPIOnlineTest.assertEquals((int)5, (int)((Number)((SimpleFeature)features.next()).getAttribute(this.aname("id"))).intValue());
        }
    }

    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Id rd1Filter = factory.id(Collections.singleton(factory.featureId(this.td.roadFeatures[0].getID())));
        road.modifyFeatures(new Name[]{new NameImpl(this.aname("name"))}, new Object[]{"changed"}, (Filter)rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.td.rd1Filter);
        try (SimpleFeatureIterator features = results.features();){
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)features.hasNext());
            JDBCDataStoreAPIOnlineTest.assertEquals((Object)"changed", (Object)((SimpleFeature)features.next()).getAttribute(this.aname("name")));
        }
    }

    public void testGetFeatureStoreModifyFeatures3() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("name")), (Expression)ff.literal((Object)"r1"));
        road.modifyFeatures(new Name[]{new NameImpl(this.aname("name"))}, new Object[]{"changed"}, (Filter)filter);
    }

    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        road.removeFeatures(this.td.rd1Filter);
        JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)road.getFeatures(this.td.rd1Filter).size());
        JDBCDataStoreAPIOnlineTest.assertEquals((int)(this.td.roadFeatures.length - 1), (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreRemoveAllFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        road.removeFeatures((Filter)Filter.INCLUDE);
        JDBCDataStoreAPIOnlineTest.assertEquals((int)0, (int)road.getFeatures().size());
    }

    public void testGetFeatureStoreAddFeatures() throws IOException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.td.newRoad});
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        road.addFeatures((FeatureCollection)DataUtilities.collection((FeatureReader)reader));
        JDBCDataStoreAPIOnlineTest.assertEquals((int)(this.td.roadFeatures.length + 1), (int)this.count(this.tname("road")));
    }

    public void testGetFeatureStoreSetFeatures() throws NoSuchElementException, IOException, IllegalAttributeException {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.td.newRoad});
        SimpleFeatureStore road = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("road"));
        JDBCDataStoreAPIOnlineTest.assertEquals((int)3, (int)this.count(this.tname("road")));
        road.setFeatures(reader);
        JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)this.count(this.tname("road")));
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.dataStore.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    public void testLockFeatures() throws IOException {
        FeatureLock lock = new FeatureLock("test", 3600000L);
        FeatureLocking road = (FeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
        road.setFeatureLock(lock);
        JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".1"));
        JDBCDataStoreAPIOnlineTest.assertTrue((road.lockFeatures() > 0 ? 1 : 0) != 0);
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".1"));
    }

    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = new FeatureLock("test", 3600000L);
        FeatureLocking road = (FeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            JDBCDataStoreAPIOnlineTest.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (DefaultTransaction t = new DefaultTransaction();){
            road.setTransaction((Transaction)t);
            try {
                road.unLockFeatures();
                JDBCDataStoreAPIOnlineTest.fail((String)"unlock should fail due lack of authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t.addAuthorization(lock.getAuthorization());
            road.unLockFeatures();
        }
    }

    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = new FeatureLock("LockA", 3600000L);
        FeatureLock lockB = new FeatureLock("LockB", 3600000L);
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();){
            FeatureLocking road1 = (FeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
            FeatureLocking road2 = (FeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
            road1.setTransaction((Transaction)t1);
            road2.setTransaction((Transaction)t2);
            road1.setFeatureLock(lockA);
            road2.setFeatureLock(lockB);
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".0"));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".1"));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + ".2"));
            JDBCDataStoreAPIOnlineTest.assertEquals((int)1, (int)road1.lockFeatures(this.td.rd1Filter));
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
            road2.lockFeatures(this.td.rd2Filter);
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
            try {
                road1.unLockFeatures(this.td.rd1Filter);
                JDBCDataStoreAPIOnlineTest.fail((String)"need authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t1.addAuthorization(lockA.getAuthorization());
            try {
                road1.unLockFeatures(this.td.rd2Filter);
                JDBCDataStoreAPIOnlineTest.fail((String)"need correct authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            road1.unLockFeatures(this.td.rd1Filter);
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
            t2.addAuthorization(lockB.getAuthorization());
            road2.unLockFeatures(this.td.rd2Filter);
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 1)));
            JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + (this.td.initialFidValue + 2)));
        }
    }

    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = new FeatureLock("Timed", 1000L);
        FeatureLocking road = (FeatureLocking)this.dataStore.getFeatureSource(this.tname("road"));
        road.setFeatureLock(lock);
        JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
        road.lockFeatures(this.td.rd1Filter);
        JDBCDataStoreAPIOnlineTest.assertTrue((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
        long then = System.currentTimeMillis();
        do {
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() - then < 1000L);
        JDBCDataStoreAPIOnlineTest.assertFalse((boolean)this.isLocked(this.tname("road"), this.tname("road") + "." + this.td.initialFidValue));
    }

    int count(String typeName) throws IOException {
        return this.dataStore.getFeatureSource(typeName).getFeatures().size();
    }

    int count(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        if (reader == null) {
            return -1;
        }
        int count = 0;
        try {
            while (reader.hasNext()) {
                reader.next();
                ++count;
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("hasNext() lied to me at:" + count, (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("next() could not understand feature at:" + count, (Throwable)e);
        }
        finally {
            reader.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                this.assertContains(features, (SimpleFeature)reader.next());
                ++count;
            }
        }
        finally {
            reader.close();
        }
        JDBCDataStoreAPIOnlineTest.assertEquals((int)features.length, (int)count);
    }

    void assertCovers(String msg, SimpleFeatureCollection c1, SimpleFeatureCollection c2) {
        if (c1 == c2) {
            return;
        }
        JDBCDataStoreAPIOnlineTest.assertNotNull((String)msg, (Object)c1);
        JDBCDataStoreAPIOnlineTest.assertNotNull((String)msg, (Object)c2);
        JDBCDataStoreAPIOnlineTest.assertEquals((String)(msg + " size"), (int)c1.size(), (int)c2.size());
        SimpleFeatureIterator i = null;
        i = c1.features();
        while (i.hasNext()) {
            SimpleFeature f = (SimpleFeature)i.next();
            boolean found = false;
            SimpleFeatureIterator j = null;
            j = c2.features();
            while (j.hasNext() && !found) {
                SimpleFeature g = (SimpleFeature)j.next();
                found = f.getID().equals(g.getID());
            }
            j.close();
            JDBCDataStoreAPIOnlineTest.assertTrue((String)(msg + " " + f.getID()), (boolean)found);
        }
        i.close();
    }

    void assertContains(SimpleFeature[] array, SimpleFeature expected) {
        JDBCDataStoreAPIOnlineTest.assertFalse((array == null ? 1 : 0) != 0);
        JDBCDataStoreAPIOnlineTest.assertFalse((array.length == 0 ? 1 : 0) != 0);
        JDBCDataStoreAPIOnlineTest.assertNotNull((Object)expected);
        for (int i = 0; i < array.length; ++i) {
            if (!this.id(array[i].getID(), array[i]).equals(expected.getID())) continue;
            return;
        }
        JDBCDataStoreAPIOnlineTest.fail((String)("Contains " + expected));
    }

    String id(String raw, SimpleFeature f) {
        if (raw == null) {
            return null;
        }
        if (raw.startsWith(f.getType().getTypeName() + ".")) {
            return this.tname(f.getType().getTypeName()) + raw.substring(f.getType().getTypeName().length());
        }
        return raw;
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(expected)) continue;
            return true;
        }
        return false;
    }

    FeatureReader<SimpleFeatureType, SimpleFeature> reader(String typeName) throws IOException {
        return this.dataStore.getFeatureReader(new Query(typeName, (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
    }

    FeatureWriter<SimpleFeatureType, SimpleFeature> writer(String typeName) throws IOException {
        return this.dataStore.getFeatureWriter(typeName, Transaction.AUTO_COMMIT);
    }

    protected int count(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (writer.hasNext()) {
                writer.next();
                ++count;
            }
        }
        finally {
            writer.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeature feature(String typeName, String fid) throws NoSuchElementException, IOException, IllegalAttributeException {
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.reader(typeName);){
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (!fid.equals(f.getID())) continue;
                SimpleFeature simpleFeature = f;
                return simpleFeature;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(SimpleFeatureIterator reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertContains(array, feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertContains(array, feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature[] array) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        return count == array.length;
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getID().equals(expected.getID())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFeature findFeature(FeatureReader<SimpleFeatureType, SimpleFeature> reader, String attributeName, Object value) throws NoSuchElementException, IOException, IllegalAttributeException {
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                if (attributeName == null) {
                    if (!value.equals(f.getID())) continue;
                    SimpleFeature simpleFeature = f;
                    return simpleFeature;
                }
                if (!value.equals(f.getAttribute(attributeName))) continue;
                SimpleFeature simpleFeature = f;
                return simpleFeature;
            }
        }
        finally {
            reader.close();
        }
        if (attributeName == null) {
            throw new NoSuchElementException("No match for FID=" + value);
        }
        throw new NoSuchElementException("No match for " + attributeName + "=" + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertMatched(SimpleFeature[] array, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws Exception {
        int count = 0;
        try {
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                this.assertMatch(array, feature);
                ++count;
            }
        }
        finally {
            reader.close();
        }
        JDBCDataStoreAPIOnlineTest.assertEquals((String)"array not matched by reader", (int)array.length, (int)count);
    }

    void assertMatch(SimpleFeature[] array, SimpleFeature feature) {
        int i;
        JDBCDataStoreAPIOnlineTest.assertTrue((array != null ? 1 : 0) != 0);
        JDBCDataStoreAPIOnlineTest.assertTrue((array.length != 0 ? 1 : 0) != 0);
        SimpleFeatureType schema = feature.getFeatureType();
        for (i = 0; i < array.length; ++i) {
            if (!array[i].getID().equals(feature.getID())) continue;
            return;
        }
        for (i = 0; i < array.length; ++i) {
        }
        JDBCDataStoreAPIOnlineTest.fail((String)("array has no match for " + feature));
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (av.equals(ev)) continue;
            return false;
        }
        return true;
    }

    public void testGeneralization() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("lake"));
        if (!fs.getSupportedHints().contains(Hints.GEOMETRY_GENERALIZATION)) {
            return;
        }
        SimpleFeatureCollection fColl = fs.getFeatures();
        Geometry original = null;
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                original = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        double width = original.getEnvelope().getEnvelopeInternal().getWidth();
        Query query = new Query();
        Hints hints = new Hints((RenderingHints.Key)Hints.GEOMETRY_GENERALIZATION, (Object)(width / 2.0));
        query.setHints(hints);
        Geometry generalized = null;
        fColl = fs.getFeatures(query);
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                generalized = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        JDBCDataStoreAPIOnlineTest.assertTrue((original.getNumPoints() >= generalized.getNumPoints() ? 1 : 0) != 0);
    }

    public void testSimplification() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("road"));
        if (!fs.getSupportedHints().contains(Hints.GEOMETRY_SIMPLIFICATION)) {
            return;
        }
        SimpleFeatureCollection fColl = fs.getFeatures();
        Geometry original = null;
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                original = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        double width = original.getEnvelope().getEnvelopeInternal().getWidth();
        Query query = new Query();
        Hints hints = new Hints((RenderingHints.Key)Hints.GEOMETRY_SIMPLIFICATION, (Object)(width / 2.0));
        query.setHints(hints);
        Geometry simplified = null;
        fColl = fs.getFeatures(query);
        try (SimpleFeatureIterator iterator = fColl.features();){
            if (iterator.hasNext()) {
                simplified = (Geometry)((SimpleFeature)iterator.next()).getDefaultGeometry();
            }
        }
        JDBCDataStoreAPIOnlineTest.assertTrue((original.getNumPoints() >= simplified.getNumPoints() ? 1 : 0) != 0);
    }

    @Override
    protected HashMap createDataStoreFactoryParams() throws Exception {
        HashMap params = super.createDataStoreFactoryParams();
        params.put(JDBCDataStoreFactory.BATCH_INSERT_SIZE.key, 1);
        return params;
    }
}

