/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.ConnectionLifecycleListener;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class JDBCConnectionLifecycleOnlineTest
extends JDBCTestSupport {
    protected MockListener mockListener = new MockListener();
    JDBCFeatureStore featureStore;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.featureStore = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    public void testListenerCalled() throws IOException {
        this.dataStore.getConnectionLifecycleListeners().add(this.mockListener);
        try (SimpleFeatureIterator fi = this.featureStore.getFeatures().features();){
            while (fi.hasNext()) {
                fi.next();
            }
        }
        JDBCConnectionLifecycleOnlineTest.assertTrue((boolean)this.mockListener.onBorrowCalled);
        JDBCConnectionLifecycleOnlineTest.assertTrue((boolean)this.mockListener.onReleaseCalled);
        JDBCConnectionLifecycleOnlineTest.assertFalse((boolean)this.mockListener.onCommitCalled);
        JDBCConnectionLifecycleOnlineTest.assertFalse((boolean)this.mockListener.onRollbackCalled);
        try (DefaultTransaction t = new DefaultTransaction();){
            SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
            DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
            this.featureStore.setTransaction((Transaction)t);
            for (int i = 3; i < 6; ++i) {
                b.set(this.aname("intProperty"), (Object)i);
                b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
                collection.add(b.buildFeature(null));
            }
            this.featureStore.addFeatures((FeatureCollection)collection);
            t.commit();
            JDBCConnectionLifecycleOnlineTest.assertTrue((boolean)this.mockListener.onBorrowCalled);
            JDBCConnectionLifecycleOnlineTest.assertTrue((boolean)this.mockListener.onReleaseCalled);
            JDBCConnectionLifecycleOnlineTest.assertTrue((boolean)this.mockListener.onCommitCalled);
            JDBCConnectionLifecycleOnlineTest.assertFalse((boolean)this.mockListener.onRollbackCalled);
            t.rollback();
            JDBCConnectionLifecycleOnlineTest.assertTrue((boolean)this.mockListener.onRollbackCalled);
        }
    }

    public void testConnectionReleased() throws IOException {
        this.dataStore.getConnectionLifecycleListeners().add(new ExceptionListener());
        for (int i = 0; i < 100; ++i) {
            this.featureStore.getCount(Query.ALL);
        }
    }

    private static class ExceptionListener
    implements ConnectionLifecycleListener {
        private ExceptionListener() {
        }

        public void onBorrow(JDBCDataStore store, Connection cx) throws SQLException {
        }

        public void onRelease(JDBCDataStore store, Connection cx) throws SQLException {
            throw new SQLException("Ha, are you relasing the connection anyways??");
        }

        public void onCommit(JDBCDataStore store, Connection cx) throws SQLException {
            throw new SQLException("Nope, no writes sir");
        }

        public void onRollback(JDBCDataStore store, Connection cx) throws SQLException {
        }
    }

    private static class MockListener
    implements ConnectionLifecycleListener {
        boolean onBorrowCalled = false;
        boolean onReleaseCalled = false;
        boolean onCommitCalled;
        boolean onRollbackCalled;

        private MockListener() {
        }

        public void onBorrow(JDBCDataStore store, Connection cx) throws SQLException {
            this.onBorrowCalled = true;
        }

        public void onRelease(JDBCDataStore store, Connection cx) throws SQLException {
            this.onReleaseCalled = true;
        }

        public void onCommit(JDBCDataStore store, Connection cx) throws SQLException {
            this.onCommitCalled = true;
        }

        public void onRollback(JDBCDataStore store, Connection cx) throws SQLException {
            this.onRollbackCalled = true;
        }
    }
}

