/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.GroupByVisitorBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.SumAreaVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.SortByImpl;
import org.geotools.filter.function.FilterFunction_area;
import org.geotools.jdbc.JDBCAggregateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.Converters;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public abstract class JDBCAggregateFunctionOnlineTest
extends JDBCTestSupport {
    boolean visited = false;

    @Override
    protected abstract JDBCAggregateTestSetup createTestSetup();

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.visited = false;
    }

    public void testSum() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)3.3, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testSumArea() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("geom"));
        MySumAreaVisitor v = new MySumAreaVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("aggregate")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertEquals((boolean)this.visited, (!this.dataStore.getFilterCapabilities().supports(FilterFunction_area.class) ? 1 : 0) != 0);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)30.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testSumAreaWithGroupBy() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("geom"));
        GroupByVisitor v = new GroupByVisitorBuilder().withAggregateAttribute((Expression)ff.function("area2", new Expression[]{p})).withAggregateVisitor("SumArea").withGroupByAttributes(Collections.singleton(this.aname("name")), this.dataStore.getSchema(this.tname("aggregate"))).build();
        this.dataStore.getFeatureSource(this.tname("aggregate")).accepts(Query.ALL, (FeatureVisitor)v, null);
        if (this.dataStore.getFilterCapabilities().supports(FilterFunction_area.class)) {
            JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        }
        List groups = v.getResult().toList();
        JDBCAggregateFunctionOnlineTest.assertEquals((double)20.0, (double)((Double)((Object[])groups.get(0))[1]), (double)0.01);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)10.0, (double)((Double)((Object[])groups.get(1))[1]), (double)0.01);
    }

    public void testSumWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        PropertyIsLessThan f = ff.less((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(2));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testSumWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMax() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)2.2, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMaxWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        PropertyIsLessThan f = ff.less((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(2));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMaxWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMin() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)0.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMinWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMinWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionOnlineTest.assertEquals((double)0.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testUnique() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionOnlineTest.assertEquals((int)3, (int)result.size());
        JDBCAggregateFunctionOnlineTest.assertTrue((boolean)result.contains("zero"));
        JDBCAggregateFunctionOnlineTest.assertTrue((boolean)result.contains("one"));
        JDBCAggregateFunctionOnlineTest.assertTrue((boolean)result.contains("two"));
    }

    public void testUniqueWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionOnlineTest.assertEquals((int)2, (int)result.size());
        JDBCAggregateFunctionOnlineTest.assertTrue((boolean)result.contains("one"));
        JDBCAggregateFunctionOnlineTest.assertTrue((boolean)result.contains("two"));
    }

    public void testUniqueWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported() || !this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct")) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionOnlineTest.assertEquals((int)2, (int)result.size());
    }

    public void testUniqueWithLimitOnVisitor() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported() || !this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct")) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        v.setPreserveOrder(true);
        v.setStartIndex(0);
        v.setMaxFeatures(2);
        Query q = new Query(this.tname("ft1"));
        q.setSortBy(new SortBy[]{new SortByImpl(p, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionOnlineTest.assertEquals((int)2, (int)result.size());
        JDBCAggregateFunctionOnlineTest.assertEquals((Object)"one", result.iterator().next());
    }

    public void testStoreChecksVisitorLimits() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported() || !this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct")) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p){

            public boolean hasLimits() {
                return true;
            }
        };
        v.setPreserveOrder(true);
        Query q = new Query(this.tname("ft1"));
        q.setMaxFeatures(1);
        q.setSortBy(new SortBy[]{new SortByImpl(p, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionOnlineTest.assertEquals((int)3, (int)result.size());
        JDBCAggregateFunctionOnlineTest.assertEquals((Object)"one", result.iterator().next());
    }

    public void testUniqueWithLimitOffsetOnVisitor() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported() || !this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct")) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        v.setPreserveOrder(true);
        v.setStartIndex(1);
        v.setMaxFeatures(2);
        Query q = new Query(this.tname("ft1"));
        q.setSortBy(new SortBy[]{new SortByImpl(p, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionOnlineTest.assertEquals((int)2, (int)result.size());
        JDBCAggregateFunctionOnlineTest.assertEquals((Object)"two", result.iterator().next());
    }

    public void testNearest() throws IOException {
        this.testNearest("ft1", "stringProperty", "two", "two");
        this.testNearest("ft1", "stringProperty", "aaa", "one");
        this.testNearest("ft1", "stringProperty", "rrr", "one", "two");
        this.testNearest("ft1", "stringProperty", "zzz", "zero");
        this.testNearest("ft1", "intProperty", 1, 1);
        this.testNearest("ft1", "intProperty", -10, 0);
        this.testNearest("ft1", "intProperty", 10, 2);
        this.testNearest("ft1", "doubleProperty", 1.1, 1.1);
        this.testNearest("ft1", "doubleProperty", -10.0, 0.0);
        this.testNearest("ft1", "doubleProperty", 1.3, 1.1);
        this.testNearest("ft1", "doubleProperty", 1.9, 2.2);
        this.testNearest("ft1", "doubleProperty", 10.0, 2.2);
    }

    private void testNearest(String typeName, String attributeName, Object target, Object ... validResults) throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyName expr = ff.property(this.aname(attributeName));
        MyNearestVisitor v = new MyNearestVisitor((Expression)expr, target);
        this.dataStore.getFeatureSource(this.tname(typeName)).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionOnlineTest.assertFalse((boolean)this.visited);
        Object nearestMatch = v.getNearestMatch();
        if (validResults.length == 0) {
            JDBCAggregateFunctionOnlineTest.assertNull((Object)nearestMatch);
        } else {
            boolean found = false;
            for (Object object : validResults) {
                if (!object.equals(Converters.convert((Object)nearestMatch, object.getClass()))) continue;
                found = true;
                break;
            }
            JDBCAggregateFunctionOnlineTest.assertTrue((String)("Could not match nearest " + nearestMatch + " among valid values " + Arrays.asList(validResults)), (boolean)found);
        }
    }

    class MyNearestVisitor
    extends NearestVisitor {
        public MyNearestVisitor(Expression expr, Object valueToMatch) {
            super(expr, valueToMatch);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit((Feature)feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyUniqueVisitor
    extends UniqueVisitor {
        public MyUniqueVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyMinVisitor
    extends MinVisitor {
        public MyMinVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyMaxVisitor
    extends MaxVisitor {
        public MyMaxVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MySumAreaVisitor
    extends SumAreaVisitor {
        public MySumAreaVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MySumVisitor
    extends SumVisitor {
        public MySumVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }
}

