/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.ds;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcStatement;

public class UnWrapperTest
extends TestCase {
    public void testDBCPUnwrapper() throws SQLException, IOException {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.h2.Driver");
        ds.setUrl("jdbc:h2:mem:test_mem");
        ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = ds.getConnection();
        UnWrapper uw = DataSourceFinder.getUnWrapper((Connection)conn);
        UnWrapperTest.assertNotNull((Object)uw);
        UnWrapperTest.assertTrue((boolean)uw.canUnwrap(conn));
        Connection unwrapped = uw.unwrap(conn);
        UnWrapperTest.assertNotNull((Object)unwrapped);
        UnWrapperTest.assertTrue((boolean)(unwrapped instanceof JdbcConnection));
        Statement st = conn.createStatement();
        uw = DataSourceFinder.getUnWrapper((Statement)st);
        UnWrapperTest.assertNotNull((Object)uw);
        UnWrapperTest.assertTrue((boolean)uw.canUnwrap(st));
        Statement uwst = uw.unwrap(st);
        UnWrapperTest.assertNotNull((Object)uwst);
        UnWrapperTest.assertTrue((boolean)(uwst instanceof JdbcStatement));
        st.close();
        PreparedStatement ps = conn.prepareStatement("select curtime()");
        uw = DataSourceFinder.getUnWrapper((Statement)ps);
        UnWrapperTest.assertNotNull((Object)uw);
        UnWrapperTest.assertTrue((boolean)uw.canUnwrap((Statement)ps));
        PreparedStatement uwps = (PreparedStatement)uw.unwrap((Statement)ps);
        UnWrapperTest.assertNotNull((Object)uwps);
        UnWrapperTest.assertTrue((boolean)(uwps instanceof JdbcPreparedStatement));
        ps.close();
        conn.close();
        ds.close();
    }
}

