/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.temporal.Position;

public class FilterToSQLTest
extends TestCase {
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static Logger LOGGER = Logging.getLogger(FilterToSQLTest.class);
    private SimpleFeatureType integerFType;
    private SimpleFeatureType stringFType;
    private SimpleFeatureType sqlDateFType;
    private SimpleFeatureType timestampFType;
    private SimpleFeatureType dateFType;
    private FilterToSQL encoder;
    private StringWriter output;

    public void setUp() throws Exception {
        Level debugLevel = Level.FINE;
        Locale.setDefault(new Locale("en", "US"));
        for (Logger log = LOGGER; log != null; log = log.getParent()) {
            log.setLevel(debugLevel);
            for (int i = 0; i < log.getHandlers().length; ++i) {
                Handler h = log.getHandlers()[i];
                h.setLevel(debugLevel);
            }
        }
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", Integer.class);
        this.integerFType = ftb.buildFeatureType();
        ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", Date.class);
        this.sqlDateFType = ftb.buildFeatureType();
        ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", Timestamp.class);
        this.timestampFType = ftb.buildFeatureType();
        ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", java.util.Date.class);
        this.dateFType = ftb.buildFeatureType();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", String.class);
        this.stringFType = ftb.buildFeatureType();
        this.output = new StringWriter();
        this.encoder = new FilterToSQL((Writer)this.output);
        this.encoder.setPrimaryKey(new PrimaryKey("foobar", Collections.singletonList(new NonIncrementingPrimaryKeyColumn("id", String.class))));
    }

    public void testIntegerContext() throws Exception {
        Literal literal = this.ff.literal(5);
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.integerFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.integerFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is an Integer " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = 5");
    }

    public void testSqlDateContext() throws Exception {
        Literal literal = this.ff.literal((Object)"2002-12-03");
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.sqlDateFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.sqlDateFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is a java.sql.Date " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = '2002-12-03'");
    }

    public void testTimestampContext() throws Exception {
        Literal literal = this.ff.literal((Object)"2002-12-03 10:00");
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.timestampFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.timestampFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is a Timestampa " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = '2002-12-03 10:00'");
    }

    public void testDateContext() throws Exception {
        Literal literal = this.ff.literal((Object)"2002-12-03 10:00");
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.dateFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.dateFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is a java.util.Date " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = '2002-12-03 10:00'");
    }

    public void testStringContext() throws Exception {
        Literal literal = this.ff.literal(5);
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.stringFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.stringFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is a String " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = '5'");
    }

    public void testIntegerToNumberContext() throws Exception {
        Literal literal = this.ff.literal(5.0);
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.integerFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.integerFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is an Integer " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = 5.0");
    }

    public void testInclude() throws Exception {
        this.encoder.encode((Filter)Filter.INCLUDE);
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE 1 = 1");
    }

    public void testExclude() throws Exception {
        this.encoder.encode((Filter)Filter.EXCLUDE);
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE 0 = 1");
    }

    public void testIdFilterMulti() throws Exception {
        LinkedHashSet<FeatureId> fids = new LinkedHashSet<FeatureId>();
        fids.add(this.ff.featureId("fid1"));
        fids.add(this.ff.featureId("fid2"));
        Id id = this.ff.id(fids);
        this.encoder.encode((Filter)id);
        FilterToSQLTest.assertEquals((String)"WHERE ((id = 'fid1') OR (id = 'fid2'))", (String)this.output.toString());
    }

    public void testIdFilterSingle() throws Exception {
        LinkedHashSet<FeatureId> fids = new LinkedHashSet<FeatureId>();
        fids.add(this.ff.featureId("fid1"));
        Id id = this.ff.id(fids);
        this.encoder.encode((Filter)id);
        FilterToSQLTest.assertEquals((String)"WHERE (id = 'fid1')", (String)this.output.toString());
    }

    public void testEscapeQuote() throws FilterToSQLException {
        PropertyIsEqualTo equals = this.ff.equals((Expression)this.ff.property("attribute"), (Expression)this.ff.literal((Object)"A'A"));
        this.encoder.encode((Filter)equals);
        FilterToSQLTest.assertEquals((String)"WHERE attribute = 'A''A'", (String)this.output.toString());
    }

    public void testExpression() throws Exception {
        Add a = this.ff.add((Expression)this.ff.property("testAttr"), (Expression)this.ff.literal(5));
        this.encoder.encode((Expression)a);
        FilterToSQLTest.assertEquals((String)"testAttr + 5", (String)this.output.toString());
    }

    public void testEscapeQuoteFancy() throws FilterToSQLException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Object fancyLiteral = new Object(){

            public String toString() {
                return "A'A";
            }
        };
        PropertyIsEqualTo equals = ff.equals((Expression)ff.property("attribute"), (Expression)ff.literal(fancyLiteral));
        StringWriter output = new StringWriter();
        FilterToSQL encoder = new FilterToSQL((Writer)output);
        encoder.encode((Filter)equals);
        FilterToSQLTest.assertEquals((String)"WHERE attribute = 'A''A'", (String)output.toString());
    }

    public void testNumberEscapes() throws Exception {
        Add a = this.ff.add((Expression)this.ff.property("testAttr"), (Expression)this.ff.literal(5));
        PropertyIsEqualTo equal = this.ff.equal((Expression)this.ff.property("testAttr"), (Expression)a, false);
        StringWriter output = new StringWriter();
        FilterToSQL encoder = new FilterToSQL((Writer)output);
        encoder.encode((Filter)equal);
        FilterToSQLTest.assertEquals((String)"WHERE testAttr = testAttr + 5", (String)output.toString());
    }

    public void testInline() throws Exception {
        PropertyIsEqualTo equal = this.ff.equal((Expression)this.ff.property("testAttr"), (Expression)this.ff.literal(5), false);
        StringWriter output = new StringWriter();
        FilterToSQL encoder = new FilterToSQL((Writer)output);
        encoder.setInline(true);
        encoder.encode((Filter)equal);
        FilterToSQLTest.assertEquals((String)"testAttr = 5", (String)output.toString());
    }

    public void testAfterInstant() throws Exception {
        java.util.Date date = (java.util.Date)Converters.convert((Object)"2002-12-03 10:00:00AM", java.util.Date.class);
        DefaultInstant instant = new DefaultInstant((Position)new DefaultPosition(date));
        Literal literal = this.ff.literal((Object)instant);
        PropertyName prop = this.ff.property(((AttributeDescriptor)this.timestampFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.ff.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.timestampFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is a Timestamp " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = '2002-12-03 10:00:00.0'");
    }

    public void testSimpleIn() throws FilterToSQLException {
        FilterToSQLTest.assertEquals((String)this.encodeInComparison("in", true, "true", 1, 2), (String)"WHERE testAttr IN (1, 2)");
        FilterToSQLTest.assertEquals((String)this.encodeInComparison("in", false, "false", 1, 2), (String)"WHERE testAttr IN (1, 2)");
    }

    public void testMixedLogic() throws FilterToSQLException {
        FilterToSQLTest.assertEquals((String)this.encodeInComparison("in", true, "true", 1, 2), (String)"WHERE testAttr IN (1, 2)");
        FilterToSQLTest.assertEquals((String)this.encodeInComparison("in", false, "false", 1, 2), (String)"WHERE testAttr IN (1, 2)");
    }

    public void testIn2To10() throws FilterToSQLException {
        for (int i = 2; i <= 10; ++i) {
            Object[] values = new Object[i];
            for (int j = 0; j < values.length; ++j) {
                values[j] = j;
            }
            String commaSeparatedValues = Arrays.stream(values).map(v -> String.valueOf(v)).collect(Collectors.joining(", "));
            FilterToSQLTest.assertEquals((String)this.encodeInComparison("in" + i, true, "true", values), (String)("WHERE testAttr IN (" + commaSeparatedValues + ")"));
        }
    }

    public void testInWithLessThan() throws FilterToSQLException {
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        Function function = this.buildInFunction("in", new Object[]{1, 2});
        PropertyIsLessThan filter = this.ff.less((Expression)function, (Expression)this.ff.literal(true));
        encoder.encode((Filter)filter);
        FilterToSQLTest.assertEquals((String)"WHERE (testAttr IN (1, 2)) < true", (String)this.output.getBuffer().toString());
    }

    public String encodeInComparison(String functionName, boolean equality, String literal, Object ... valueList) throws FilterToSQLException {
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        Function function = this.buildInFunction(functionName, valueList);
        Object filter = equality ? this.ff.equal((Expression)function, (Expression)this.ff.literal((Object)literal), true) : this.ff.notEqual((Expression)function, (Expression)this.ff.literal((Object)literal), true);
        encoder.encode((Filter)filter);
        String result = this.output.getBuffer().toString();
        this.output.getBuffer().setLength(0);
        return result;
    }

    public Function buildInFunction(String functionName, Object[] valueList) {
        Stream<Literal> values = Arrays.stream(valueList).map(v -> this.ff.literal(v));
        Stream<PropertyName> property = Stream.of(this.ff.property("testAttr"));
        Expression[] literals = (Expression[])Stream.concat(property, values).toArray(Expression[]::new);
        return this.ff.function(functionName, literals);
    }

    public void testNestedMath1() throws Exception {
        PropertyIsEqualTo filter = this.ff.equals((Expression)this.ff.multiply((Expression)this.ff.subtract((Expression)this.ff.property("PROP1"), (Expression)this.ff.literal(10)), (Expression)this.ff.literal(20)), (Expression)this.ff.literal(50));
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        FilterToSQLTest.assertEquals((String)"WHERE (PROP1 - 10) * 20 = 50", (String)encoder.encodeToString((Filter)filter));
    }

    public void testNestedMath2() throws Exception {
        PropertyIsEqualTo filter = this.ff.equals((Expression)this.ff.subtract((Expression)this.ff.property("PROP1"), (Expression)this.ff.multiply((Expression)this.ff.literal(10), (Expression)this.ff.literal(20))), (Expression)this.ff.literal(50));
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        FilterToSQLTest.assertEquals((String)"WHERE PROP1 - (10 * 20) = 50", (String)encoder.encodeToString((Filter)filter));
    }

    public void testSimpleInFromEqualities() throws Exception {
        PropertyName p = this.ff.property("PROP1");
        Or filter = this.ff.or(Arrays.asList(this.ff.equals((Expression)p, (Expression)this.ff.literal(1)), this.ff.equals((Expression)p, (Expression)this.ff.literal(2))));
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        FilterToSQLTest.assertEquals((String)"WHERE PROP1 IN (1, 2)", (String)encoder.encodeToString((Filter)filter));
    }

    public void testMixedInFromEqualities() throws Exception {
        PropertyName p1 = this.ff.property("P1");
        PropertyName p2 = this.ff.property("P2");
        Or filter = this.ff.or(Arrays.asList(this.ff.equals((Expression)p1, (Expression)this.ff.literal(1)), this.ff.equals((Expression)p2, (Expression)this.ff.literal((Object)"a")), this.ff.equals((Expression)p1, (Expression)this.ff.literal(2)), this.ff.equals((Expression)p2, (Expression)this.ff.literal((Object)"b"))));
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        FilterToSQLTest.assertEquals((String)"WHERE (P1 IN (1, 2) OR P2 IN ('a', 'b'))", (String)encoder.encodeToString((Filter)filter));
    }

    public void testMixedInWithSingleEquality() throws Exception {
        PropertyName p1 = this.ff.property("P1");
        PropertyName p2 = this.ff.property("P2");
        Or filter = this.ff.or(Arrays.asList(this.ff.equals((Expression)p1, (Expression)this.ff.literal(1)), this.ff.equals((Expression)p2, (Expression)this.ff.literal((Object)"a")), this.ff.equals((Expression)p1, (Expression)this.ff.literal(2))));
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        FilterToSQLTest.assertEquals((String)"WHERE (P1 IN (1, 2) OR P2 = 'a')", (String)encoder.encodeToString((Filter)filter));
    }

    public void testInFromEqualitiesInequalities() throws Exception {
        PropertyName p1 = this.ff.property("P1");
        PropertyName p2 = this.ff.property("P2");
        Or filter = this.ff.or(Arrays.asList(this.ff.equals((Expression)p1, (Expression)this.ff.literal(1)), this.ff.greater((Expression)p2, (Expression)this.ff.literal(3)), this.ff.equals((Expression)p1, (Expression)this.ff.literal(2)), this.ff.less((Expression)p2, (Expression)this.ff.literal(4))));
        FilterToSQL encoder = new FilterToSQL((Writer)this.output);
        FilterToSQLTest.assertEquals((String)"WHERE (P1 IN (1, 2) OR P2 > 3 OR P2 < 4)", (String)encoder.encodeToString((Filter)filter));
    }

    public void testEscapeName() {
        this.encoder.setSqlNameEscape("\"");
        FilterToSQLTest.assertEquals((String)"\"abc\"", (String)this.encoder.escapeName("abc"));
        FilterToSQLTest.assertEquals((String)"\"\"\"abc\"", (String)this.encoder.escapeName("\"abc"));
        FilterToSQLTest.assertEquals((String)"\"a\"\"bc\"", (String)this.encoder.escapeName("a\"bc"));
        FilterToSQLTest.assertEquals((String)"\"abc\"\"\"", (String)this.encoder.escapeName("abc\""));
        this.encoder.setSqlNameEscape("");
        FilterToSQLTest.assertEquals((String)"abc", (String)this.encoder.escapeName("abc"));
    }
}

