/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.GmlObjectStore;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.jdbc.datasource.ManageableDataSource;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.filter.FilterCapabilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.CompositePrimaryKeyFinder;
import org.geotools.jdbc.ConnectionLifecycleListener;
import org.geotools.jdbc.HeuristicPrimaryKeyFinder;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCState;
import org.geotools.jdbc.JDBCTransactionState;
import org.geotools.jdbc.JoinInfo;
import org.geotools.jdbc.LifecycleConnection;
import org.geotools.jdbc.MetadataTablePrimaryKeyFinder;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.NullPrimaryKey;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.TransformException;

public final class JDBCDataStore
extends ContentDataStore
implements GmlObjectStore {
    public static final String JDBC_NATIVE_SRID = "nativeSRID";
    public static final String JDBC_READ_ONLY = "org.geotools.jdbc.readOnly";
    public static final String JDBC_NATIVE_TYPENAME = "org.geotools.jdbc.nativeTypeName";
    public static final String JDBC_COLUMN_ALIAS = "org.geotools.jdbc.columnAlias";
    protected static final String GEOMETRY_TABLE = "geometry";
    protected static final String MULTI_GEOMETRY_TABLE = "multi_geometry";
    protected static final String GEOMETRY_ASSOCIATION_TABLE = "geometry_associations";
    protected static final String FEATURE_RELATIONSHIP_TABLE = "feature_relationships";
    protected static final String FEATURE_ASSOCIATION_TABLE = "feature_associations";
    protected static final ReferencedEnvelope EMPTY_ENVELOPE = new ReferencedEnvelope();
    protected DataSource dataSource;
    protected SQLDialect dialect;
    protected String databaseSchema;
    protected HashMap<Integer, Class<?>> sqlTypeToClassMappings;
    protected HashMap<String, Class<?>> sqlTypeNameToClassMappings;
    protected HashMap<Class<?>, Integer> classToSqlTypeMappings;
    protected HashMap<Integer, String> sqlTypeToSqlTypeNameOverrides;
    protected HashMap<Class<? extends FeatureVisitor>, String> aggregateFunctions;
    protected boolean associations = false;
    protected int fetchSize;
    protected boolean exposePrimaryKeyColumns = false;
    protected PrimaryKeyFinder primaryKeyFinder = new CompositePrimaryKeyFinder(new MetadataTablePrimaryKeyFinder(), new HeuristicPrimaryKeyFinder());
    protected Map<String, VirtualTable> virtualTables = new ConcurrentHashMap<String, VirtualTable>();
    protected List<ConnectionLifecycleListener> connectionLifecycleListeners = new CopyOnWriteArrayList<ConnectionLifecycleListener>();

    public JDBCFeatureSource getAbsoluteFeatureSource(String typeName) throws IOException {
        ContentFeatureSource featureSource = this.getFeatureSource(typeName);
        if (featureSource instanceof JDBCFeatureSource) {
            return (JDBCFeatureSource)featureSource;
        }
        return ((JDBCFeatureStore)featureSource).getFeatureSource();
    }

    public void addVirtualTable(VirtualTable vtable) throws IOException {
        try {
            this.virtualTables.put(vtable.getName(), new VirtualTable(vtable));
            this.entries.remove(new NameImpl(this.namespaceURI, vtable.getName()));
            this.getSchema(vtable.getName());
        }
        catch (IOException e) {
            this.virtualTables.remove(vtable.getName());
            throw e;
        }
    }

    public List<ConnectionLifecycleListener> getConnectionLifecycleListeners() {
        return this.connectionLifecycleListeners;
    }

    public VirtualTable removeVirtualTable(String name) {
        VirtualTable vt = this.virtualTables.remove(name);
        if (vt != null) {
            this.entries.remove(new NameImpl(this.namespaceURI, name));
        }
        return vt;
    }

    public Map<String, VirtualTable> getVirtualTables() {
        HashMap<String, VirtualTable> result = new HashMap<String, VirtualTable>();
        for (String key : this.virtualTables.keySet()) {
            result.put(key, new VirtualTable(this.virtualTables.get(key)));
        }
        return Collections.unmodifiableMap(result);
    }

    public PrimaryKeyFinder getPrimaryKeyFinder() {
        return this.primaryKeyFinder;
    }

    public void setPrimaryKeyFinder(PrimaryKeyFinder primaryKeyFinder) {
        this.primaryKeyFinder = primaryKeyFinder;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isExposePrimaryKeyColumns() {
        return this.exposePrimaryKeyColumns;
    }

    public void setExposePrimaryKeyColumns(boolean exposePrimaryKeyColumns) {
        this.exposePrimaryKeyColumns = exposePrimaryKeyColumns;
    }

    public SQLDialect getSQLDialect() {
        return this.dialect;
    }

    public void setSQLDialect(SQLDialect dialect) {
        if (dialect == null) {
            throw new NullPointerException();
        }
        this.dialect = dialect;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public FilterCapabilities getFilterCapabilities() {
        if (this.dialect instanceof PreparedStatementSQLDialect) {
            return ((PreparedStatementSQLDialect)this.dialect).createPreparedFilterToSQL().getCapabilities();
        }
        return ((BasicSQLDialect)this.dialect).createFilterToSQL().getCapabilities();
    }

    public boolean isAssociations() {
        return this.associations;
    }

    public void setAssociations(boolean foreignKeyGeometries) {
        this.associations = foreignKeyGeometries;
    }

    public Map<Integer, Class<?>> getSqlTypeToClassMappings() {
        if (this.sqlTypeToClassMappings == null) {
            this.sqlTypeToClassMappings = new HashMap();
            this.dialect.registerSqlTypeToClassMappings(this.sqlTypeToClassMappings);
        }
        return this.sqlTypeToClassMappings;
    }

    public Map<String, Class<?>> getSqlTypeNameToClassMappings() {
        if (this.sqlTypeNameToClassMappings == null) {
            this.sqlTypeNameToClassMappings = new HashMap();
            this.dialect.registerSqlTypeNameToClassMappings(this.sqlTypeNameToClassMappings);
        }
        return this.sqlTypeNameToClassMappings;
    }

    public Map<Class<?>, Integer> getClassToSqlTypeMappings() {
        if (this.classToSqlTypeMappings == null) {
            this.classToSqlTypeMappings = new HashMap();
            this.dialect.registerClassToSqlMappings(this.classToSqlTypeMappings);
        }
        return this.classToSqlTypeMappings;
    }

    public Map<Integer, String> getSqlTypeToSqlTypeNameOverrides() {
        if (this.sqlTypeToSqlTypeNameOverrides == null) {
            this.sqlTypeToSqlTypeNameOverrides = new HashMap();
            this.dialect.registerSqlTypeToSqlTypeNameOverrides(this.sqlTypeToSqlTypeNameOverrides);
        }
        return this.sqlTypeToSqlTypeNameOverrides;
    }

    public Map<Class<? extends FeatureVisitor>, String> getAggregateFunctions() {
        if (this.aggregateFunctions == null) {
            this.aggregateFunctions = new HashMap();
            this.dialect.registerAggregateFunctions(this.aggregateFunctions);
        }
        return this.aggregateFunctions;
    }

    public Class<?> getMapping(int sqlType) {
        return this.getSqlTypeToClassMappings().get(new Integer(sqlType));
    }

    public Class<?> getMapping(String sqlTypeName) {
        return this.getSqlTypeNameToClassMappings().get(sqlTypeName);
    }

    public Integer getMapping(Class<?> clazz) {
        Integer mapping = this.getClassToSqlTypeMappings().get(clazz);
        if (mapping == null) {
            ArrayList matches = new ArrayList();
            for (Map.Entry<Class<?>, Integer> e : this.getClassToSqlTypeMappings().entrySet()) {
                if (!e.getKey().isAssignableFrom(clazz)) continue;
                matches.add(e);
            }
            if (!matches.isEmpty()) {
                if (matches.size() == 1) {
                    mapping = (Integer)((Map.Entry)matches.get(0)).getValue();
                } else {
                    Collections.sort(matches, new Comparator<Map.Entry<Class<?>, Integer>>(){

                        @Override
                        public int compare(Map.Entry<Class<?>, Integer> o1, Map.Entry<Class<?>, Integer> o2) {
                            if (o1.getKey().isAssignableFrom(o2.getKey())) {
                                return 1;
                            }
                            if (o2.getKey().isAssignableFrom(o1.getKey())) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    if (((Class)((Map.Entry)matches.get(1)).getKey()).isAssignableFrom((Class)((Map.Entry)matches.get(0)).getKey())) {
                        mapping = (Integer)((Map.Entry)matches.get(0)).getValue();
                    }
                }
            }
        }
        if (mapping == null) {
            mapping = 1111;
            this.LOGGER.warning("No mapping for " + clazz.getName());
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        if (this.entry(featureType.getName()) != null) {
            String msg = "Schema '" + featureType.getName() + "' already exists";
            throw new IllegalArgumentException(msg);
        }
        Connection cx = this.createConnection();
        try {
            String sql = this.createTableSQL(featureType, cx);
            this.LOGGER.log(Level.FINE, "Create schema: {0}", sql);
            Statement st = cx.createStatement();
            try {
                st.execute(sql);
            }
            finally {
                this.closeSafe(st);
            }
            this.dialect.postCreateTable(this.databaseSchema, featureType, cx);
        }
        catch (Exception e) {
            String msg = "Error occurred creating table";
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            this.closeSafe(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object getGmlObject(GmlObjectId id, Hints hints) throws IOException {
        int i;
        if (this.isAssociations()) {
            Connection cx = this.createConnection();
            try {
                ResultSet rs;
                Statement st;
                block18: {
                    st = null;
                    rs = null;
                    if (this.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                        st = this.selectGeometrySQLPS(id.getID(), cx);
                        rs = st.executeQuery();
                    } else {
                        String sql = this.selectGeometrySQL(id.getID());
                        this.LOGGER.log(Level.FINE, "Get GML object: {0}", sql);
                        st = cx.createStatement();
                        rs = st.executeQuery(sql);
                    }
                    if (!rs.next()) break block18;
                    Geometry g = this.getSQLDialect().decodeGeometryValue(null, rs, GEOMETRY_TABLE, this.getGeometryFactory(), cx);
                    String name = rs.getString("name");
                    String desc = rs.getString("description");
                    this.setGmlProperties(g, id.getID(), name, desc);
                    Geometry geometry = g;
                    this.closeSafe(rs);
                    this.closeSafe(st);
                    return geometry;
                    {
                        catch (Throwable throwable) {
                            this.closeSafe(rs);
                            this.closeSafe(st);
                            throw throwable;
                        }
                    }
                }
                try {
                    this.closeSafe(rs);
                    this.closeSafe(st);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
            finally {
                this.closeSafe(cx);
            }
        }
        if ((i = id.getID().indexOf(46)) == -1) {
            this.LOGGER.info("Unable to determine feature type for GmlObjectId:" + id);
            return null;
        }
        String featureTypeName = id.getID().substring(0, i);
        SimpleFeatureType featureType = this.getSchema(featureTypeName);
        if (featureType == null) {
            throw new IllegalArgumentException("No such feature type: " + featureTypeName);
        }
        Id filter = this.getFilterFactory().id(Collections.singleton(id));
        DefaultQuery query = new DefaultQuery(featureTypeName);
        query.setFilter((Filter)filter);
        query.setHints(hints);
        ContentFeatureCollection features = this.getFeatureSource(featureTypeName).getFeatures((Query)query);
        if (!features.isEmpty()) {
            SimpleFeatureIterator fi = features.features();
            try {
                if (fi.hasNext()) {
                    Feature feature = fi.next();
                    return feature;
                }
            }
            finally {
                features.close((FeatureIterator)fi);
            }
        }
        return null;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        Object readOnlyMarker;
        SimpleFeatureType schema = entry.getState(Transaction.AUTO_COMMIT).getFeatureType();
        if (schema == null) {
            schema = new JDBCFeatureSource(entry, null).buildFeatureType();
            entry.getState(Transaction.AUTO_COMMIT).setFeatureType(schema);
        }
        if (Boolean.TRUE.equals(readOnlyMarker = schema.getUserData().get(JDBC_READ_ONLY))) {
            return new JDBCFeatureSource(entry, null);
        }
        return new JDBCFeatureStore(entry, null);
    }

    protected ContentState createContentState(ContentEntry entry) {
        JDBCState state = new JDBCState(entry);
        state.setExposePrimaryKeyColumns(this.exposePrimaryKeyColumns);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createTypeNames() throws IOException {
        Connection cx = this.createConnection();
        ArrayList<NameImpl> typeNames = new ArrayList<NameImpl>();
        try {
            DatabaseMetaData metaData = cx.getMetaData();
            ResultSet tables = metaData.getTables(null, this.databaseSchema, "%", new String[]{"TABLE", "VIEW"});
            if (this.fetchSize > 1) {
                tables.setFetchSize(this.fetchSize);
            }
            try {
                while (tables.next()) {
                    String tableName;
                    String schemaName = tables.getString("TABLE_SCHEM");
                    if (!this.dialect.includeTable(schemaName, tableName = tables.getString("TABLE_NAME"), cx)) continue;
                    typeNames.add(new NameImpl(this.namespaceURI, tableName));
                }
            }
            finally {
                this.closeSafe(tables);
            }
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Error occurred getting table name list.").initCause(e);
        }
        finally {
            this.closeSafe(cx);
        }
        for (String virtualTable : this.virtualTables.keySet()) {
            typeNames.add(new NameImpl(this.namespaceURI, virtualTable));
        }
        return typeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrimaryKey getPrimaryKey(ContentEntry entry) throws IOException {
        JDBCState state = (JDBCState)entry.getState(Transaction.AUTO_COMMIT);
        if (state.getPrimaryKey() == null) {
            JDBCDataStore jDBCDataStore = this;
            synchronized (jDBCDataStore) {
                if (state.getPrimaryKey() == null) {
                    Connection cx = this.createConnection();
                    try {
                        PrimaryKey pkey = null;
                        String tableName = entry.getName().getLocalPart();
                        if (this.virtualTables.containsKey(tableName)) {
                            VirtualTable vt = this.virtualTables.get(tableName);
                            if (vt.getPrimaryKeyColumns().size() == 0) {
                                pkey = new NullPrimaryKey(tableName);
                            } else {
                                List<ColumnMetadata> metas = JDBCFeatureSource.getColumnMetadata(cx, vt, this.dialect, this);
                                ArrayList<PrimaryKeyColumn> kcols = new ArrayList<PrimaryKeyColumn>();
                                for (String pkName : vt.getPrimaryKeyColumns()) {
                                    Class binding = null;
                                    for (ColumnMetadata meta : metas) {
                                        if (!meta.name.equals(pkName)) continue;
                                        binding = meta.binding;
                                    }
                                    kcols.add(new NonIncrementingPrimaryKeyColumn(pkName, binding));
                                }
                                pkey = new PrimaryKey(tableName, kcols);
                            }
                        } else {
                            try {
                                pkey = this.primaryKeyFinder.getPrimaryKey(this, this.databaseSchema, tableName, cx);
                            }
                            catch (SQLException e) {
                                this.LOGGER.warning("Failure occurred while looking up the primary key with finder: " + this.primaryKeyFinder);
                            }
                            if (pkey == null) {
                                String msg = "No primary key or unique index found for " + tableName + ".";
                                this.LOGGER.warning(msg);
                                pkey = new NullPrimaryKey(tableName);
                            }
                        }
                        state.setPrimaryKey(pkey);
                    }
                    catch (SQLException e) {
                        String msg = "Error looking up primary key";
                        throw (IOException)new IOException(msg).initCause(e);
                    }
                    finally {
                        this.closeSafe(cx);
                    }
                }
            }
        }
        return state.getPrimaryKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isView(DatabaseMetaData metaData, String databaseSchema, String tableName) throws SQLException {
        ResultSet tables = null;
        try {
            tables = metaData.getTables(null, databaseSchema, tableName, new String[]{"VIEW"});
            boolean bl = tables.next();
            this.closeSafe(tables);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeSafe(tables);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrimaryKey createPrimaryKey(ResultSet index, DatabaseMetaData metaData, String tableName, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> cols = new ArrayList<PrimaryKeyColumn>();
        while (index.next()) {
            String columnName = index.getString("COLUMN_NAME");
            if (columnName == null) continue;
            Class columnType = this.getColumnType(metaData, this.databaseSchema, tableName, columnName);
            PrimaryKeyColumn col = null;
            Statement st = cx.createStatement();
            try {
                st.setFetchSize(1);
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ");
                this.dialect.encodeColumnName(columnName, sql);
                sql.append(" FROM ");
                this.encodeTableName(tableName, sql, null);
                sql.append(" WHERE 0=1");
                this.LOGGER.log(Level.FINE, "Grabbing table pk metadata: {0}", sql);
                ResultSet rs = st.executeQuery(sql.toString());
                try {
                    if (rs.getMetaData().isAutoIncrement(1)) {
                        col = new AutoGeneratedPrimaryKeyColumn(columnName, columnType);
                    }
                }
                finally {
                    this.closeSafe(rs);
                }
            }
            finally {
                this.closeSafe(st);
            }
            if (col == null) {
                try {
                    String sequenceName = this.dialect.getSequenceForColumn(this.databaseSchema, tableName, columnName, cx);
                    if (sequenceName != null) {
                        col = new SequencedPrimaryKeyColumn(columnName, columnType, sequenceName);
                    }
                }
                catch (Exception e) {
                    this.LOGGER.log(Level.WARNING, "Error occured determining sequence for " + columnName + ", " + tableName, e);
                }
            }
            if (col == null) {
                col = new NonIncrementingPrimaryKeyColumn(columnName, columnType);
            }
            cols.add(col);
        }
        if (!cols.isEmpty()) {
            return new PrimaryKey(tableName, cols);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getColumnType(DatabaseMetaData metaData, String databaseSchema2, String tableName, String columnName) throws SQLException {
        ResultSet columns = null;
        try {
            columns = metaData.getColumns(null, this.databaseSchema, tableName, columnName);
            columns.next();
            int binding = columns.getInt("DATA_TYPE");
            Class<Object> columnType = this.getMapping(binding);
            if (columnType == null) {
                this.LOGGER.warning("No class for sql type " + binding);
                columnType = Object.class;
            }
            Class<?> clazz = columnType;
            return clazz;
        }
        finally {
            columns.close();
        }
    }

    protected PrimaryKey getPrimaryKey(SimpleFeatureType featureType) throws IOException {
        return this.getPrimaryKey(this.ensureEntry(featureType.getName()));
    }

    protected boolean isExposePrimaryKeyColumns(SimpleFeatureType featureType) throws IOException {
        ContentEntry entry = this.ensureEntry(featureType.getName());
        JDBCState state = (JDBCState)entry.getState(Transaction.AUTO_COMMIT);
        return state.isExposePrimaryKeyColumns();
    }

    protected ReferencedEnvelope getBounds(SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        ReferencedEnvelope bounds;
        ResultSet rs;
        Statement st;
        block11: {
            List<ReferencedEnvelope> result;
            if (featureType.getGeometryDescriptor() == null) {
                return EMPTY_ENVELOPE;
            }
            st = null;
            rs = null;
            bounds = new ReferencedEnvelope(featureType.getCoordinateReferenceSystem());
            if (!this.isFullBoundsQuery(query, featureType) || (result = this.dialect.getOptimizedBounds(this.databaseSchema, featureType, cx)) == null || result.isEmpty()) break block11;
            for (ReferencedEnvelope envelope : result) {
                bounds = this.mergeEnvelope(bounds, envelope);
            }
            ReferencedEnvelope i$ = bounds;
            this.closeSafe(rs);
            this.closeSafe(st);
            return i$;
        }
        try {
            if (this.dialect instanceof PreparedStatementSQLDialect) {
                st = this.selectBoundsSQLPS(featureType, query, cx);
                rs = st.executeQuery();
            } else {
                String sql = this.selectBoundsSQL(featureType, query);
                this.LOGGER.log(Level.FINE, "Retriving bounding box: {0}", sql);
                st = cx.createStatement();
                rs = st.executeQuery(sql);
            }
            SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= columns; ++i) {
                    Envelope envelope = this.dialect.decodeGeometryEnvelope(rs, i, st.getConnection());
                    if (envelope == null) continue;
                    bounds = envelope instanceof ReferencedEnvelope ? this.mergeEnvelope(bounds, (ReferencedEnvelope)envelope) : this.mergeEnvelope(bounds, new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)flatCRS));
                }
            }
            this.closeSafe(rs);
            this.closeSafe(st);
        }
        catch (Exception e) {
            try {
                String msg = "Error occured calculating bounds";
                throw (IOException)new IOException(msg).initCause(e);
            }
            catch (Throwable throwable) {
                this.closeSafe(rs);
                this.closeSafe(st);
                throw throwable;
            }
        }
        return bounds;
    }

    private boolean isFullBoundsQuery(Query query, SimpleFeatureType schema) {
        if (query == null) {
            return true;
        }
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return false;
        }
        if (query.getProperties() == Query.ALL_PROPERTIES) {
            return true;
        }
        List<String> names = Arrays.asList(query.getPropertyNames());
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor) || names.contains(ad.getLocalName())) continue;
            return false;
        }
        return true;
    }

    ReferencedEnvelope mergeEnvelope(ReferencedEnvelope base, ReferencedEnvelope merge) throws TransformException, FactoryException {
        if (base == null || base.isNull()) {
            return merge;
        }
        if (merge == null || merge.isNull()) {
            return base;
        }
        CoordinateReferenceSystem crsBase = base.getCoordinateReferenceSystem();
        CoordinateReferenceSystem crsMerge = merge.getCoordinateReferenceSystem();
        if (crsBase == null) {
            merge.expandToInclude((Envelope)base);
            return merge;
        }
        if (crsMerge == null) {
            base.expandToInclude((Envelope)base);
            return base;
        }
        if (!CRS.equalsIgnoreMetadata((Object)crsBase, (Object)crsMerge)) {
            merge = merge.transform(crsBase, true);
        }
        base.expandToInclude((Envelope)merge);
        return base;
    }

    protected int getCount(SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        CountVisitor v = new CountVisitor();
        this.getAggregateValue((FeatureVisitor)v, featureType, query, cx);
        return v.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAggregateValue(FeatureVisitor visitor, SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        String function = this.getAggregateFunctions().get(visitor.getClass());
        if (function == null) {
            for (Class<?> clazz = visitor.getClass(); clazz != null && function == null; clazz = clazz.getSuperclass()) {
                function = this.getAggregateFunctions().get(clazz);
            }
            if (function == null) {
                this.LOGGER.info("Unable to find aggregate function matching visitor: " + visitor.getClass());
                return null;
            }
        }
        AttributeDescriptor att = null;
        Expression expression = this.getExpression(visitor);
        if (expression != null) {
            att = (AttributeDescriptor)expression.evaluate((Object)featureType);
        }
        try {
            Object result = null;
            ArrayList<Object> results = new ArrayList<Object>();
            Statement st = null;
            ResultSet rs = null;
            try {
                if (this.dialect instanceof PreparedStatementSQLDialect) {
                    st = this.selectAggregateSQLPS(function, att, featureType, query, cx);
                    rs = st.executeQuery();
                } else {
                    String sql = this.selectAggregateSQL(function, att, featureType, query);
                    this.LOGGER.fine(sql);
                    st = cx.createStatement();
                    rs = st.executeQuery(sql);
                }
                while (rs.next()) {
                    Object value;
                    result = value = rs.getObject(1);
                    results.add(value);
                }
                this.closeSafe(rs);
                this.closeSafe(st);
            }
            catch (Throwable throwable) {
                this.closeSafe(rs);
                this.closeSafe(st);
                throw throwable;
            }
            if (this.setResult(visitor, results.size() > 1 ? results : result)) {
                return result;
            }
            return null;
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    Expression getExpression(FeatureVisitor visitor) {
        try {
            Object result;
            Method g = visitor.getClass().getMethod("getExpression", null);
            if (g != null && (result = g.invoke((Object)visitor, null)) instanceof Expression) {
                return (Expression)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    boolean setResult(FeatureVisitor visitor, Object result) {
        try {
            Method s = null;
            try {
                s = visitor.getClass().getMethod("setValue", result.getClass());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (s == null) {
                for (Method m : visitor.getClass().getMethods()) {
                    if (!"setValue".equals(m.getName())) continue;
                    s = m;
                    break;
                }
            }
            if (s != null) {
                Class<?> type = s.getParameterTypes()[0];
                if (!type.isInstance(result)) {
                    Object converted = Converters.convert((Object)result, type);
                    if (converted != null) {
                        result = converted;
                    } else {
                        return false;
                    }
                }
                s.invoke((Object)visitor, result);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void insert(SimpleFeature feature, SimpleFeatureType featureType, Connection cx) throws IOException {
        this.insert(Collections.singletonList(feature), featureType, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Collection features, SimpleFeatureType featureType, Connection cx) throws IOException {
        PrimaryKey key = this.getPrimaryKey(featureType);
        JDBCDataStore jDBCDataStore = this;
        synchronized (jDBCDataStore) {
            Statement st = null;
            try {
                if (!(this.dialect instanceof PreparedStatementSQLDialect)) {
                    st = cx.createStatement();
                }
                boolean postInsert = this.dialect.lookupGeneratedValuesPostInsert() && this.isGenerated(key);
                for (SimpleFeature feature : features) {
                    List<Object> keyValues = null;
                    boolean useExisting = Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
                    if (useExisting) {
                        keyValues = this.decodeFID(key, feature.getID(), true);
                    } else if (!postInsert) {
                        keyValues = this.getNextValues(key, cx);
                    }
                    if (this.dialect instanceof PreparedStatementSQLDialect) {
                        PreparedStatement ps = this.insertSQLPS(featureType, feature, keyValues, cx);
                        try {
                            ((PreparedStatementSQLDialect)this.dialect).onInsert(ps, cx, featureType);
                            ps.execute();
                        }
                        finally {
                            this.closeSafe(ps);
                        }
                    } else {
                        String sql = this.insertSQL(featureType, feature, keyValues, cx);
                        ((BasicSQLDialect)this.dialect).onInsert(st, cx, featureType);
                        this.LOGGER.log(Level.FINE, "Inserting new feature: {0}", sql);
                        st.execute(sql);
                    }
                    if (keyValues == null) {
                        keyValues = this.getLastValues(key, cx);
                    }
                    String fid = featureType.getTypeName() + "." + this.encodeFID(keyValues);
                    feature.getUserData().put("fid", fid);
                }
                this.closeSafe(st);
            }
            catch (SQLException e) {
                try {
                    String msg = "Error inserting features";
                    throw (IOException)new IOException(msg).initCause(e);
                }
                catch (Throwable throwable) {
                    this.closeSafe(st);
                    throw throwable;
                }
            }
        }
    }

    protected void update(SimpleFeatureType featureType, List<AttributeDescriptor> attributes, List<Object> values, Filter filter, Connection cx) throws IOException, SQLException {
        this.update(featureType, attributes.toArray(new AttributeDescriptor[attributes.size()]), values.toArray(new Object[values.size()]), filter, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(SimpleFeatureType featureType, AttributeDescriptor[] attributes, Object[] values, Filter filter, Connection cx) throws IOException, SQLException {
        block12: {
            if (attributes == null || attributes.length == 0) {
                this.LOGGER.warning("Update called with no attributes, doing nothing.");
                return;
            }
            if (this.dialect instanceof PreparedStatementSQLDialect) {
                try {
                    PreparedStatement ps = this.updateSQLPS(featureType, attributes, values, filter, cx);
                    try {
                        ((PreparedStatementSQLDialect)this.dialect).onUpdate(ps, cx, featureType);
                        ps.execute();
                        break block12;
                    }
                    finally {
                        this.closeSafe(ps);
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            String sql = this.updateSQL(featureType, attributes, values, filter);
            try {
                Statement st = cx.createStatement();
                try {
                    ((BasicSQLDialect)this.dialect).onUpdate(st, cx, featureType);
                    this.LOGGER.log(Level.FINE, "Updating feature: {0}", sql);
                    st.execute(sql);
                }
                finally {
                    this.closeSafe(st);
                }
            }
            catch (SQLException e) {
                String msg = "Error occured updating features";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
    }

    protected void delete(SimpleFeatureType featureType, String fid, Connection cx) throws IOException {
        Id filter = this.filterFactory.id(Collections.singleton(this.filterFactory.featureId(fid)));
        this.delete(featureType, (Filter)filter, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(SimpleFeatureType featureType, Filter filter, Connection cx) throws IOException {
        Statement st = null;
        try {
            try {
                if (this.dialect instanceof PreparedStatementSQLDialect) {
                    st = this.deleteSQLPS(featureType, filter, cx);
                    PreparedStatement ps = st;
                    ((PreparedStatementSQLDialect)this.dialect).onDelete(ps, cx, featureType);
                    ps.execute();
                } else {
                    String sql = this.deleteSQL(featureType, filter);
                    st = cx.createStatement();
                    ((BasicSQLDialect)this.dialect).onDelete(st, cx, featureType);
                    this.LOGGER.log(Level.FINE, "Removing feature(s): {0}", sql);
                    st.execute(sql);
                }
                this.closeSafe(st);
            }
            catch (Throwable throwable) {
                this.closeSafe(st);
                throw throwable;
            }
        }
        catch (SQLException e) {
            String msg = "Error occured during delete";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public Connection getConnection(Transaction t) throws IOException {
        if (t == Transaction.AUTO_COMMIT) {
            Connection cx = this.createConnection();
            try {
                cx.setAutoCommit(true);
            }
            catch (SQLException e) {
                throw (IOException)new IOException().initCause(e);
            }
            return cx;
        }
        JDBCTransactionState tstate = (JDBCTransactionState)t.getState((Object)this);
        if (tstate != null) {
            return tstate.cx;
        }
        Connection cx = this.createConnection();
        try {
            cx.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw (IOException)new IOException().initCause(e);
        }
        tstate = new JDBCTransactionState(cx, this);
        t.putState((Object)this, (Transaction.State)tstate);
        return cx;
    }

    protected final Connection getConnection(JDBCState state) throws IOException {
        return this.getConnection(state.getTransaction());
    }

    protected final Connection createConnection() {
        try {
            this.LOGGER.fine("CREATE CONNECTION");
            if (this.getDataSource() == null) {
                throw new NullPointerException("JDBC DataSource not available after dispose() has been called");
            }
            Connection cx = this.getDataSource().getConnection();
            this.dialect.initializeConnection(cx);
            if (this.connectionLifecycleListeners.size() > 0) {
                ArrayList<ConnectionLifecycleListener> locals = new ArrayList<ConnectionLifecycleListener>(this.connectionLifecycleListeners);
                cx = new LifecycleConnection(this, cx, locals);
            }
            return cx;
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to obtain connection: " + e.getMessage(), e);
        }
    }

    protected final void releaseConnection(Connection cx, JDBCState state) {
        if (state.getTransaction() == Transaction.AUTO_COMMIT) {
            this.closeSafe(cx);
        }
    }

    protected String encodeFID(PrimaryKey pkey, ResultSet rs) throws SQLException, IOException {
        return this.encodeFID(pkey, rs, 0);
    }

    protected String encodeFID(PrimaryKey pkey, ResultSet rs, int offset) throws SQLException, IOException {
        if (pkey.getColumns().isEmpty()) {
            return SimpleFeatureBuilder.createDefaultFeatureId();
        }
        if (pkey.getColumns().size() == 1) {
            return rs.getString(offset + 1);
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (int i = 0; i < pkey.getColumns().size(); ++i) {
            String o = rs.getString(offset + i + 1);
            keyValues.add(o);
        }
        return this.encodeFID(keyValues);
    }

    protected String encodeFID(List<Object> keyValues) {
        StringBuffer fid = new StringBuffer();
        for (Object o : keyValues) {
            fid.append(o).append(".");
        }
        fid.setLength(fid.length() - 1);
        return fid.toString();
    }

    protected List<Object> decodeFID(PrimaryKey key, String FID, boolean strict) {
        if (FID.startsWith(key.getTableName() + ".")) {
            FID = FID.substring(key.getTableName().length() + 1);
        }
        try {
            FID = URLDecoder.decode(FID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> values = null;
        if (key.getColumns().size() > 1) {
            String[] split = FID.split("\\.");
            values = new ArrayList(split.length);
            for (int i = 0; i < split.length; ++i) {
                values.add(split[i]);
            }
        } else {
            values = new ArrayList<Object>();
            values.add(FID);
        }
        if (values.size() != key.getColumns().size()) {
            throw new IllegalArgumentException("Illegal fid: " + FID + ". Expected " + key.getColumns().size() + " values but got " + values.size());
        }
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            Class type = key.getColumns().get(i).getType();
            Object converted = Converters.convert(value, (Class)type);
            if (converted != null) {
                values.set(i, converted);
            }
            if (!strict || type.isInstance(values.get(i))) continue;
            throw new IllegalArgumentException("Value " + values.get(i) + " illegal for type " + type.getName());
        }
        return values;
    }

    protected boolean isGenerated(PrimaryKey pkey) {
        for (PrimaryKeyColumn col : pkey.getColumns()) {
            if (col instanceof AutoGeneratedPrimaryKeyColumn) continue;
            return false;
        }
        return true;
    }

    protected List<Object> getNextValues(PrimaryKey pkey, Connection cx) throws SQLException, IOException {
        ArrayList<Object> next = new ArrayList<Object>();
        for (PrimaryKeyColumn col : pkey.getColumns()) {
            next.add(this.getNextValue(col, pkey, cx));
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getNextValue(PrimaryKeyColumn col, PrimaryKey pkey, Connection cx) throws SQLException, IOException {
        Object next = null;
        if (col instanceof AutoGeneratedPrimaryKeyColumn) {
            return this.dialect.getNextAutoGeneratedValue(this.databaseSchema, pkey.getTableName(), col.getName(), cx);
        }
        if (col instanceof SequencedPrimaryKeyColumn) {
            String sequenceName = ((SequencedPrimaryKeyColumn)col).getSequenceName();
            return this.dialect.getNextSequenceValue(this.databaseSchema, sequenceName, cx);
        }
        Class t = col.getType();
        if (Number.class.isAssignableFrom(t)) {
            if (t == Short.class || t == Integer.class || t == Long.class || BigInteger.class.isAssignableFrom(t) || BigDecimal.class.isAssignableFrom(t)) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT MAX(");
                this.dialect.encodeColumnName(col.getName(), sql);
                sql.append(") + 1 FROM ");
                this.encodeTableName(pkey.getTableName(), sql, null);
                this.LOGGER.log(Level.FINE, "Getting next FID: {0}", sql);
                Statement st = cx.createStatement();
                try {
                    ResultSet rs = st.executeQuery(sql.toString());
                    try {
                        rs.next();
                        next = rs.getObject(1);
                        if (next == null) {
                            next = new Integer(1);
                        }
                    }
                    finally {
                        this.closeSafe(rs);
                    }
                }
                finally {
                    this.closeSafe(st);
                }
            }
        } else if (CharSequence.class.isAssignableFrom(t)) {
            next = SimpleFeatureBuilder.createDefaultFeatureId();
        }
        if (next != null) return next;
        throw new IOException("Cannot generate key value for column of type: " + t.getName());
    }

    protected List<Object> getLastValues(PrimaryKey pkey, Connection cx) throws SQLException, IOException {
        ArrayList<Object> last = new ArrayList<Object>();
        for (PrimaryKeyColumn col : pkey.getColumns()) {
            last.add(this.getLastValue(col, pkey, cx));
        }
        return last;
    }

    protected Object getLastValue(PrimaryKeyColumn col, PrimaryKey pkey, Connection cx) throws SQLException, IOException {
        Object last = null;
        if (!(col instanceof AutoGeneratedPrimaryKeyColumn)) {
            throw new IllegalArgumentException("Column " + col.getName() + " is not generated.");
        }
        last = this.dialect.getLastAutoGeneratedValue(this.databaseSchema, pkey.getTableName(), col.getName(), cx);
        return last;
    }

    protected String createTableSQL(SimpleFeatureType featureType, Connection cx) throws Exception {
        int i;
        String[] columnNames = new String[featureType.getAttributeCount()];
        String[] sqlTypeNames = null;
        Class[] classes = new Class[featureType.getAttributeCount()];
        boolean[] nillable = new boolean[featureType.getAttributeCount()];
        for (i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = featureType.getDescriptor(i);
            columnNames[i] = attributeType.getLocalName();
            classes[i] = attributeType.getType().getBinding();
            nillable[i] = attributeType.getMinOccurs() <= 0 || attributeType.isNillable();
        }
        sqlTypeNames = this.getSQLTypeNames(classes, cx);
        for (i = 0; i < sqlTypeNames.length; ++i) {
            if (sqlTypeNames[i] != null) continue;
            String msg = "Unable to map " + columnNames[i] + "( " + classes[i].getName() + ")";
            throw new RuntimeException(msg);
        }
        return this.createTableSQL(featureType.getTypeName(), columnNames, sqlTypeNames, nillable, "fid", featureType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureAuthorization(SimpleFeatureType featureType, Filter filter, Transaction tx, Connection cx) throws IOException, SQLException {
        DefaultQuery query = new DefaultQuery(featureType.getTypeName(), filter, Query.NO_NAMES);
        Statement st = null;
        try {
            ResultSet rs = null;
            if (this.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                st = this.selectSQLPS(featureType, (Query)query, cx);
                PreparedStatement ps = st;
                ((PreparedStatementSQLDialect)this.getSQLDialect()).onSelect(ps, cx, featureType);
                rs = ps.executeQuery();
            } else {
                String sql = this.selectSQL(featureType, (Query)query);
                st = cx.createStatement();
                ((BasicSQLDialect)this.getSQLDialect()).onSelect(st, cx, featureType);
                this.LOGGER.fine(sql);
                rs = st.executeQuery(sql);
            }
            try {
                PrimaryKey key = this.getPrimaryKey(featureType);
                InProcessLockingManager lm = (InProcessLockingManager)this.getLockingManager();
                while (rs.next()) {
                    String fid = featureType.getTypeName() + "." + this.encodeFID(key, rs);
                    lm.assertAccess(featureType.getTypeName(), fid, tx);
                }
            }
            finally {
                this.closeSafe(rs);
            }
            this.closeSafe(st);
        }
        catch (Throwable throwable) {
            this.closeSafe(st);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureAssociationTablesExist(Connection cx) throws IOException, SQLException {
        block34: {
            Statement st;
            String sql;
            ResultSet tables;
            block33: {
                block32: {
                    block31: {
                        block30: {
                            tables = cx.getMetaData().getTables(null, this.databaseSchema, FEATURE_RELATIONSHIP_TABLE, null);
                            try {
                                if (tables.next()) break block30;
                                sql = this.createRelationshipTableSQL(cx);
                                this.LOGGER.log(Level.FINE, "Creating relationship table: {0}", sql);
                                st = cx.createStatement();
                                try {
                                    st.execute(sql);
                                }
                                finally {
                                    this.closeSafe(st);
                                }
                            }
                            finally {
                                this.closeSafe(tables);
                            }
                        }
                        tables = cx.getMetaData().getTables(null, this.databaseSchema, FEATURE_ASSOCIATION_TABLE, null);
                        try {
                            if (tables.next()) break block31;
                            sql = this.createAssociationTableSQL(cx);
                            this.LOGGER.log(Level.FINE, "Creating association table: {0}", sql);
                            st = cx.createStatement();
                            try {
                                st.execute(sql);
                            }
                            finally {
                                this.closeSafe(st);
                            }
                        }
                        finally {
                            this.closeSafe(tables);
                        }
                    }
                    tables = cx.getMetaData().getTables(null, this.databaseSchema, GEOMETRY_TABLE, null);
                    try {
                        if (tables.next()) break block32;
                        sql = this.createGeometryTableSQL(cx);
                        this.LOGGER.log(Level.FINE, "Creating geometry table: {0}", sql);
                        st = cx.createStatement();
                        try {
                            st.execute(sql);
                        }
                        finally {
                            this.closeSafe(st);
                        }
                    }
                    finally {
                        this.closeSafe(tables);
                    }
                }
                tables = cx.getMetaData().getTables(null, this.databaseSchema, MULTI_GEOMETRY_TABLE, null);
                try {
                    if (tables.next()) break block33;
                    sql = this.createMultiGeometryTableSQL(cx);
                    this.LOGGER.log(Level.FINE, "Creating multi-geometry table: {0}", sql);
                    st = cx.createStatement();
                    try {
                        st.execute(sql);
                    }
                    finally {
                        this.closeSafe(st);
                    }
                }
                finally {
                    this.closeSafe(tables);
                }
            }
            tables = cx.getMetaData().getTables(null, this.databaseSchema, GEOMETRY_ASSOCIATION_TABLE, null);
            try {
                if (tables.next()) break block34;
                sql = this.createGeometryAssociationTableSQL(cx);
                this.LOGGER.log(Level.FINE, "Creating geometry association table: {0}", sql);
                st = cx.createStatement();
                try {
                    st.execute(sql);
                }
                finally {
                    this.closeSafe(st);
                }
            }
            finally {
                this.closeSafe(tables);
            }
        }
    }

    protected String createRelationshipTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(new Class[]{String.class, String.class}, cx);
        String[] columnNames = new String[]{"table", "col"};
        return this.createTableSQL(FEATURE_RELATIONSHIP_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String createAssociationTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(new Class[]{String.class, String.class, String.class, String.class}, cx);
        String[] columnNames = new String[]{"fid", "rtable", "rcol", "rfid"};
        return this.createTableSQL(FEATURE_ASSOCIATION_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String createGeometryTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(new Class[]{String.class, String.class, String.class, String.class, Geometry.class}, cx);
        String[] columnNames = new String[]{"id", "name", "description", "type", GEOMETRY_TABLE};
        return this.createTableSQL(GEOMETRY_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String createMultiGeometryTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(new Class[]{String.class, String.class, Boolean.class}, cx);
        String[] columnNames = new String[]{"id", "mgid", "ref"};
        return this.createTableSQL(MULTI_GEOMETRY_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String selectRelationshipSQL(String table, String column) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("table", sql);
        sql.append(",");
        dialect.encodeColumnName("col", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_RELATIONSHIP_TABLE, sql, null);
        if (table != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("table", sql);
            sql.append(" = ");
            dialect.encodeValue(table, String.class, sql);
        }
        if (column != null) {
            if (table == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName("col", sql);
            sql.append(" = ");
            dialect.encodeValue(column, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectRelationshipSQLPS(String table, String column, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("table", sql);
        sql.append(",");
        dialect.encodeColumnName("col", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_RELATIONSHIP_TABLE, sql, null);
        if (table != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("table", sql);
            sql.append(" = ? ");
        }
        if (column != null) {
            if (table == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName("col", sql);
            sql.append(" = ? ");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (table != null) {
            ps.setString(1, table);
        }
        if (column != null) {
            ps.setString(table != null ? 2 : 1, column);
        }
        return ps;
    }

    protected String selectAssociationSQL(String fid) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("fid", sql);
        sql.append(",");
        dialect.encodeColumnName("rtable", sql);
        sql.append(",");
        dialect.encodeColumnName("rcol", sql);
        sql.append(", ");
        dialect.encodeColumnName("rfid", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("fid", sql);
            sql.append(" = ");
            dialect.encodeValue(fid, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectAssociationSQLPS(String fid, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("fid", sql);
        sql.append(",");
        dialect.encodeColumnName("rtable", sql);
        sql.append(",");
        dialect.encodeColumnName("rcol", sql);
        sql.append(", ");
        dialect.encodeColumnName("rfid", sql);
        sql.append(" FROM ");
        this.encodeTableName(FEATURE_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("fid", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (fid != null) {
            ps.setString(1, fid);
        }
        return ps;
    }

    protected String selectGeometrySQL(String gid) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("id", sql);
        sql.append(",");
        dialect.encodeColumnName("name", sql);
        sql.append(",");
        dialect.encodeColumnName("description", sql);
        sql.append(",");
        dialect.encodeColumnName("type", sql);
        sql.append(",");
        dialect.encodeColumnName(GEOMETRY_TABLE, sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("id", sql);
            sql.append(" = ");
            dialect.encodeValue(gid, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectGeometrySQLPS(String gid, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("id", sql);
        sql.append(",");
        dialect.encodeColumnName("name", sql);
        sql.append(",");
        dialect.encodeColumnName("description", sql);
        sql.append(",");
        dialect.encodeColumnName("type", sql);
        sql.append(",");
        dialect.encodeColumnName(GEOMETRY_TABLE, sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("id", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (gid != null) {
            ps.setString(1, gid);
        }
        return ps;
    }

    protected String selectMultiGeometrySQL(String gid) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("id", sql);
        sql.append(",");
        dialect.encodeColumnName("mgid", sql);
        sql.append(",");
        dialect.encodeColumnName("ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(MULTI_GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("id", sql);
            sql.append(" = ");
            dialect.encodeValue(gid, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectMultiGeometrySQLPS(String gid, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("id", sql);
        sql.append(",");
        dialect.encodeColumnName("mgid", sql);
        sql.append(",");
        dialect.encodeColumnName("ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(MULTI_GEOMETRY_TABLE, sql, null);
        if (gid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("id", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (gid != null) {
            ps.setString(1, gid);
        }
        return ps;
    }

    protected String createGeometryAssociationTableSQL(Connection cx) throws SQLException {
        String[] sqlTypeNames = this.getSQLTypeNames(new Class[]{String.class, String.class, String.class, Boolean.class}, cx);
        String[] columnNames = new String[]{"fid", "gname", "gid", "ref"};
        return this.createTableSQL(GEOMETRY_ASSOCIATION_TABLE, columnNames, sqlTypeNames, null, null, null);
    }

    protected String selectGeometryAssociationSQL(String fid, String gid, String gname) throws SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("fid", sql);
        sql.append(",");
        dialect.encodeColumnName("gid", sql);
        sql.append(",");
        dialect.encodeColumnName("gname", sql);
        sql.append(",");
        dialect.encodeColumnName("ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("fid", sql);
            sql.append(" = ");
            dialect.encodeValue(fid, String.class, sql);
        }
        if (gid != null) {
            if (fid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName("gid", sql);
            sql.append(" = ");
            dialect.encodeValue(gid, String.class, sql);
        }
        if (gname != null) {
            if (fid == null && gid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName("gname", sql);
            sql.append(" = ");
            dialect.encodeValue(gname, String.class, sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectGeometryAssociationSQLPS(String fid, String gid, String gname, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        dialect.encodeColumnName("fid", sql);
        sql.append(",");
        dialect.encodeColumnName("gid", sql);
        sql.append(",");
        dialect.encodeColumnName("gname", sql);
        sql.append(",");
        dialect.encodeColumnName("ref", sql);
        sql.append(" FROM ");
        this.encodeTableName(GEOMETRY_ASSOCIATION_TABLE, sql, null);
        if (fid != null) {
            sql.append(" WHERE ");
            dialect.encodeColumnName("fid", sql);
            sql.append(" = ? ");
        }
        if (gid != null) {
            if (fid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName("gid", sql);
            sql.append(" = ? ");
        }
        if (gname != null) {
            if (fid == null && gid == null) {
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            dialect.encodeColumnName("gname", sql);
            sql.append(" = ?");
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (fid != null) {
            ps.setString(1, fid);
        }
        if (gid != null) {
            ps.setString(fid != null ? 2 : 1, gid);
        }
        if (gname != null) {
            ps.setString(fid != null ? (gid != null ? 3 : 2) : (gid != null ? 2 : 1), gname);
        }
        return ps;
    }

    private String createTableSQL(String tableName, String[] columnNames, String[] sqlTypeNames, boolean[] nillable, String pkeyColumn, SimpleFeatureType featureType) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        this.encodeTableName(tableName, sql, null);
        sql.append(" ( ");
        if (pkeyColumn != null) {
            this.dialect.encodePrimaryKey(pkeyColumn, sql);
            sql.append(", ");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            AttributeDescriptor att;
            this.dialect.encodeColumnName(columnNames[i], sql);
            sql.append(" ");
            int length = -1;
            if (sqlTypeNames[i].toUpperCase().startsWith("VARCHAR") && featureType != null) {
                att = featureType.getDescriptor(columnNames[i]);
                length = this.findVarcharColumnLength(att);
            }
            if (length == -1) {
                this.dialect.encodeColumnType(sqlTypeNames[i], sql);
            } else {
                this.dialect.encodeColumnType(sqlTypeNames[i] + "(" + length + ")", sql);
            }
            if (nillable != null && !nillable[i]) {
                sql.append(" NOT NULL ");
            }
            if (featureType != null) {
                att = featureType.getDescriptor(columnNames[i]);
                this.dialect.encodePostColumnCreateTable(att, sql);
            }
            if (i >= sqlTypeNames.length - 1) continue;
            sql.append(", ");
        }
        sql.append(" ) ");
        this.dialect.encodePostCreateTable(tableName, sql);
        return sql.toString();
    }

    private Integer findVarcharColumnLength(AttributeDescriptor att) {
        for (Filter r : att.getType().getRestrictions()) {
            Integer length;
            PropertyIsLessThanOrEqualTo c;
            if (!(r instanceof PropertyIsLessThanOrEqualTo) || !((c = (PropertyIsLessThanOrEqualTo)r).getExpression1() instanceof Function) || !((Function)c.getExpression1()).getName().toLowerCase().endsWith("length") || !(c.getExpression2() instanceof Literal) || (length = (Integer)c.getExpression2().evaluate(null, Integer.class)) == null) continue;
            return length;
        }
        return this.dialect.getDefaultVarcharSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSQLTypeNames(Class[] classes, Connection cx) throws SQLException {
        String sqlTypeName;
        int[] sqlTypes = new int[classes.length];
        String[] sqlTypeNames = new String[sqlTypes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class clazz = classes[i];
            Integer sqlType = this.getMapping(clazz);
            if (sqlType == null) {
                this.LOGGER.warning("No sql type mapping for: " + clazz);
                sqlType = 1111;
            }
            sqlTypes[i] = sqlType;
            if (Geometry.class.isAssignableFrom(clazz) && (sqlTypeName = this.dialect.getGeometryTypeName(sqlType)) != null) {
                sqlTypeNames[i] = sqlTypeName;
            }
            if ((sqlTypeName = this.getSqlTypeToSqlTypeNameOverrides().get(sqlType)) == null) continue;
            sqlTypeNames[i] = sqlTypeName;
        }
        DatabaseMetaData metaData = cx.getMetaData();
        ResultSet types = metaData.getTypeInfo();
        try {
            while (types.next()) {
                int sqlType = types.getInt("DATA_TYPE");
                sqlTypeName = types.getString("TYPE_NAME");
                for (int i = 0; i < sqlTypes.length; ++i) {
                    if (sqlTypeNames[i] != null || sqlType != sqlTypes[i]) continue;
                    sqlTypeNames[i] = sqlTypeName;
                }
            }
        }
        finally {
            this.closeSafe(types);
        }
        Map<Integer, String> overrides = this.getSqlTypeToSqlTypeNameOverrides();
        for (int i = 0; i < sqlTypes.length; ++i) {
            String override = overrides.get(sqlTypes[i]);
            if (override == null) continue;
            sqlTypeNames[i] = override;
        }
        return sqlTypeNames;
    }

    protected String selectSQL(SimpleFeatureType featureType, Query query) throws IOException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, null, query, sql);
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, query.getHints());
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            sql.append(" WHERE ");
            this.filter(featureType, filter, sql);
        }
        this.sort(featureType, query.getSortBy(), null, sql);
        this.applyLimitOffset(sql, query);
        return sql.toString();
    }

    protected String selectJoinSQL(SimpleFeatureType featureType, JoinInfo join, Query query) throws IOException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, join.getPrimaryAlias(), query, sql);
        for (JoinInfo.JoinPart part : join.getParts()) {
            this.selectColumns(part.getQueryFeatureType(), part.getAlias(), query, sql);
        }
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableJoin(featureType, join, query, sql);
        this.encodeWhereJoin(featureType, join, sql);
        this.sort(featureType, query.getSortBy(), join.getPrimaryAlias(), sql);
        this.applyLimitOffset(sql, query);
        return sql.toString();
    }

    void selectColumns(SimpleFeatureType featureType, String prefix, Query query, StringBuffer sql) throws IOException {
        PrimaryKey key = null;
        try {
            key = this.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<String> pkColumnNames = this.getColumnNames(key);
        for (PrimaryKeyColumn col : key.getColumns()) {
            this.dialect.encodeColumnName(prefix, col.getName(), sql);
            if (prefix != null) {
                this.dialect.encodeColumnAlias(prefix + "_" + col.getName(), sql);
            }
            sql.append(",");
        }
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String columnName = att.getLocalName();
            if (pkColumnNames.contains(columnName)) continue;
            String alias = null;
            if (att.getUserData().containsKey(JDBC_COLUMN_ALIAS)) {
                alias = (String)att.getUserData().get(JDBC_COLUMN_ALIAS);
            }
            if (att instanceof GeometryDescriptor) {
                int i = sql.length();
                this.encodeGeometryColumn((GeometryDescriptor)att, prefix, sql, query.getHints());
                if (alias == null) {
                    alias = columnName;
                }
            } else {
                this.dialect.encodeColumnName(prefix, columnName, sql);
            }
            if (alias != null) {
                this.dialect.encodeColumnAlias(alias, sql);
            }
            sql.append(",");
        }
    }

    FilterToSQL filter(SimpleFeatureType featureType, Filter filter, StringBuffer sql) throws IOException {
        try {
            SimpleFeatureType fullSchema = this.getSchema(featureType.getTypeName());
            FilterToSQL toSQL = this.dialect instanceof PreparedStatementSQLDialect ? this.createPreparedFilterToSQL(fullSchema) : this.createFilterToSQL(fullSchema);
            toSQL.setInline(true);
            sql.append(" ").append(toSQL.encodeToString(filter));
            return toSQL;
        }
        catch (FilterToSQLException e) {
            throw new RuntimeException(e);
        }
    }

    void sort(SimpleFeatureType featureType, SortBy[] sort, String prefix, StringBuffer sql) throws IOException {
        if (sort != null && sort.length > 0) {
            PrimaryKey key = this.getPrimaryKey(featureType);
            sql.append(" ORDER BY ");
            for (int i = 0; i < sort.length; ++i) {
                String order = sort[i].getSortOrder() == SortOrder.DESCENDING ? " DESC" : " ASC";
                if (SortBy.NATURAL_ORDER.equals(sort[i]) || SortBy.REVERSE_ORDER.equals(sort[i])) {
                    if (key instanceof NullPrimaryKey) {
                        throw new IOException("Cannot do natural order without a primary key");
                    }
                    for (PrimaryKeyColumn col : key.getColumns()) {
                        this.dialect.encodeColumnName(prefix, col.getName(), sql);
                        sql.append(order);
                        sql.append(",");
                    }
                    continue;
                }
                this.dialect.encodeColumnName(prefix, this.getPropertyName(featureType, sort[i].getPropertyName()), sql);
                sql.append(order);
                sql.append(",");
            }
            sql.setLength(sql.length() - 1);
        }
    }

    protected PreparedStatement selectSQLPS(SimpleFeatureType featureType, Query query, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, null, query, sql);
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, query.getHints());
        PreparedFilterToSQL toSQL = null;
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            sql.append(" WHERE ");
            toSQL = (PreparedFilterToSQL)this.filter(featureType, filter, sql);
        }
        this.sort(featureType, query.getSortBy(), null, sql);
        this.applyLimitOffset(sql, query);
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(this.fetchSize);
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, 0, cx);
        }
        return ps;
    }

    protected PreparedStatement selectJoinSQLPS(SimpleFeatureType featureType, JoinInfo join, Query query, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.selectColumns(featureType, join.getPrimaryAlias(), query, sql);
        for (JoinInfo.JoinPart part : join.getParts()) {
            this.selectColumns(part.getQueryFeatureType(), part.getAlias(), query, sql);
        }
        sql.setLength(sql.length() - 1);
        this.dialect.encodePostSelect(featureType, sql);
        sql.append(" FROM ");
        this.encodeTableJoin(featureType, join, query, sql);
        List<FilterToSQL> toSQLs = this.encodeWhereJoin(featureType, join, sql);
        this.sort(featureType, query.getSortBy(), join.getPrimaryAlias(), sql);
        this.applyLimitOffset(sql, query);
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(this.fetchSize);
        this.setPreparedFilterValues(ps, toSQLs, cx);
        return ps;
    }

    protected void setPreparedFilterValues(PreparedStatement ps, List toSQLs, Connection cx) throws SQLException {
        int offset = 0;
        for (PreparedFilterToSQL toSQL : toSQLs) {
            this.setPreparedFilterValues(ps, toSQL, offset, cx);
            offset += toSQL.getLiteralValues().size();
        }
    }

    protected void setPreparedFilterValues(PreparedStatement ps, PreparedFilterToSQL toSQL, int offset, Connection cx) throws SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        for (int i = 0; i < toSQL.getLiteralValues().size(); ++i) {
            Object value = toSQL.getLiteralValues().get(i);
            Class binding = toSQL.getLiteralTypes().get(i);
            Integer srid = toSQL.getSRIDs().get(i);
            if (srid == null) {
                srid = -1;
            }
            if (binding != null && Geometry.class.isAssignableFrom(binding)) {
                dialect.setGeometryValue((Geometry)value, srid, binding, ps, offset + i + 1);
            } else {
                dialect.setValue(value, binding, ps, offset + i + 1, cx);
            }
            if (!this.LOGGER.isLoggable(Level.FINE)) continue;
            this.LOGGER.fine(i + 1 + " = " + value);
        }
    }

    protected String getPropertyName(SimpleFeatureType featureType, PropertyName propertyName) {
        AttributeDescriptor att = (AttributeDescriptor)propertyName.evaluate((Object)featureType);
        if (att != null) {
            return att.getLocalName();
        }
        return propertyName.getPropertyName();
    }

    protected String selectBoundsSQL(SimpleFeatureType featureType, Query query) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean offsetLimit = this.checkLimitOffset(query);
        if (offsetLimit) {
            sql.append(" SELECT *");
        } else {
            sql.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sql);
        }
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, query.getHints());
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                FilterToSQL toSQL = this.createFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (offsetLimit) {
            this.applyLimitOffset(sql, query);
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sb);
            sb.append("FROM (");
            sql.insert(0, sb.toString());
            sql.append(")");
            this.dialect.encodeTableAlias("GT2_BOUNDS_", sql);
        }
        return sql.toString();
    }

    protected PreparedStatement selectBoundsSQLPS(SimpleFeatureType featureType, Query query, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean offsetLimit = this.checkLimitOffset(query);
        if (offsetLimit) {
            sql.append(" SELECT *");
        } else {
            sql.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sql);
        }
        sql.append(" FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, query.getHints());
        PreparedFilterToSQL toSQL = null;
        Filter filter = query.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                toSQL = this.createPreparedFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (offsetLimit) {
            this.applyLimitOffset(sql, query);
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ");
            this.buildEnvelopeAggregates(featureType, sb);
            sb.append("FROM (");
            sql.insert(0, sb.toString());
            sql.append(")");
            this.dialect.encodeTableAlias("GT2_BOUNDS_", sql);
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, 0, cx);
        }
        return ps;
    }

    void buildEnvelopeAggregates(SimpleFeatureType featureType, StringBuffer sql) {
        for (AttributeDescriptor attribute : featureType.getAttributeDescriptors()) {
            if (!(attribute instanceof GeometryDescriptor)) continue;
            String geometryColumn = featureType.getGeometryDescriptor().getLocalName();
            this.dialect.encodeGeometryEnvelope(featureType.getTypeName(), geometryColumn, sql);
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
    }

    protected String selectCountSQL(SimpleFeatureType featureType, Query query) throws SQLException, IOException {
        return this.selectAggregateSQL("count", null, featureType, query);
    }

    protected PreparedStatement selectCountSQLPS(SimpleFeatureType featureType, Query query, Connection cx) throws SQLException, IOException {
        return this.selectAggregateSQLPS("count", null, featureType, query, cx);
    }

    protected String selectAggregateSQL(String function, AttributeDescriptor att, SimpleFeatureType featureType, Query query) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        this.doSelectAggregateSQL(function, att, featureType, query, sql);
        return sql.toString();
    }

    protected PreparedStatement selectAggregateSQLPS(String function, AttributeDescriptor att, SimpleFeatureType featureType, Query query, Connection cx) throws SQLException, IOException {
        StringBuffer sql = new StringBuffer();
        List<FilterToSQL> toSQL = this.doSelectAggregateSQL(function, att, featureType, query, sql);
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString(), 1003, 1007);
        ps.setFetchSize(this.fetchSize);
        this.setPreparedFilterValues(ps, toSQL, cx);
        return ps;
    }

    List<FilterToSQL> doSelectAggregateSQL(String function, AttributeDescriptor att, SimpleFeatureType featureType, Query query, StringBuffer sql) throws SQLException, IOException {
        JoinInfo join = !query.getJoins().isEmpty() ? JoinInfo.create(query, featureType, this) : null;
        boolean limitOffset = this.checkLimitOffset(query);
        if (limitOffset) {
            if (join != null) {
                sql.append("SELECT ");
                this.dialect.encodeColumnName(null, join.getPrimaryAlias(), sql);
                sql.append(".* FROM ");
            } else {
                sql.append("SELECT * FROM ");
            }
        } else {
            sql.append("SELECT ");
            this.encodeFunction(function, att, query, sql);
            sql.append(" FROM ");
        }
        if (join != null) {
            this.encodeTableJoin(featureType, join, query, sql);
        } else {
            this.encodeTableName(featureType.getTypeName(), sql, query.getHints());
        }
        ArrayList<FilterToSQL> toSQL = new ArrayList<FilterToSQL>();
        if (join != null) {
            toSQL.addAll(this.encodeWhereJoin(featureType, join, sql));
        } else {
            Filter filter = query.getFilter();
            if (filter != null && !Filter.INCLUDE.equals(filter)) {
                sql.append(" WHERE ");
                toSQL.add(this.filter(featureType, filter, sql));
            }
        }
        if (limitOffset) {
            this.applyLimitOffset(sql, query);
            StringBuffer sql2 = new StringBuffer("SELECT ");
            this.encodeFunction(function, att, query, sql2);
            sql2.append(" AS gt_result_");
            sql2.append(" FROM (");
            sql.insert(0, sql2.toString());
            sql.append(") gt_limited_");
        }
        return toSQL;
    }

    protected void encodeFunction(String function, AttributeDescriptor att, Query query, StringBuffer sql) {
        sql.append(function).append("(");
        if (att == null) {
            sql.append("*");
        } else if (att instanceof GeometryDescriptor) {
            this.encodeGeometryColumn((GeometryDescriptor)att, sql, query.getHints());
        } else {
            this.dialect.encodeColumnName(att.getLocalName(), sql);
        }
        sql.append(")");
    }

    protected String deleteSQL(SimpleFeatureType featureType, Filter filter) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                FilterToSQL toSQL = this.createFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        return sql.toString();
    }

    protected PreparedStatement deleteSQLPS(SimpleFeatureType featureType, Filter filter, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        PreparedFilterToSQL toSQL = null;
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                toSQL = this.createPreparedFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, 0, cx);
        }
        return ps;
    }

    protected String insertSQL(SimpleFeatureType featureType, SimpleFeature feature, List keyValues, Connection cx) throws SQLException {
        int i;
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        PrimaryKey key = null;
        try {
            key = this.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<String> pkColumnNames = this.getColumnNames(key);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (int i2 = 0; i2 < featureType.getAttributeCount(); ++i2) {
            String colName = featureType.getDescriptor(i2).getLocalName();
            if (pkColumnNames.contains(colName)) continue;
            dialect.encodeColumnName(colName, sql);
            sql.append(",");
        }
        boolean useExisting = Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
        for (PrimaryKeyColumn col : key.getColumns()) {
            if (col instanceof AutoGeneratedPrimaryKeyColumn && !useExisting) continue;
            dialect.encodeColumnName(col.getName(), sql);
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES ( ");
        for (i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor att = featureType.getDescriptor(i);
            String colName = att.getLocalName();
            if (pkColumnNames.contains(colName)) continue;
            Class binding = att.getType().getBinding();
            Object value = feature.getAttribute(colName);
            if (value == null) {
                if (!att.isNillable()) {
                    // empty if block
                }
                sql.append("null");
            } else if (Geometry.class.isAssignableFrom(binding)) {
                try {
                    Geometry g = (Geometry)value;
                    int srid = this.getGeometrySRID(g, att);
                    dialect.encodeGeometryValue(g, srid, sql);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                dialect.encodeValue(value, binding, sql);
            }
            sql.append(",");
        }
        for (i = 0; i < key.getColumns().size(); ++i) {
            PrimaryKeyColumn col;
            col = key.getColumns().get(i);
            if (col instanceof AutoGeneratedPrimaryKeyColumn && !useExisting) continue;
            try {
                Object value = keyValues.get(i);
                dialect.encodeValue(value, col.getType(), sql);
                sql.append(",");
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        sql.setLength(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    protected LinkedHashSet<String> getColumnNames(PrimaryKey key) {
        LinkedHashSet<String> pkColumnNames = new LinkedHashSet<String>();
        for (PrimaryKeyColumn pkcol : key.getColumns()) {
            pkColumnNames.add(pkcol.getName());
        }
        return pkColumnNames;
    }

    protected PreparedStatement insertSQLPS(SimpleFeatureType featureType, SimpleFeature feature, List keyValues, Connection cx) throws IOException, SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        PrimaryKey key = null;
        try {
            key = this.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<String> pkColumnNames = this.getColumnNames(key);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            String colName = featureType.getDescriptor(i).getLocalName();
            if (pkColumnNames.contains(colName)) continue;
            dialect.encodeColumnName(colName, sql);
            sql.append(",");
        }
        boolean useExisting = Boolean.TRUE.equals(feature.getUserData().get(Hints.USE_PROVIDED_FID));
        for (PrimaryKeyColumn col : key.getColumns()) {
            if (col instanceof AutoGeneratedPrimaryKeyColumn && !useExisting) continue;
            dialect.encodeColumnName(col.getName(), sql);
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES ( ");
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String colName = att.getLocalName();
            if (pkColumnNames.contains(colName)) continue;
            if (att instanceof GeometryDescriptor) {
                Geometry geometry = (Geometry)feature.getAttribute(att.getName());
                dialect.prepareGeometryValue(geometry, this.getDescriptorSRID(att), att.getType().getBinding(), sql);
            } else {
                sql.append("?");
            }
            sql.append(",");
        }
        for (PrimaryKeyColumn col : key.getColumns()) {
            if (col instanceof AutoGeneratedPrimaryKeyColumn && !useExisting) continue;
            sql.append("?").append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(")");
        this.LOGGER.log(Level.FINE, "Inserting new feature with ps: {0}", sql);
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        int i = 1;
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String colName = att.getLocalName();
            if (pkColumnNames.contains(colName)) continue;
            Class binding = att.getType().getBinding();
            Object value = feature.getAttribute(colName);
            if (value != null || !att.isNillable()) {
                // empty if block
            }
            if (Geometry.class.isAssignableFrom(binding)) {
                Geometry g = (Geometry)value;
                int srid = this.getGeometrySRID(g, att);
                dialect.setGeometryValue(g, srid, binding, ps, i);
            } else {
                dialect.setValue(value, binding, ps, i, cx);
            }
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.fine(i + " = " + value);
            }
            ++i;
        }
        for (int j = 0; j < key.getColumns().size(); ++j) {
            PrimaryKeyColumn col = key.getColumns().get(j);
            if (col instanceof AutoGeneratedPrimaryKeyColumn && !useExisting) continue;
            Object value = keyValues.get(j);
            dialect.setValue(value, col.getType(), ps, i, cx);
            ++i;
            if (!this.LOGGER.isLoggable(Level.FINE)) continue;
            this.LOGGER.fine(i + " = " + value);
        }
        return ps;
    }

    protected int getGeometrySRID(Geometry g, AttributeDescriptor descriptor) throws IOException {
        CoordinateReferenceSystem crs;
        int srid = this.getDescriptorSRID(descriptor);
        if (g == null) {
            return srid;
        }
        if (srid <= 0 && g.getSRID() > 0) {
            srid = g.getSRID();
        }
        if (srid <= 0 && (crs = (CoordinateReferenceSystem)g.getUserData()) != null) {
            try {
                Integer candidate = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                if (candidate != null) {
                    srid = candidate;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return srid;
    }

    protected int getDescriptorSRID(AttributeDescriptor descriptor) {
        int srid = -1;
        if (descriptor.getUserData().get(JDBC_NATIVE_SRID) != null) {
            srid = (Integer)descriptor.getUserData().get(JDBC_NATIVE_SRID);
        }
        return srid;
    }

    protected String updateSQL(SimpleFeatureType featureType, AttributeDescriptor[] attributes, Object[] values, Filter filter) throws IOException, SQLException {
        BasicSQLDialect dialect = (BasicSQLDialect)this.getSQLDialect();
        PrimaryKey key = null;
        try {
            key = this.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<String> pkColumnNames = this.getColumnNames(key);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" SET ");
        for (int i = 0; i < attributes.length; ++i) {
            String attName = attributes[i].getLocalName();
            if (pkColumnNames.contains(attName)) continue;
            dialect.encodeColumnName(attName, sql);
            sql.append(" = ");
            if (Geometry.class.isAssignableFrom(attributes[i].getType().getBinding())) {
                try {
                    Geometry g = (Geometry)values[i];
                    int srid = this.getGeometrySRID(g, attributes[i]);
                    dialect.encodeGeometryValue(g, srid, sql);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                dialect.encodeValue(values[i], attributes[i].getType().getBinding(), sql);
            }
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ");
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                FilterToSQL toSQL = this.createFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        return sql.toString();
    }

    protected PreparedStatement updateSQLPS(SimpleFeatureType featureType, AttributeDescriptor[] attributes, Object[] values, Filter filter, Connection cx) throws IOException, SQLException {
        int i;
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)this.getSQLDialect();
        PrimaryKey key = null;
        try {
            key = this.getPrimaryKey(featureType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet<String> pkColumnNames = this.getColumnNames(key);
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        this.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" SET ");
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            AttributeDescriptor att = attributes[i2];
            String attName = att.getLocalName();
            if (pkColumnNames.contains(attName)) continue;
            dialect.encodeColumnName(attName, sql);
            sql.append(" = ");
            if (attributes[i2] instanceof GeometryDescriptor) {
                Geometry geometry = (Geometry)values[i2];
                Class binding = att.getType().getBinding();
                dialect.prepareGeometryValue(geometry, this.getDescriptorSRID(att), binding, sql);
            } else {
                sql.append("?");
            }
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ");
        PreparedFilterToSQL toSQL = null;
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            try {
                toSQL = this.createPreparedFilterToSQL(featureType);
                sql.append(" ").append(toSQL.encodeToString(filter));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        this.LOGGER.log(Level.FINE, "Updating features with prepared statement: {0}", sql);
        int j = 0;
        for (i = 0; i < attributes.length; ++i) {
            AttributeDescriptor att = attributes[i];
            String attName = att.getLocalName();
            if (pkColumnNames.contains(attName)) continue;
            Class binding = att.getType().getBinding();
            if (Geometry.class.isAssignableFrom(binding)) {
                Geometry g = (Geometry)values[i];
                dialect.setGeometryValue(g, this.getDescriptorSRID(att), binding, ps, j + 1);
            } else {
                dialect.setValue(values[i], binding, ps, j + 1, cx);
            }
            if (this.LOGGER.isLoggable(Level.FINE)) {
                this.LOGGER.fine(j + 1 + " = " + values[i]);
            }
            ++j;
        }
        if (toSQL != null) {
            this.setPreparedFilterValues(ps, toSQL, i, cx);
        }
        return ps;
    }

    protected FilterToSQL createFilterToSQL(SimpleFeatureType featureType) {
        return this.initializeFilterToSQL(((BasicSQLDialect)this.dialect).createFilterToSQL(), featureType);
    }

    protected PreparedFilterToSQL createPreparedFilterToSQL(SimpleFeatureType featureType) {
        return this.initializeFilterToSQL(((PreparedStatementSQLDialect)this.dialect).createPreparedFilterToSQL(), featureType);
    }

    protected <F extends FilterToSQL> F initializeFilterToSQL(F toSQL, SimpleFeatureType featureType) {
        toSQL.setSqlNameEscape(this.dialect.getNameEscape());
        if (featureType != null) {
            PrimaryKey key;
            try {
                key = this.getPrimaryKey(featureType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FIDMapper mapper = new FIDMapper(){

                @Override
                public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
                    return null;
                }

                @Override
                public int getColumnCount() {
                    return key.getColumns().size();
                }

                @Override
                public int getColumnDecimalDigits(int colIndex) {
                    return 0;
                }

                @Override
                public String getColumnName(int colIndex) {
                    return key.getColumns().get(colIndex).getName();
                }

                @Override
                public int getColumnSize(int colIndex) {
                    return 0;
                }

                @Override
                public int getColumnType(int colIndex) {
                    return 0;
                }

                @Override
                public String getID(Object[] attributes) {
                    return null;
                }

                @Override
                public Object[] getPKAttributes(String FID) throws IOException {
                    return JDBCDataStore.this.decodeFID(key, FID, false).toArray();
                }

                @Override
                public boolean hasAutoIncrementColumns() {
                    return false;
                }

                @Override
                public void initSupportStructures() {
                }

                @Override
                public boolean isAutoIncrement(int colIndex) {
                    return false;
                }

                @Override
                public boolean isVolatile() {
                    return false;
                }

                @Override
                public boolean returnFIDColumnsAsAttributes() {
                    return false;
                }

                @Override
                public boolean isValid(String fid) {
                    return true;
                }
            };
            toSQL.setFeatureType(featureType);
            toSQL.setPrimaryKey(key);
            toSQL.setFIDMapper(mapper);
            toSQL.setDatabaseSchema(this.databaseSchema);
        }
        return toSQL;
    }

    protected void encodeTableName(String tableName, StringBuffer sql, Hints hints) throws SQLException {
        VirtualTable vtDefinition = this.virtualTables.get(tableName);
        if (vtDefinition != null) {
            sql.append("(").append(vtDefinition.expandParameters(hints)).append(")");
            this.dialect.encodeTableAlias("vtable", sql);
        } else {
            if (this.databaseSchema != null) {
                this.dialect.encodeSchemaName(this.databaseSchema, sql);
                sql.append(".");
            }
            this.dialect.encodeTableName(tableName, sql);
        }
    }

    protected void encodeTableJoin(SimpleFeatureType featureType, JoinInfo join, Query query, StringBuffer sql) throws SQLException {
        this.encodeTableName(featureType.getTypeName(), sql, query.getHints());
        this.dialect.encodeTableAlias(join.getPrimaryAlias(), sql);
        for (JoinInfo.JoinPart part : join.getParts()) {
            sql.append(" ");
            this.dialect.encodeJoin(part.getJoin().getType(), sql);
            sql.append(" ");
            this.encodeTableName(part.getQueryFeatureType().getTypeName(), sql, null);
            this.dialect.encodeTableAlias(part.getAlias(), sql);
            sql.append(" ON ");
            Filter j = part.getJoinFilter();
            FilterToSQL toSQL = this.dialect instanceof PreparedStatementSQLDialect ? this.createPreparedFilterToSQL(null) : this.createFilterToSQL(null);
            toSQL.setInline(true);
            try {
                sql.append(" ").append(toSQL.encodeToString(j));
            }
            catch (FilterToSQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected List<FilterToSQL> encodeWhereJoin(SimpleFeatureType featureType, JoinInfo join, StringBuffer sql) throws IOException {
        ArrayList<FilterToSQL> toSQL = new ArrayList<FilterToSQL>();
        boolean whereEncoded = false;
        Filter filter = join.getFilter();
        if (filter != null && !Filter.INCLUDE.equals(filter)) {
            sql.append(" WHERE ");
            whereEncoded = true;
            toSQL.add(this.filter(featureType, filter, sql));
        }
        for (JoinInfo.JoinPart part : join.getParts()) {
            filter = part.getPreFilter();
            if (filter == null || Filter.INCLUDE.equals(filter)) continue;
            if (!whereEncoded) {
                sql.append(" WHERE ");
                whereEncoded = true;
            } else {
                sql.append(" AND ");
            }
            toSQL.add(this.filter(part.getQueryFeatureType(), filter, sql));
        }
        return toSQL;
    }

    protected void setGmlProperties(Geometry g, String gid, String name, String description) {
        Map<Object, Object> userData = null;
        if (g.getUserData() != null) {
            if (g.getUserData() instanceof Map) {
                userData = (Map)g.getUserData();
            } else {
                userData = new HashMap();
                userData.put(g.getUserData().getClass(), g.getUserData());
            }
        } else {
            userData = new HashMap<String, String>();
        }
        if (gid != null) {
            userData.put("gml:id", gid);
        }
        if (name != null) {
            userData.put("gml:name", name);
        }
        if (description != null) {
            userData.put("gml:description", description);
        }
        g.setUserData(userData);
    }

    void applyLimitOffset(StringBuffer sql, Query query) {
        if (this.checkLimitOffset(query)) {
            Integer offset = query.getStartIndex();
            int limit = query.getMaxFeatures();
            this.dialect.applyLimitOffset(sql, limit, offset != null ? offset : 0);
        }
    }

    boolean checkLimitOffset(Query query) {
        if (!this.dialect.isLimitOffsetSupported()) {
            return false;
        }
        Integer offset = query.getStartIndex();
        int limit = query.getMaxFeatures();
        return limit != Integer.MAX_VALUE || offset != null && offset > 0;
    }

    public void closeSafe(ResultSet rs) {
        block3: {
            if (rs == null) {
                return;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error occurred closing result set";
                this.LOGGER.warning(msg);
                if (!this.LOGGER.isLoggable(Level.FINER)) break block3;
                this.LOGGER.log(Level.FINER, msg, e);
            }
        }
    }

    public void closeSafe(Statement st) {
        block3: {
            if (st == null) {
                return;
            }
            try {
                st.close();
            }
            catch (SQLException e) {
                String msg = "Error occurred closing statement";
                this.LOGGER.warning(msg);
                if (!this.LOGGER.isLoggable(Level.FINER)) break block3;
                this.LOGGER.log(Level.FINER, msg, e);
            }
        }
    }

    public void closeSafe(Connection cx) {
        block3: {
            if (cx == null) {
                return;
            }
            try {
                cx.close();
                this.LOGGER.fine("CLOSE CONNECTION");
            }
            catch (SQLException e) {
                String msg = "Error occurred closing connection";
                this.LOGGER.warning(msg);
                if (!this.LOGGER.isLoggable(Level.FINER)) break block3;
                this.LOGGER.log(Level.FINER, msg, e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.dataSource != null) {
            this.LOGGER.severe("There's code using JDBC based datastore and not disposing them. This may lead to temporary loss of database connections. Please make sure all data access code calls DataStore.dispose() before freeing all references to it");
            this.dispose();
        }
    }

    public void dispose() {
        if (this.dataSource != null && this.dataSource instanceof ManageableDataSource) {
            try {
                ManageableDataSource mds = (ManageableDataSource)this.dataSource;
                mds.close();
            }
            catch (SQLException e) {
                this.LOGGER.log(Level.FINE, "Could not close dataSource", e);
            }
        }
        this.dataSource = null;
    }

    protected boolean isGeneralizationRequired(Hints hints, GeometryDescriptor gatt) {
        return this.isGeometryReduceRequired(hints, gatt, Hints.GEOMETRY_GENERALIZATION);
    }

    protected boolean isSimplificationRequired(Hints hints, GeometryDescriptor gatt) {
        return this.isGeometryReduceRequired(hints, gatt, Hints.GEOMETRY_SIMPLIFICATION);
    }

    protected boolean isGeometryReduceRequired(Hints hints, GeometryDescriptor gatt, Hints.Key param) {
        if (hints == null) {
            return false;
        }
        if (!hints.containsKey((Object)param)) {
            return false;
        }
        return gatt.getType().getBinding() != Point.class;
    }

    protected void encodeGeometryColumn(GeometryDescriptor gatt, StringBuffer sql, Hints hints) {
        this.encodeGeometryColumn(gatt, null, sql, hints);
    }

    protected void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, StringBuffer sql, Hints hints) {
        int srid = this.getDescriptorSRID((AttributeDescriptor)gatt);
        if (this.isGeneralizationRequired(hints, gatt)) {
            Double distance = (Double)hints.get((Object)Hints.GEOMETRY_GENERALIZATION);
            this.dialect.encodeGeometryColumnGeneralized(gatt, prefix, srid, sql, distance);
            return;
        }
        if (this.isSimplificationRequired(hints, gatt)) {
            Double distance = (Double)hints.get((Object)Hints.GEOMETRY_SIMPLIFICATION);
            this.dialect.encodeGeometryColumnSimplified(gatt, prefix, srid, sql, distance);
            return;
        }
        this.dialect.encodeGeometryColumn(gatt, prefix, srid, hints, sql);
    }

    public Transaction buildTransaction(Connection cx) {
        DefaultTransaction tx = new DefaultTransaction();
        JDBCTransactionState state = new JDBCTransactionState(cx, this, true);
        tx.putState((Object)this, (Transaction.State)state);
        return tx;
    }
}

