/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.jdbc.JoinPropertyName;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.parameter.Parameter;
import org.opengis.temporal.Period;

public class FilterToSQL
implements FilterVisitor,
ExpressionVisitor {
    protected static final String IO_ERROR = "io problem writing filter";
    protected static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    protected FilterCapabilities capabilities = null;
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private String sqlNameEscape = "";
    protected Writer out;
    protected FIDMapper mapper;
    protected PrimaryKey primaryKey;
    protected String databaseSchema;
    protected SimpleFeatureType featureType;
    protected boolean encodingFunction = false;
    protected GeometryDescriptor currentGeometry;
    protected Integer currentSRID;
    protected boolean inline = false;
    protected FieldEncoder fieldEncoder = DefaultFieldEncoder.DEFAULT_FIELD_ENCODER;

    public FilterToSQL() {
    }

    public FilterToSQL(Writer out) {
        this.out = out;
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void encode(Filter filter) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        if (this.getCapabilities().fullySupports(filter)) {
            try {
                if (!this.inline) {
                    this.out.write("WHERE ");
                }
                filter.accept((FilterVisitor)this, null);
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
                throw new FilterToSQLException("Problem writing filter: ", ioe);
            }
        } else {
            throw new FilterToSQLException("Filter type not supported");
        }
    }

    public String encodeToString(Filter filter) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(filter);
        return out.getBuffer().toString();
    }

    public void encode(Expression expression) throws FilterToSQLException {
        if (this.out == null) {
            throw new FilterToSQLException("Can't encode to a null writer.");
        }
        expression.accept((ExpressionVisitor)this, null);
    }

    public String encodeToString(Expression expression) throws FilterToSQLException {
        StringWriter out = new StringWriter();
        this.out = out;
        this.encode(expression);
        return out.getBuffer().toString();
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public void setFIDMapper(FIDMapper mapper) {
        this.mapper = mapper;
    }

    public FIDMapper getFIDMapper() {
        return this.mapper;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(Id.class);
        capabilities.addType(IncludeFilter.class);
        capabilities.addType(ExcludeFilter.class);
        capabilities.addType(After.class);
        capabilities.addType(Before.class);
        capabilities.addType(Begins.class);
        capabilities.addType(BegunBy.class);
        capabilities.addType(During.class);
        capabilities.addType(Ends.class);
        capabilities.addType(EndedBy.class);
        capabilities.addType(TContains.class);
        capabilities.addType(TEquals.class);
        return capabilities;
    }

    public final synchronized FilterCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.createFilterCapabilities();
        }
        return this.capabilities;
    }

    public void setCapabilities(FilterCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        try {
            this.out.write("0 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        try {
            this.out.write("1 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Expression lowerbounds = filter.getLowerBoundary();
        Expression upperbounds = filter.getUpperBoundary();
        AttributeDescriptor attType = (AttributeDescriptor)expr.evaluate((Object)this.featureType);
        Class context = attType != null ? attType.getType().getBinding() : String.class;
        try {
            expr.accept((ExpressionVisitor)this, extraData);
            this.out.write(" BETWEEN ");
            lowerbounds.accept((ExpressionVisitor)this, (Object)context);
            this.out.write(" AND ");
            upperbounds.accept((ExpressionVisitor)this, (Object)context);
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        char esc = filter.getEscape().charAt(0);
        char multi = filter.getWildCard().charAt(0);
        char single = filter.getSingleChar().charAt(0);
        boolean matchCase = filter.isMatchingCase();
        String literal = filter.getLiteral();
        Expression att = filter.getExpression();
        AttributeDescriptor ad = (AttributeDescriptor)att.evaluate((Object)this.featureType);
        if (ad != null && Date.class.isAssignableFrom(ad.getType().getBinding())) {
            literal = literal + multi;
        }
        String pattern = LikeFilterImpl.convertToSQL92((char)esc, (char)multi, (char)single, (boolean)matchCase, (String)literal);
        try {
            if (!matchCase) {
                this.out.write(" UPPER(");
            }
            att.accept((ExpressionVisitor)this, extraData);
            if (!matchCase) {
                this.out.write(") LIKE '");
            } else {
                this.out.write(" LIKE '");
            }
            this.out.write(pattern);
            this.out.write("' ");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(And filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"AND");
    }

    public Object visit(Not filter, Object extraData) {
        try {
            this.out.write("NOT (");
            filter.getFilter().accept((FilterVisitor)this, extraData);
            this.out.write(")");
            return extraData;
        }
        catch (IOException e) {
            throw new RuntimeException(IO_ERROR, e);
        }
    }

    public Object visit(Or filter, Object extraData) {
        return this.visit((BinaryLogicOperator)filter, (Object)"OR");
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        LOGGER.finer("exporting LogicFilter");
        String type = (String)extraData;
        try {
            Iterator list = filter.getChildren().iterator();
            this.out.write("(");
            while (list.hasNext()) {
                ((Filter)list.next()).accept((FilterVisitor)this, extraData);
                if (!list.hasNext()) continue;
                this.out.write(" " + type + " ");
            }
            this.out.write(")");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">=");
        return extraData;
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, ">");
        return extraData;
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<");
        return extraData;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "<=");
        return extraData;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, "!=");
        return extraData;
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        Class ret;
        AttributeDescriptor attType;
        LOGGER.finer("exporting SQL ComparisonFilter");
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class leftContext = null;
        Class rightContext = null;
        if (left instanceof PropertyName) {
            attType = (AttributeDescriptor)left.evaluate((Object)this.featureType);
            if (attType != null) {
                rightContext = attType.getType().getBinding();
            }
        } else if (left instanceof Function && (ret = this.getFunctionReturnType((Function)left)) != null) {
            rightContext = ret;
        }
        if (right instanceof PropertyName) {
            attType = (AttributeDescriptor)right.evaluate((Object)this.featureType);
            if (attType != null) {
                leftContext = attType.getType().getBinding();
            }
        } else if (right instanceof Function && (ret = this.getFunctionReturnType((Function)right)) != null) {
            leftContext = ret;
        }
        boolean matchCase = true;
        if (!filter.isMatchingCase() && (filter instanceof PropertyIsEqualTo || filter instanceof PropertyIsNotEqualTo) && (String.class.equals((Object)leftContext) || String.class.equals((Object)rightContext))) {
            matchCase = false;
        }
        String type = (String)extraData;
        try {
            if (matchCase) {
                if (leftContext != null && this.isBinaryExpression(left)) {
                    this.writeBinaryExpression(left, leftContext);
                } else {
                    left.accept((ExpressionVisitor)this, (Object)leftContext);
                }
                this.out.write(" " + type + " ");
                if (rightContext != null && this.isBinaryExpression(right)) {
                    this.writeBinaryExpression(right, rightContext);
                } else {
                    right.accept((ExpressionVisitor)this, (Object)rightContext);
                }
            } else {
                FunctionImpl f = new FunctionImpl(){
                    {
                        this.functionName = new FunctionNameImpl("lower", FunctionNameImpl.parameter((String)"lowercase", String.class), new Parameter[]{FunctionNameImpl.parameter((String)"string", String.class)});
                    }
                };
                f.setName("lower");
                f.setParameters(Arrays.asList(left));
                f.accept((ExpressionVisitor)this, Arrays.asList(leftContext));
                this.out.write(" " + type + " ");
                f.setParameters(Arrays.asList(right));
                f.accept((ExpressionVisitor)this, Arrays.asList(rightContext));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBinaryExpression(Expression e, Class context) throws IOException {
        Writer tmp = this.out;
        try {
            this.out = new StringWriter();
            this.out.write("(");
            e.accept((ExpressionVisitor)this, null);
            this.out.write(")");
            tmp.write(this.cast(this.out.toString(), context));
        }
        finally {
            this.out = tmp;
        }
    }

    Class getFunctionReturnType(Function f) {
        Class clazz = Object.class;
        if (f.getFunctionName() != null && f.getFunctionName().getReturn() != null) {
            clazz = f.getFunctionName().getReturn().getType();
        }
        if (clazz == Object.class) {
            clazz = null;
        }
        return clazz;
    }

    boolean isBinaryExpression(Expression e) {
        return e instanceof BinaryExpression;
    }

    public Object visit(PropertyIsNull filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting NullFilter");
        Expression expr = filter.getExpression();
        try {
            expr.accept((ExpressionVisitor)this, extraData);
            this.out.write(" IS NULL ");
        }
        catch (IOException ioe) {
            throw new RuntimeException(IO_ERROR, ioe);
        }
        return extraData;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("isNil not supported");
    }

    public Object visit(Id filter, Object extraData) {
        if (this.mapper == null) {
            throw new RuntimeException("Must set a fid mapper before trying to encode FIDFilters");
        }
        Set ids = filter.getIdentifiers();
        LOGGER.finer("Exporting FID=" + ids);
        String[] colNames = new String[this.mapper.getColumnCount()];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = this.mapper.getColumnName(i);
        }
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            try {
                Identifier id = (Identifier)i.next();
                Object[] attValues = this.mapper.getPKAttributes(id.toString());
                this.out.write("(");
                for (int j = 0; j < attValues.length; ++j) {
                    this.out.write(this.escapeName(colNames[j]));
                    this.out.write(" = '");
                    this.out.write(attValues[j].toString());
                    this.out.write("'");
                    if (j >= attValues.length - 1) continue;
                    this.out.write(" AND ");
                }
                this.out.write(")");
                if (!i.hasNext()) continue;
                this.out.write(" OR ");
            }
            catch (IOException e) {
                throw new RuntimeException(IO_ERROR, e);
            }
        }
        return extraData;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        if (filter == null) {
            throw new NullPointerException("Filter to be encoded cannot be null");
        }
        if (!(filter instanceof BinaryComparisonOperator)) {
            throw new IllegalArgumentException("This filter is not a binary comparison, can't do SDO relate against it: " + filter.getClass());
        }
        BinaryComparisonOperator op = (BinaryComparisonOperator)filter;
        Expression e1 = op.getExpression1();
        Expression e2 = op.getExpression2();
        if (e1 instanceof Literal && e2 instanceof PropertyName) {
            e1 = (PropertyName)op.getExpression2();
            e2 = (Literal)op.getExpression1();
        }
        if (e1 instanceof PropertyName) {
            AttributeDescriptor descriptor;
            this.currentGeometry = null;
            this.currentSRID = null;
            if (this.featureType != null && (descriptor = (AttributeDescriptor)e1.evaluate((Object)this.featureType)) instanceof GeometryDescriptor) {
                this.currentGeometry = (GeometryDescriptor)descriptor;
                this.currentSRID = (Integer)descriptor.getUserData().get("nativeSRID");
            }
        }
        if (e1 instanceof PropertyName && e2 instanceof Literal) {
            return this.visitBinarySpatialOperator(filter, (PropertyName)e1, (Literal)e2, filter.getExpression1() instanceof Literal, extraData);
        }
        return this.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    protected Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, Object extraData) {
        if (filter == null) {
            throw new NullPointerException("Null filter");
        }
        Expression e1 = filter.getExpression1();
        Expression e2 = filter.getExpression2();
        if (e1 instanceof Literal && e2 instanceof PropertyName) {
            e1 = (PropertyName)filter.getExpression2();
            e2 = (Literal)filter.getExpression1();
        }
        if (e1 instanceof PropertyName && e2 instanceof Literal) {
            return this.visitBinaryTemporalOperator(filter, (PropertyName)e1, (Literal)e2, filter.getExpression1() instanceof Literal, extraData);
        }
        return this.visitBinaryTemporalOperator(filter, e1, e2, extraData);
    }

    protected Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, PropertyName property, Literal temporal, boolean swapped, Object extraData) {
        Class typeContext = null;
        AttributeDescriptor attType = (AttributeDescriptor)property.evaluate((Object)this.featureType);
        if (attType != null) {
            typeContext = attType.getType().getBinding();
        }
        Period period = null;
        if (temporal.evaluate(null) instanceof Period) {
            period = (Period)temporal.evaluate(null);
        }
        if ((filter instanceof Begins || filter instanceof BegunBy || filter instanceof Ends || filter instanceof EndedBy || filter instanceof During || filter instanceof TContains) && period == null && period == null) {
            throw new IllegalArgumentException("Filter requires a time period");
        }
        if (filter instanceof TEquals && period != null) {
            throw new IllegalArgumentException("TEquals filter does not accept time period");
        }
        if ((filter instanceof Begins || filter instanceof Ends || filter instanceof During) && swapped) {
            throw new IllegalArgumentException("Time period must be second argument of Filter");
        }
        if ((filter instanceof BegunBy || filter instanceof EndedBy || filter instanceof TContains) && !swapped) {
            throw new IllegalArgumentException("Time period must be first argument of Filter");
        }
        try {
            if (filter instanceof After || filter instanceof Before) {
                String inv;
                String op = filter instanceof After ? " > " : " < ";
                String string = inv = filter instanceof After ? " < " : " > ";
                if (period != null) {
                    this.out.write("(");
                    property.accept((ExpressionVisitor)this, extraData);
                    this.out.write(swapped ? inv : op);
                    this.visitBegin(period, extraData);
                    this.out.write(" AND ");
                    property.accept((ExpressionVisitor)this, extraData);
                    this.out.write(swapped ? inv : op);
                    this.visitEnd(period, extraData);
                    this.out.write(")");
                } else {
                    if (swapped) {
                        temporal.accept((ExpressionVisitor)this, (Object)typeContext);
                    } else {
                        property.accept((ExpressionVisitor)this, extraData);
                    }
                    this.out.write(op);
                    if (swapped) {
                        property.accept((ExpressionVisitor)this, extraData);
                    } else {
                        temporal.accept((ExpressionVisitor)this, (Object)typeContext);
                    }
                }
            } else if (filter instanceof Begins || filter instanceof Ends || filter instanceof BegunBy || filter instanceof EndedBy) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(" = ");
                if (filter instanceof Begins || filter instanceof BegunBy) {
                    this.visitBegin(period, extraData);
                } else {
                    this.visitEnd(period, extraData);
                }
            } else if (filter instanceof During || filter instanceof TContains) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(" BETWEEN ");
                this.visitBegin(period, extraData);
                this.out.write(" AND ");
                this.visitEnd(period, extraData);
            } else if (filter instanceof TEquals) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(" = ");
                temporal.accept((ExpressionVisitor)this, (Object)typeContext);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding temporal filter", e);
        }
        return extraData;
    }

    void visitBegin(Period p, Object extraData) {
        filterFactory.literal((Object)p.getBeginning().getPosition().getDate()).accept((ExpressionVisitor)this, extraData);
    }

    void visitEnd(Period p, Object extraData) {
        filterFactory.literal((Object)p.getEnding().getPosition().getDate()).accept((ExpressionVisitor)this, extraData);
    }

    protected Object visitBinaryTemporalOperator(BinaryTemporalOperator filter, Expression e1, Expression e2, Object extraData) {
        if (!(filter instanceof After || filter instanceof Before || filter instanceof TEquals)) {
            throw new IllegalArgumentException("Unsupported filter: " + filter + ". Only After,Before,TEquals supported");
        }
        String op = filter instanceof After ? ">" : (filter instanceof Before ? "<" : "=");
        try {
            e1.accept((ExpressionVisitor)this, extraData);
            this.out.write(" " + op + " ");
            e2.accept((ExpressionVisitor)this, extraData);
        }
        catch (IOException e) {
            return new RuntimeException("Error encoding temporal filter", e);
        }
        return extraData;
    }

    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    public Object visit(PropertyName expression, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyName");
        Class target = null;
        if (extraData instanceof Class) {
            target = (Class)extraData;
        }
        try {
            String encodedField;
            SimpleFeatureType featureType = this.featureType;
            if (expression instanceof JoinPropertyName) {
                this.out.write(this.escapeName(((JoinPropertyName)expression).getAlias()));
                this.out.write(".");
            }
            AttributeDescriptor attribute = null;
            try {
                attribute = (AttributeDescriptor)expression.evaluate((Object)featureType);
            }
            catch (Exception e) {
                String msg = "Error occured mapping " + expression + " to feature type";
                LOGGER.log(Level.WARNING, msg, e);
            }
            if (attribute != null) {
                encodedField = this.fieldEncoder.encode(this.escapeName(attribute.getLocalName()));
                if (target != null && target.isAssignableFrom(attribute.getType().getBinding())) {
                    target = null;
                }
            } else {
                encodedField = this.fieldEncoder.encode(this.escapeName(expression.getPropertyName()));
            }
            if (target != null) {
                this.out.write(this.cast(encodedField, target));
            } else {
                this.out.write(encodedField);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing attribute exp", ioe);
        }
        return extraData;
    }

    protected String cast(String encodedProperty, Class target) throws IOException {
        return encodedProperty;
    }

    public Object visit(Literal expression, Object context) throws RuntimeException {
        LOGGER.finer("exporting LiteralExpression");
        Class target = null;
        if (context instanceof Class) {
            target = (Class)context;
        }
        try {
            Object literal = this.evaluateLiteral(expression, target);
            if (literal instanceof Geometry) {
                this.visitLiteralGeometry(filterFactory.literal(literal));
            } else {
                this.writeLiteral(literal);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO problems writing literal", e);
        }
        return context;
    }

    protected Object evaluateLiteral(Literal expression, Class target) {
        Number number;
        Object literal = null;
        if (target != null) {
            literal = Number.class.isAssignableFrom(target) ? this.safeConvertToNumber((Expression)expression, target) : expression.evaluate(null, target);
        }
        if (target == null && (number = this.safeConvertToNumber((Expression)expression, Number.class)) != null) {
            literal = number;
        }
        if (literal == null) {
            literal = expression.evaluate(null);
        }
        if (literal == null) {
            literal = expression.getValue();
        }
        return literal;
    }

    Number safeConvertToNumber(Expression expression, Class target) {
        return (Number)Converters.convert((Object)expression.evaluate(null), (Class)target, (Hints)new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true));
    }

    protected void writeLiteral(Object literal) throws IOException {
        if (literal == null) {
            this.out.write("NULL");
        } else if (literal instanceof Number || literal instanceof Boolean) {
            this.out.write(String.valueOf(literal));
        } else {
            String encoding = (String)Converters.convert((Object)literal, String.class, null);
            if (encoding == null) {
                encoding = literal.toString();
            }
            String escaped = encoding.replaceAll("'", "''");
            this.out.write("'" + escaped + "'");
        }
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        throw new RuntimeException("Subclasses must implement this method in order to handle geometries");
    }

    protected void visitLiteralTimePeriod(Period expression) {
        throw new RuntimeException("Time periods not supported, subclasses must implement this method to support encoding timeperiods");
    }

    public Object visit(Add expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "+", extraData);
    }

    public Object visit(Divide expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "/", extraData);
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "*", extraData);
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.visit((BinaryExpression)expression, "-", extraData);
    }

    protected Object visit(BinaryExpression expression, String operator, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting Expression Math");
        try {
            expression.getExpression1().accept((ExpressionVisitor)this, extraData);
            this.out.write(" " + operator + " ");
            expression.getExpression2().accept((ExpressionVisitor)this, extraData);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
        return extraData;
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        try {
            List parameters = function.getParameters();
            List contexts = null;
            if (extraData instanceof List && ((List)extraData).size() == parameters.size()) {
                contexts = (List)extraData;
            }
            this.encodingFunction = true;
            this.out.write(this.getFunctionName(function));
            this.out.write("(");
            for (int i = 0; i < parameters.size(); ++i) {
                Expression e = (Expression)parameters.get(i);
                Class context = ((Parameter)function.getFunctionName().getArguments().get(i)).getType();
                e.accept((ExpressionVisitor)this, (Object)context);
                if (i >= parameters.size() - 1) continue;
                this.out.write(",");
            }
            this.out.write(")");
            this.encodingFunction = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    protected Expression getParameter(Function function, int idx, boolean mandatory) {
        List params = function.getParameters();
        if (params == null || params.size() <= idx) {
            if (mandatory) {
                throw new IllegalArgumentException("Missing parameter number " + (idx + 1) + " for function " + function.getName() + ", cannot encode in SQL");
            }
            return null;
        }
        return (Expression)params.get(idx);
    }

    protected String getFunctionName(Function function) {
        return function.getName();
    }

    public Object visit(NilExpression expression, Object extraData) {
        try {
            this.out.write(" ");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing expression", ioe);
        }
        return extraData;
    }

    public Object visit(After after, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)after, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)anyInteracts, extraData);
    }

    public Object visit(Before before, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)begunBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)during, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)endedBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)ends, extraData);
    }

    public Object visit(Meets meets, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)meets, extraData);
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)metBy, extraData);
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)overlappedBy, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)equals, extraData);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.visitBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData);
    }

    public void setSqlNameEscape(String escape) {
        this.sqlNameEscape = escape;
    }

    public String escapeName(String name) {
        return this.sqlNameEscape + name + this.sqlNameEscape;
    }

    public void setFieldEncoder(FieldEncoder fieldEncoder) {
        this.fieldEncoder = fieldEncoder;
    }

    private static class DefaultFieldEncoder
    implements FieldEncoder {
        public static DefaultFieldEncoder DEFAULT_FIELD_ENCODER = new DefaultFieldEncoder();

        private DefaultFieldEncoder() {
        }

        @Override
        public String encode(String s) {
            return s;
        }
    }

    public static interface FieldEncoder {
        public String encode(String var1);
    }
}

