/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.LineString;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStoreAPITestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.RegexpValidator;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public abstract class JDBCVirtualTableTest
extends JDBCTestSupport {
    protected String dbSchemaName = null;

    @Override
    protected abstract JDBCDataStoreAPITestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        VirtualTable vt = new VirtualTable("riverFull", sb.toString());
        this.dataStore.addVirtualTable(vt);
        sb = new StringBuffer();
        sb.append("select ");
        this.dialect.encodeColumnName(this.aname("id"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(this.aname("geom"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(this.aname("river"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(this.aname("flow"), sb);
        sb.append(" * 2 as ");
        this.dialect.encodeColumnName(this.aname("doubleFlow"), sb);
        sb.append(" from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        sb.append(" where ");
        this.dialect.encodeColumnName(this.aname("flow"), sb);
        sb.append(" > 4");
        vt = new VirtualTable("riverReduced", sb.toString());
        vt.addGeometryMetadatata("geom", LineString.class, 4326);
        this.dataStore.addVirtualTable(vt);
        vt = new VirtualTable("riverReducedPk", sb.toString());
        vt.addGeometryMetadatata("geom", LineString.class, 4326);
        vt.setPrimaryKeyColumns(Arrays.asList(this.aname("id")));
        this.dataStore.addVirtualTable(vt);
        sb = new StringBuffer();
        sb.append("select ");
        this.dialect.encodeColumnName(this.aname("id"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName(this.aname("geom"), sb);
        sb.append(", ");
        this.dialect.encodeColumnName("flow", sb);
        sb.append(" * %mul% as ");
        this.dialect.encodeColumnName("mulflow", sb);
        sb.append(" from ");
        if (this.dbSchemaName != null) {
            this.dialect.encodeSchemaName(this.dbSchemaName, sb);
            sb.append(".");
        }
        this.dialect.encodeTableName(this.tname("river"), sb);
        sb.append(" %where%");
        vt = new VirtualTable("riverParam", sb.toString());
        vt.addGeometryMetadatata("geom", LineString.class, 4326);
        vt.addParameter(new VirtualTableParameter("mul", "1", (VirtualTableParameter.Validator)new RegexpValidator("[\\d\\.e\\+-]+")));
        vt.addParameter(new VirtualTableParameter("where", ""));
        this.dataStore.addVirtualTable(vt);
    }

    public void testGuessGeometry() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema("riverFull");
        JDBCVirtualTableTest.assertNotNull((Object)type);
        JDBCVirtualTableTest.assertNotNull((Object)type.getGeometryDescriptor());
    }

    public void testRiverReducedSchema() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema("riverReduced");
        JDBCVirtualTableTest.assertNotNull((Object)type);
        JDBCVirtualTableTest.assertEquals((int)4, (int)type.getAttributeCount());
        AttributeDescriptor id = type.getDescriptor(this.aname("id"));
        JDBCVirtualTableTest.assertTrue((boolean)Number.class.isAssignableFrom(id.getType().getBinding()));
        GeometryDescriptor geom = type.getGeometryDescriptor();
        JDBCVirtualTableTest.assertEquals((String)this.aname("geom"), (String)geom.getLocalName());
        AttributeDescriptor river = type.getDescriptor(this.aname("river"));
        JDBCVirtualTableTest.assertEquals(String.class, (Object)river.getType().getBinding());
        AttributeDescriptor doubleFlow = type.getDescriptor(this.aname("doubleFlow"));
        JDBCVirtualTableTest.assertTrue((boolean)Number.class.isAssignableFrom(doubleFlow.getType().getBinding()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testListAll() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReduced");
        JDBCVirtualTableTest.assertFalse((boolean)(fsView instanceof FeatureStore));
        JDBCVirtualTableTest.assertEquals((int)1, (int)fsView.getCount(Query.ALL));
        FeatureIterator it = null;
        try {
            it = fsView.getFeatures().features();
            JDBCVirtualTableTest.assertTrue((boolean)it.hasNext());
            SimpleFeature sf = (SimpleFeature)it.next();
            JDBCVirtualTableTest.assertEquals((Object)"rv1", (Object)sf.getAttribute(this.aname("river")));
            JDBCVirtualTableTest.assertEquals((double)9.0, (double)((Number)sf.getAttribute(this.aname("doubleFlow"))).doubleValue(), (double)0.1);
            JDBCVirtualTableTest.assertFalse((boolean)it.hasNext());
        }
        finally {
            it.close();
        }
    }

    public void testBounds() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReduced");
        ReferencedEnvelope env = fsView.getBounds();
        JDBCVirtualTableTest.assertNotNull((Object)env);
    }

    public void testInvalidQuery() throws Exception {
        String sql = ((VirtualTable)this.dataStore.getVirtualTables().get("riverReduced")).getSql();
        VirtualTable vt = new VirtualTable("riverPolluted", "SOME EXTRA GARBAGE " + sql);
        vt.addGeometryMetadatata("geom", LineString.class, -1);
        try {
            this.dataStore.addVirtualTable(vt);
            JDBCVirtualTableTest.fail((String)"Should have failed with invalid sql definition");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeatureId() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReducedPk");
        JDBCVirtualTableTest.assertFalse((boolean)(fsView instanceof FeatureStore));
        JDBCVirtualTableTest.assertEquals((int)1, (int)fsView.getCount(Query.ALL));
        FeatureIterator it = null;
        try {
            it = fsView.getFeatures().features();
            JDBCVirtualTableTest.assertTrue((boolean)it.hasNext());
            SimpleFeature sf = (SimpleFeature)it.next();
            JDBCVirtualTableTest.assertEquals((String)"riverReducedPk.0", (String)sf.getID());
        }
        finally {
            it.close();
        }
    }

    public void testGetFeatureById() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverReducedPk");
        JDBCVirtualTableTest.assertFalse((boolean)(fsView instanceof FeatureStore));
        PrimaryKey pk = this.dataStore.getPrimaryKey((SimpleFeatureType)fsView.getSchema());
        JDBCVirtualTableTest.assertEquals((String)"riverReducedPk", (String)pk.getTableName());
        JDBCVirtualTableTest.assertEquals((int)1, (int)pk.getColumns().size());
        PrimaryKeyColumn col = (PrimaryKeyColumn)pk.getColumns().get(0);
        JDBCVirtualTableTest.assertEquals((String)this.aname("id"), (String)col.getName());
        JDBCVirtualTableTest.assertTrue((boolean)Number.class.isAssignableFrom(col.getType()));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Id filter = ff.id(Collections.singleton(ff.featureId("riverReducedPk.0")));
        JDBCVirtualTableTest.assertEquals((int)1, (int)fsView.getCount(new Query(null, (Filter)filter)));
    }

    public void testWhereParam() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverParam");
        JDBCVirtualTableTest.assertEquals((int)2, (int)fsView.getCount(Query.ALL));
        Query q = new Query(Query.ALL);
        StringBuffer sb = new StringBuffer();
        sb.append(" where ");
        this.dialect.encodeColumnName(this.aname("flow"), sb);
        sb.append(" > 4");
        q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("where", sb.toString())));
        JDBCVirtualTableTest.assertEquals((int)1, (int)fsView.getCount(q));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMulParamValid() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverParam");
        Query q = new Query(Query.ALL);
        q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("mul", "10")));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("mulflow"), SortOrder.ASCENDING)});
        FeatureIterator fi = null;
        try {
            fi = fsView.getFeatures(q).features();
            JDBCVirtualTableTest.assertTrue((boolean)fi.hasNext());
            SimpleFeature f = (SimpleFeature)fi.next();
            JDBCVirtualTableTest.assertEquals((double)30.0, (double)((Number)f.getAttribute(this.aname("mulflow"))).doubleValue(), (double)0.1);
            JDBCVirtualTableTest.assertTrue((boolean)fi.hasNext());
            f = (SimpleFeature)fi.next();
            JDBCVirtualTableTest.assertEquals((double)45.0, (double)((Number)f.getAttribute(this.aname("mulflow"))).doubleValue(), (double)0.1);
        }
        finally {
            fi.close();
        }
    }

    public void testMulParamInvalid() throws Exception {
        ContentFeatureSource fsView = this.dataStore.getFeatureSource("riverParam");
        Query q = new Query(Query.ALL);
        q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("mul", "abc")));
        try {
            fsView.getFeatures(q).features();
            JDBCVirtualTableTest.fail((String)"Should have thrown an exception!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

