/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Polygon;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCViewTestSetup;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBCViewTest
extends JDBCTestSupport {
    protected static final String LAKESVIEW = "lakesview";
    protected static final String LAKESVIEWPK = "lakesviewpk";
    protected static final String FID = "fid";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType lakeViewSchema;
    protected SimpleFeatureType lakeViewPkSchema;

    @Override
    protected abstract JDBCViewTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.setMinOccurs(this.isPkNillable() ? 0 : 1);
        atb.setMaxOccurs(1);
        atb.setNillable(this.isPkNillable());
        atb.setName(FID);
        atb.setBinding(Integer.class);
        AttributeDescriptor fidDescriptor = atb.buildDescriptor(FID);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI(this.dataStore.getNamespaceURI());
        tb.setName(LAKESVIEW);
        tb.add(fidDescriptor);
        tb.add(ID, Integer.class);
        tb.add(GEOM, Polygon.class, (CoordinateReferenceSystem)null);
        tb.add(NAME, String.class);
        this.lakeViewSchema = tb.buildFeatureType();
        this.lakeViewPkSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.lakeViewSchema, (String[])new String[]{ID, GEOM, NAME});
    }

    protected boolean isPkNillable() {
        return true;
    }

    protected boolean supportsPkOnViews() {
        return false;
    }

    public void testSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(LAKESVIEW));
        this.assertFeatureTypesEqual(this.lakeViewSchema, ft);
    }

    public void testSchemaPk() throws Exception {
        if (!this.supportsPkOnViews()) {
            return;
        }
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(LAKESVIEWPK));
        this.assertFeatureTypesEqual(this.lakeViewPkSchema, ft);
    }

    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(LAKESVIEW)).getFeatures();
        JDBCViewTest.assertEquals((int)1, (int)fc.size());
        SimpleFeatureIterator fr = fc.features();
        JDBCViewTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBCViewTest.assertFalse((boolean)fr.hasNext());
        fr.close();
    }

    public void testGetBounds() throws Exception {
        ReferencedEnvelope reference = this.dataStore.getFeatureSource(this.tname(LAKESVIEW)).getBounds();
        JDBCViewTest.assertEquals((Object)12.0, (Object)reference.getMinX());
        JDBCViewTest.assertEquals((Object)16.0, (Object)reference.getMaxX());
        JDBCViewTest.assertEquals((Object)4.0, (Object)reference.getMinY());
        JDBCViewTest.assertEquals((Object)8.0, (Object)reference.getMaxY());
    }

    public void testReadOnly() throws Exception {
        try {
            this.dataStore.getFeatureWriter(this.tname(LAKESVIEW), Transaction.AUTO_COMMIT);
            JDBCViewTest.fail((String)"Should not be able to pick a writer without a pk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDBCViewTest.assertFalse((boolean)(this.dataStore.getFeatureSource(this.tname(LAKESVIEW)) instanceof FeatureStore));
    }
}

