/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.HashSet;
import java.util.UUID;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCUuidTestSetup;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCUuidTest
extends JDBCTestSupport {
    protected UUID uuid1 = UUID.fromString("c563f527-507e-4b80-a30b-4cab189d4dba");
    protected UUID uuid2 = UUID.fromString("cae47178-2e84-4319-a5ba-8d4089c9d80d");
    protected UUID uuid3 = UUID.fromString("34362328-9842-2385-8926-000000000003");

    @Override
    protected abstract JDBCUuidTestSetup createTestSetup();

    public void testGetSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname("guid"));
        JDBCUuidTest.assertEquals(UUID.class, (Object)ft.getDescriptor(this.aname("uuidProperty")).getType().getBinding());
    }

    public void testGetFeatures() throws Exception {
        FeatureReader r = this.dataStore.getFeatureReader(new Query(this.tname("guid")), Transaction.AUTO_COMMIT);
        r.hasNext();
        HashSet<UUID> uuids = new HashSet<UUID>();
        uuids.add(this.uuid1);
        uuids.add(this.uuid2);
        while (r.hasNext()) {
            SimpleFeature f = (SimpleFeature)r.next();
            JDBCUuidTest.assertNotNull((Object)uuids.remove(f.getAttribute(this.aname("uuidProperty"))));
        }
        JDBCUuidTest.assertTrue((boolean)uuids.isEmpty());
        r.close();
    }

    public void testInsertFeatures() throws Exception {
        DefaultTransaction transaction = new DefaultTransaction();
        SimpleFeatureStore featureStore = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("guid"));
        featureStore.setTransaction((Transaction)transaction);
        JDBCUuidTest.assertEquals((int)featureStore.getCount(Query.ALL), (int)2);
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("guid"));
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{this.uuid3}, (String)"guid.3");
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature)feature);
        featureStore.addFeatures((FeatureCollection)collection);
        transaction.commit();
        JDBCUuidTest.assertEquals((int)featureStore.getCount(Query.ALL), (int)3);
        transaction.close();
    }

    public void testModifyFeatures() throws Exception {
        FeatureWriter w = this.dataStore.getFeatureWriter(this.tname("guid"), Transaction.AUTO_COMMIT);
        w.hasNext();
        SimpleFeature f = (SimpleFeature)w.next();
        f.setAttribute(this.aname("uuidProperty"), (Object)this.uuid2);
        JDBCUuidTest.assertEquals((Object)this.uuid2, (Object)f.getAttribute(this.aname("uuidProperty")));
        w.write();
        w.close();
    }

    public void testRemoveFeatures() throws Exception {
        SimpleFeatureStore featureStore = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("guid"));
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("uuidProperty")), (Expression)ff.literal((Object)this.uuid1));
        featureStore.removeFeatures((Filter)filter);
        JDBCUuidTest.assertEquals((int)1, (int)featureStore.getCount(Query.ALL));
    }

    public void testUUIDAsPrimaryKey() throws Exception {
        DefaultTransaction transaction = new DefaultTransaction();
        SimpleFeatureStore featureStore = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("uuidt"));
        featureStore.setTransaction((Transaction)transaction);
        featureStore.addFeatures((FeatureCollection)this.createFeatureCollection());
        transaction.commit();
        JDBCUuidTest.assertEquals((int)3, (int)featureStore.getCount(Query.ALL));
        transaction.close();
    }

    private SimpleFeatureCollection createFeatureCollection() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("uuidt"));
        GeometryFactory gf = new GeometryFactory();
        Point p = gf.createPoint(new Coordinate(138.6, -34.93));
        SimpleFeature feature1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{p}, (String)this.uuid1.toString());
        feature1.getUserData().put(Hints.USE_PROVIDED_FID, true);
        feature1.getUserData().put(Hints.PROVIDED_FID, this.uuid1);
        SimpleFeature feature2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{p}, (String)this.uuid2.toString());
        feature2.getUserData().put(Hints.USE_PROVIDED_FID, true);
        feature2.getUserData().put(Hints.PROVIDED_FID, this.uuid2);
        SimpleFeature feature3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{p}, (String)this.uuid3.toString());
        feature3.getUserData().put(Hints.USE_PROVIDED_FID, true);
        feature3.getUserData().put(Hints.PROVIDED_FID, this.uuid3);
        return DataUtilities.collection((SimpleFeature[])new SimpleFeature[]{feature1, feature2, feature3});
    }
}

