/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.JDBCUDTTestSetup;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCUDTTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCUDTTestSetup createTestSetup();

    public void testSchema() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("udt"));
        JDBCUDTTest.assertNotNull((Object)type);
        JDBCUDTTest.assertNotNull((Object)type.getDescriptor(this.aname("ut")));
        JDBCUDTTest.assertEquals(String.class, (Object)type.getDescriptor(this.aname("ut")).getType().getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRead() throws Exception {
        SimpleFeatureType type = this.dataStore.getSchema(this.tname("udt"));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("udt")).getFeatures();
        SimpleFeatureIterator fi = null;
        try {
            fi = features.features();
            JDBCUDTTest.assertTrue((boolean)fi.hasNext());
            JDBCUDTTest.assertEquals((Object)"12ab", (Object)((SimpleFeature)fi.next()).getAttribute(this.aname("ut")));
            JDBCUDTTest.assertFalse((boolean)fi.hasNext());
        }
        finally {
            fi.close();
        }
    }

    public void testWrite() throws Exception {
        int count = this.dataStore.getFeatureSource(this.tname("udt")).getCount(Query.ALL);
        FeatureWriter w = this.dataStore.getFeatureWriterAppend(this.tname("udt"), Transaction.AUTO_COMMIT);
        w.hasNext();
        SimpleFeature f = (SimpleFeature)w.next();
        f.setAttribute(this.aname("ut"), (Object)"abcd");
        try {
            w.write();
            JDBCUDTTest.fail((String)"Write should have failed with UDT constraint failure");
        }
        catch (Exception e) {
            // empty catch block
        }
        f.setAttribute(this.aname("ut"), (Object)"34cd");
        w.write();
        w.close();
        JDBCUDTTest.assertEquals((int)(count + 1), (int)this.dataStore.getFeatureSource(this.tname("udt")).getCount(Query.ALL));
    }
}

