/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCTransactionTest
extends JDBCTestSupport {
    public void testCommit() throws IOException {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        DefaultTransaction tx = new DefaultTransaction();
        FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx);
        SimpleFeature feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        writer.write();
        writer.close();
        tx.commit();
        tx.close();
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        JDBCTransactionTest.assertEquals((int)4, (int)fc.size());
    }

    public void testNoCommit() throws IOException {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        DefaultTransaction tx = new DefaultTransaction();
        FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx);
        SimpleFeature feature = (SimpleFeature)writer.next();
        feature.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        writer.write();
        writer.close();
        tx.rollback();
        tx.close();
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        JDBCTransactionTest.assertEquals((int)3, (int)fc.size());
    }

    public void testConcurrentTransactions() throws IOException {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        DefaultTransaction tx1 = new DefaultTransaction();
        DefaultTransaction tx2 = new DefaultTransaction();
        FeatureWriter w1 = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx1);
        FeatureWriter w2 = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx2);
        SimpleFeature f1 = (SimpleFeature)w1.next();
        SimpleFeature f2 = (SimpleFeature)w2.next();
        f1.setAttribute(this.aname("intProperty"), (Object)new Integer(100));
        f2.setAttribute(this.aname("intProperty"), (Object)new Integer(101));
        w1.write();
        w2.write();
        w1.close();
        w2.close();
        tx1.commit();
        tx2.commit();
        tx1.close();
        tx2.close();
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        JDBCTransactionTest.assertEquals((int)5, (int)fc.size());
    }

    public void testSerialTransactions() throws IOException {
        SimpleFeatureStore st = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)st.getSchema());
        b.set(this.aname("intProperty"), (Object)new Integer(100));
        SimpleFeature f1 = b.buildFeature(null);
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, null);
        features.add((Feature)f1);
        DefaultTransaction tx1 = new DefaultTransaction();
        st.setTransaction((Transaction)tx1);
        st.addFeatures((FeatureCollection)features);
        tx1.commit();
        tx1.close();
        JDBCTransactionTest.assertEquals((int)4, (int)this.dataStore.getFeatureSource(this.tname("ft1")).getCount(Query.ALL));
        DefaultTransaction tx2 = new DefaultTransaction();
        st.setTransaction((Transaction)tx2);
        st.addFeatures((FeatureCollection)features);
        tx2.commit();
        tx2.close();
        JDBCTransactionTest.assertEquals((int)5, (int)this.dataStore.getFeatureSource(this.tname("ft1")).getCount(Query.ALL));
    }
}

