/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.jdbc.JDBCDataStoreAPITestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public abstract class JDBCSpatialFiltersTest
extends JDBCTestSupport {
    TestData td;

    @Override
    protected void connect() throws Exception {
        super.connect();
        if (this.td == null) {
            this.td = new TestData(((JDBCDataStoreAPITestSetup)this.setup).getInitialPrimaryKeyValue());
            this.td.ROAD = this.tname(this.td.ROAD);
            this.td.ROAD_ID = this.aname(this.td.ROAD_ID);
            this.td.ROAD_GEOM = this.aname(this.td.ROAD_GEOM);
            this.td.ROAD_NAME = this.aname(this.td.ROAD_NAME);
            this.td.RIVER = this.tname(this.td.RIVER);
            this.td.RIVER_ID = this.aname(this.td.RIVER_ID);
            this.td.RIVER_GEOM = this.aname(this.td.RIVER_GEOM);
            this.td.RIVER_FLOW = this.aname(this.td.RIVER_FLOW);
            this.td.RIVER_RIVER = this.aname(this.td.RIVER_RIVER);
            this.td.build();
        }
        this.dataStore.setDatabaseSchema(null);
    }

    @Override
    protected abstract JDBCDataStoreAPITestSetup createTestSetup();

    public void testBboxFilter() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox(this.aname("geom"), 2.0, 3.0, 4.0, 5.0, "EPSG:4326");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)bbox);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    public void testBboxFilterDefault() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("", 2.0, 3.0, 4.0, 5.0, "EPSG:4326");
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)bbox);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    public void testCrossesFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{2.0, 3.0, 4.0, 3.0}, 2));
        Crosses cs = ff.crosses((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)cs);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    public void testIntersectsFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{2.0, 1.0, 2.0, 3.0}, 2));
        Intersects is = ff.intersects((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)is);
        this.checkSingleResult((FeatureCollection)features, "r1");
    }

    public void testIntersectsRingFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing ls = gf.createLinearRing(sf.create(new double[]{2.0, 1.0, 2.0, 3.0, 0.0, 3.0, 2.0, 1.0}, 2));
        Intersects is = ff.intersects((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)is);
        this.checkSingleResult((FeatureCollection)features, "r1");
    }

    public void testTouchesFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LineString ls = gf.createLineString(sf.create(new double[]{1.0, 1.0, 1.0, 3.0}, 2));
        Touches is = ff.touches((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)ls));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)is);
        this.checkSingleResult((FeatureCollection)features, "r1");
    }

    public void testContainsFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing shell = gf.createLinearRing(sf.create(new double[]{2.0, -1.0, 2.0, 5.0, 4.0, 5.0, 4.0, -1.0, 2.0, -1.0}, 2));
        Polygon polygon = gf.createPolygon(shell, null);
        Contains cs = ff.contains((Expression)ff.literal((Object)polygon), (Expression)ff.property(this.aname("geom")));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)cs);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    public void testWithinFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing shell = gf.createLinearRing(sf.create(new double[]{2.0, -1.0, 2.0, 5.0, 4.0, 5.0, 4.0, -1.0, 2.0, -1.0}, 2));
        Polygon polygon = gf.createPolygon(shell, null);
        Within wt = ff.within((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)polygon));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)wt);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    public void testDisjointFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        PackedCoordinateSequenceFactory sf = new PackedCoordinateSequenceFactory();
        LinearRing shell = gf.createLinearRing(sf.create(new double[]{4.0, -1.0, 4.0, 5.0, 6.0, 5.0, 6.0, -1.0, 4.0, -1.0}, 2));
        Polygon polygon = gf.createPolygon(shell, null);
        Disjoint dj = ff.disjoint((Expression)ff.property(this.aname("geom")), (Expression)ff.literal((Object)polygon));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)dj);
        this.checkSingleResult((FeatureCollection)features, "r2");
    }

    public void testEqualsFilter() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        GeometryFactory gf = new GeometryFactory();
        Geometry g = gf.createGeometry((Geometry)this.td.roadFeatures[2].getDefaultGeometry());
        Equals cs = ff.equal((Expression)ff.literal((Object)g), (Expression)ff.property(this.aname("geom")));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures((Filter)cs);
        this.checkSingleResult((FeatureCollection)features, "r3");
    }

    protected void checkSingleResult(FeatureCollection features, String name) {
        JDBCSpatialFiltersTest.assertEquals((int)1, (int)features.size());
        FeatureIterator fr = features.features();
        JDBCSpatialFiltersTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBCSpatialFiltersTest.assertNotNull((Object)f);
        JDBCSpatialFiltersTest.assertEquals((Object)name, (Object)f.getAttribute(this.aname("name")));
        JDBCSpatialFiltersTest.assertFalse((boolean)fr.hasNext());
        fr.close();
    }

    public void testGeometryCollection() throws Exception {
        PrecisionModel precisionModel = new PrecisionModel();
        int SRID = 4326;
        GeometryFactory gf = new GeometryFactory(precisionModel, SRID);
        Coordinate[] points = new Coordinate[]{new Coordinate(30.0, 40.0), new Coordinate(50.0, 60.0)};
        LineString[] geometries = new LineString[2];
        geometries[0] = gf.createLineString(points);
        Coordinate[] points2 = new Coordinate[]{new Coordinate(40.0, 30.0), new Coordinate(70.0, 40.0)};
        geometries[1] = gf.createLineString(points2);
        GeometryFactory factory = new GeometryFactory();
        GeometryCollection geometry = new GeometryCollection((Geometry[])geometries, factory);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyName p = ff.property(this.aname("geom"));
        Literal collect = ff.literal((Object)geometry);
        DWithin dwithinGeomCo = ff.dwithin((Expression)p, (Expression)collect, 5.0, "meter");
        Query dq = new Query(this.tname("road"), (Filter)dwithinGeomCo);
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("road")).getFeatures(dq);
        JDBCSpatialFiltersTest.assertEquals((int)0, (int)features.size());
    }
}

