/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Collections;
import junit.framework.Assert;
import org.geotools.data.FeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCPrimaryKeyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public abstract class JDBCPrimaryKeyTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCPrimaryKeyTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.dataStore.setDatabaseSchema(null);
    }

    public void testAutoGeneratedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("auto"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof AutoGeneratedPrimaryKeyColumn));
        JDBCPrimaryKeyTest.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testSequencedPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("seq"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof SequencedPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testNonIncrementingPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    protected void addFeature(SimpleFeatureType featureType, FeatureCollection features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.add((Object)"four");
        b.add((Object)new GeometryFactory().createPoint(new Coordinate(4.0, 4.0)));
        SimpleFeature f = b.buildFeature(null);
        features.add((Feature)f);
        JDBCPrimaryKeyTest.assertTrue((boolean)((String)f.getUserData().get("fid")).matches(this.tname(featureType.getTypeName()) + ".4(\\..*)?"));
    }

    protected void assertPrimaryKeyValues(final FeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), (JDBCTestSupport.FeatureAssertion)new JDBCTestSupport.SimpleFeatureAssertion(){

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getID().split("\\.", 2)[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                Assert.assertEquals((String)(JDBCPrimaryKeyTest.this.tname(features.getSchema().getName().getLocalPart()) + "." + index), (String)feature.getID());
            }
        });
    }

    public void testMultiColumnPrimaryKey() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("multi"));
        JDBCPrimaryKeyTest.assertEquals((int)2, (int)fs.getPrimaryKey().getColumns().size());
        ContentFeatureCollection features = fs.getFeatures();
        this.assertMultiPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertMultiPrimaryKeyValues((FeatureCollection)features, 4);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Id id = ff.id(Collections.singleton(ff.featureId(this.tname("multi") + ".1.x")));
        features = fs.getFeatures((Filter)id);
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)features.size());
    }

    void assertMultiPrimaryKeyValues(FeatureCollection features, int count) throws Exception {
        this.assertFeatureIterator(1, count, features.features(), (JDBCTestSupport.FeatureAssertion)new JDBCTestSupport.SimpleFeatureAssertion(){
            String[] xyz = new String[]{"x", "y", "z"};

            @Override
            public int toIndex(SimpleFeature feature) {
                return Integer.parseInt(feature.getID().split("\\.")[1]);
            }

            @Override
            public void check(int index, SimpleFeature feature) {
                if (index < 4) {
                    Assert.assertEquals((String)(JDBCPrimaryKeyTest.this.tname("multi") + "." + index + "." + this.xyz[index - 1]), (String)feature.getID());
                } else {
                    Assert.assertTrue((boolean)feature.getID().startsWith(JDBCPrimaryKeyTest.this.tname("multi") + ".4."));
                }
            }
        });
    }

    public void testNullPrimaryKey() throws Exception {
        JDBCFeatureSource fs = (JDBCFeatureSource)this.dataStore.getFeatureSource(this.tname("nokey"));
        JDBCPrimaryKeyTest.assertFalse((boolean)(fs instanceof FeatureStore));
    }

    public void testUniqueIndex() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("uniq"));
        JDBCPrimaryKeyTest.assertEquals((int)1, (int)fs.getPrimaryKey().getColumns().size());
        JDBCPrimaryKeyTest.assertTrue((boolean)(fs.getPrimaryKey().getColumns().get(0) instanceof NonIncrementingPrimaryKeyColumn));
        JDBCPrimaryKeyTest.assertNull((Object)fs.getSchema().getDescriptor(((PrimaryKeyColumn)fs.getPrimaryKey().getColumns().get(0)).getName()));
        ContentFeatureCollection features = fs.getFeatures();
        this.assertPrimaryKeyValues((FeatureCollection)features, 3);
        this.addFeature(fs.getSchema(), (FeatureCollection)features);
        this.assertPrimaryKeyValues((FeatureCollection)features, 4);
    }

    public void testExposePrimaryKeyColumns() throws Exception {
        JDBCFeatureStore fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        JDBCPrimaryKeyTest.assertEquals((int)2, (int)fs.getSchema().getAttributeCount());
        fs = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("noninc"));
        fs.setExposePrimaryKeyColumns(true);
        JDBCPrimaryKeyTest.assertEquals((int)3, (int)fs.getSchema().getAttributeCount());
    }
}

