/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCNoPrimaryKeyTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;

public abstract class JDBCNoPrimaryKeyTest
extends JDBCTestSupport {
    protected static final String LAKE = "lake";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType lakeSchema;

    @Override
    protected abstract JDBCNoPrimaryKeyTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.lakeSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + LAKE), (String)"id:0,geom:Polygon,name:String");
    }

    public void testSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(LAKE));
        this.assertFeatureTypesEqual(this.lakeSchema, ft);
    }

    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(LAKE)).getFeatures();
        JDBCNoPrimaryKeyTest.assertEquals((int)1, (int)fc.size());
        SimpleFeatureIterator fr = fc.features();
        JDBCNoPrimaryKeyTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBCNoPrimaryKeyTest.assertFalse((boolean)fr.hasNext());
        fr.close();
    }

    public void testGetBounds() throws Exception {
        ReferencedEnvelope reference = this.dataStore.getFeatureSource(this.tname(LAKE)).getBounds();
        JDBCNoPrimaryKeyTest.assertEquals((Object)12.0, (Object)reference.getMinX());
        JDBCNoPrimaryKeyTest.assertEquals((Object)16.0, (Object)reference.getMaxX());
        JDBCNoPrimaryKeyTest.assertEquals((Object)4.0, (Object)reference.getMinY());
        JDBCNoPrimaryKeyTest.assertEquals((Object)8.0, (Object)reference.getMaxY());
    }

    public void testReadOnly() throws Exception {
        try {
            this.dataStore.getFeatureWriter(this.tname(LAKE), Transaction.AUTO_COMMIT);
            JDBCNoPrimaryKeyTest.fail((String)"Should not be able to pick a writer without a pk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDBCNoPrimaryKeyTest.assertFalse((boolean)(this.dataStore.getFeatureSource(this.tname(LAKE)) instanceof FeatureStore));
    }
}

