/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Arrays;
import java.util.HashSet;
import org.geotools.data.Join;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.jdbc.JDBCJoinTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public abstract class JDBCJoinTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCJoinTestSetup createTestSetup();

    public void testSimpleJoin() throws Exception {
        this.doTestSimpleJoin(false);
        this.doTestSimpleJoin(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSimpleJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        SimpleFeatureIterator ita = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures().features();
        SimpleFeatureIterator itb = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures().features();
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true)));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q).size(), (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            JDBCJoinTest.assertTrue((it.hasNext() && ita.hasNext() && itb.hasNext() ? 1 : 0) != 0);
            while (it.hasNext()) {
                int i;
                SimpleFeature f = (SimpleFeature)it.next();
                JDBCJoinTest.assertEquals((int)5, (int)f.getAttributeCount());
                SimpleFeature g = (SimpleFeature)f.getAttribute(this.tname("ftjoin"));
                SimpleFeature a = (SimpleFeature)ita.next();
                SimpleFeature b = (SimpleFeature)itb.next();
                for (i = 0; i < a.getAttributeCount(); ++i) {
                    this.assertAttributeValuesEqual(a.getAttribute(i), f.getAttribute(i));
                }
                for (i = 0; i < b.getAttributeCount(); ++i) {
                    this.assertAttributeValuesEqual(b.getAttribute(i), g.getAttribute(i));
                }
            }
        }
        finally {
            it.close();
            ita.close();
            itb.close();
        }
    }

    public void testSimpleJoinWithFilter() throws Exception {
        this.doTestSimpleJoinWithFilter(false);
        this.doTestSimpleJoinWithFilter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSimpleJoinWithFilter(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true)));
        q.setFilter((Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"two"), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            SimpleFeature f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)5, (int)f.getAttributeCount());
            JDBCJoinTest.assertEquals((int)2, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCJoinTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("ftjoin"));
            JDBCJoinTest.assertEquals((int)3, (int)g.getAttributeCount());
            JDBCJoinTest.assertEquals((int)2, (int)((Number)g.getAttribute(this.aname("id"))).intValue());
            JDBCJoinTest.assertEquals((Object)"two", (Object)g.getAttribute(this.aname("name")));
        }
        finally {
            it.close();
        }
    }

    public void testSimpleJoinWithFilterNoProperties() throws Exception {
        this.doTestSimpleJoinWithFilterNoProperties(false);
        this.doTestSimpleJoinWithFilterNoProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSimpleJoinWithFilterNoProperties(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        Join j = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
        j.setProperties(Query.NO_PROPERTIES);
        q.getJoins().add(j);
        q.setFilter((Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"two"), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            SimpleFeature f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)5, (int)f.getAttributeCount());
            JDBCJoinTest.assertEquals((int)2, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCJoinTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("ftjoin"));
            JDBCJoinTest.assertEquals((int)0, (int)g.getAttributeCount());
        }
        finally {
            it.close();
        }
    }

    public void testSimpleJoinWithFilterCount() throws Exception {
        this.doTestSimpleJoinWithFilterCount(false);
        this.doTestSimpleJoinWithFilterCount(true);
    }

    void doTestSimpleJoinWithFilterCount(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        Join j = new Join(this.tname("ftjoin"), (Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true));
        j.filter((Filter)ff.greater((Expression)ff.property(this.aname("id")), (Expression)ff.literal(1)));
        q.getJoins().add(j);
        q.setFilter((Filter)ff.less((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(3)));
        JDBCJoinTest.assertEquals((int)1, (int)this.dataStore.getFeatureSource(this.tname("ft1")).getCount(q));
    }

    public void testSimpleJoinWithPostFilter() throws Exception {
        this.doTestSimpleJoinWithPostFilter(false);
        this.doTestSimpleJoinWithPostFilter(true);
    }

    void doTestSimpleJoinWithPostFilter(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)j));
        q.setFilter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("stringProperty")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
        q = new Query(this.tname("ft1"));
        Join join = new Join(this.tname("ftjoin"), (Filter)j);
        join.filter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("name")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        q.getJoins().add(join);
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
    }

    public void testSimpleJoinWithPostFilterNoProperties() throws Exception {
        this.doTestSimpleJoinWithPostFilterNoProperties(false);
        this.doTestSimpleJoinWithPostFilterNoProperties(true);
    }

    void doTestSimpleJoinWithPostFilterNoProperties(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        Join join = new Join(this.tname("ftjoin"), (Filter)j);
        join.setProperties(Query.NO_PROPERTIES);
        q.getJoins().add(join);
        q.setFilter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("stringProperty")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
        q = new Query(this.tname("ft1"));
        join = new Join(this.tname("ftjoin"), (Filter)j);
        join.setProperties(Query.NO_PROPERTIES);
        join.filter((Filter)ff.equal((Expression)ff.function("__equals", new Expression[]{ff.property(this.aname("name")), ff.literal((Object)"one")}), (Expression)ff.literal(true), true));
        q.getJoins().add(join);
        features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
    }

    public void testSimpleJoinWithSort() throws Exception {
        this.doTestSimpleJoinWithSort(false);
        this.doTestSimpleJoinWithSort(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSimpleJoinWithSort(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)j));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.DESCENDING)});
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        SimpleFeatureIterator it = features.features();
        try {
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            JDBCJoinTest.assertEquals((Object)"two", (Object)((SimpleFeature)it.next()).getAttribute(this.aname("stringProperty")));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            JDBCJoinTest.assertEquals((Object)"one", (Object)((SimpleFeature)it.next()).getAttribute(this.aname("stringProperty")));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            JDBCJoinTest.assertEquals((Object)"zero", (Object)((SimpleFeature)it.next()).getAttribute(this.aname("stringProperty")));
        }
        finally {
            it.close();
        }
    }

    public void testSimpleJoinWithLimitOffset() throws Exception {
        this.doTestSimpleJoinWithLimitOffset(false);
        this.doTestSimpleJoinWithLimitOffset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSimpleJoinWithLimitOffset(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo j = ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.property(this.aname("name")), true);
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)j));
        q.setFilter((Filter)ff.greater((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(0)));
        q.setStartIndex(Integer.valueOf(1));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("ftjoin"));
            JDBCJoinTest.assertEquals((Object)"two", (Object)g.getAttribute(this.aname("name")));
        }
        finally {
            it.close();
        }
    }

    public void testSelfJoin() throws Exception {
        this.doTestSelfJoin(false);
        this.doTestSelfJoin(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSelfJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.getJoins().add(new Join(this.tname("ft1"), (Filter)ff.equal((Expression)ff.property(this.aname("intProperty")), (Expression)ff.property(this.aname("foo.intProperty")), true)).alias(this.aname("foo")));
        q.setFilter((Filter)ff.equal((Expression)ff.property(this.aname("stringProperty")), (Expression)ff.literal((Object)"two"), true));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)1, (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)5, (int)f.getAttributeCount());
            JDBCJoinTest.assertEquals((int)2, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCJoinTest.assertEquals((Object)"two", (Object)f.getAttribute(this.aname("stringProperty")));
            SimpleFeature g = (SimpleFeature)f.getAttribute(this.aname("foo"));
            JDBCJoinTest.assertEquals((int)4, (int)g.getAttributeCount());
            JDBCJoinTest.assertEquals((int)2, (int)((Number)g.getAttribute(this.aname("intProperty"))).intValue());
            JDBCJoinTest.assertEquals((Object)"two", (Object)g.getAttribute(this.aname("stringProperty")));
        }
        finally {
            it.close();
        }
    }

    public void testSpatialJoin() throws Exception {
        this.doTestSpatialJoin(false);
        this.doTestSpatialJoin(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestSpatialJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory2 ff = (FilterFactory2)this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ft1"));
        q.setPropertyNames(Arrays.asList(this.aname("geometry"), this.aname("intProperty")));
        q.setSortBy(new SortBy[]{ff.sort(this.aname("intProperty"), SortOrder.ASCENDING)});
        q.getJoins().add(new Join(this.tname("ftjoin"), (Filter)ff.contains((Expression)ff.property(this.aname("geom")), (Expression)ff.property(this.aname("geometry")))));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)6, (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            HashSet<String> s = new HashSet<String>(Arrays.asList("zero", "one", "two"));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            SimpleFeature f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)0, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)0, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)0, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            JDBCJoinTest.assertEquals((int)0, (int)s.size());
            s = new HashSet<String>(Arrays.asList("one", "two"));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)1, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)1, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            s.remove(((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            JDBCJoinTest.assertEquals((int)0, (int)s.size());
            JDBCJoinTest.assertTrue((boolean)it.hasNext());
            f = (SimpleFeature)it.next();
            JDBCJoinTest.assertEquals((int)2, (int)((Number)f.getAttribute(this.aname("intProperty"))).intValue());
            JDBCJoinTest.assertEquals((Object)"two", (Object)((SimpleFeature)f.getAttribute(this.tname("ftjoin"))).getAttribute(this.aname("name")));
            JDBCJoinTest.assertFalse((boolean)it.hasNext());
        }
        finally {
            it.close();
        }
    }

    public void testOuterJoin() throws Exception {
        this.doTestOuterJoin(false);
        this.doTestOuterJoin(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTestOuterJoin(boolean exposePrimaryKeys) throws Exception {
        this.dataStore.setExposePrimaryKeyColumns(exposePrimaryKeys);
        FilterFactory ff = this.dataStore.getFilterFactory();
        Query q = new Query(this.tname("ftjoin"));
        q.getJoins().add(new Join(this.tname("ft1"), (Filter)ff.equal((Expression)ff.property(this.aname("name")), (Expression)ff.property(this.aname("stringProperty")), true)).type(Join.Type.OUTER));
        ContentFeatureCollection features = this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures(q);
        JDBCJoinTest.assertEquals((int)this.dataStore.getFeatureSource(this.tname("ftjoin")).getFeatures(q).size(), (int)features.size());
        SimpleFeatureIterator it = features.features();
        try {
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                JDBCJoinTest.assertEquals((int)4, (int)f.getAttributeCount());
                SimpleFeature g = (SimpleFeature)f.getAttribute(this.tname("ft1"));
                if ("three".equals(f.getAttribute(this.aname("name")))) {
                    JDBCJoinTest.assertNull((Object)g);
                    continue;
                }
                JDBCJoinTest.assertNotNull((Object)g);
            }
        }
        finally {
            it.close();
        }
    }
}

