/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.jdbc.JDBCDelegatingTestSetup;
import org.geotools.jdbc.JDBCTestSetup;

public class JDBCJNDITestSetup
extends JDBCDelegatingTestSetup {
    public JDBCJNDITestSetup(JDBCTestSetup delegate) {
        super(delegate);
    }

    protected void setupJNDIEnvironment() throws IOException {
        File jndi = new File("target/jndi");
        jndi.mkdirs();
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(jndi, "ds.properties")));
        for (Map.Entry<Object, Object> e : this.fixture.entrySet()) {
            out.write(e.getKey().toString() + "=" + e.getValue().toString() + "\n");
        }
        if (!this.fixture.containsKey("password") && this.fixture.containsKey("passwd")) {
            out.write("password=" + this.fixture.get("passwd") + "\n");
        }
        out.write("type=javax.sql.DataSource\n");
        out.flush();
        out.close();
        String IC_FACTORY_PROPERTY = "java.naming.factory.initial";
        String JNDI_ROOT = "org.osjava.sj.root";
        String JNDI_DELIM = "org.osjava.jndi.delimiter";
        if (System.getProperty(IC_FACTORY_PROPERTY) == null) {
            System.setProperty(IC_FACTORY_PROPERTY, "org.osjava.sj.SimpleContextFactory");
        }
        if (System.getProperty(JNDI_ROOT) == null) {
            System.setProperty(JNDI_ROOT, jndi.getAbsolutePath());
        }
        if (System.getProperty(JNDI_DELIM) == null) {
            System.setProperty(JNDI_DELIM, "/");
        }
        LOGGER.fine(IC_FACTORY_PROPERTY + " = " + System.getProperty(IC_FACTORY_PROPERTY));
        LOGGER.fine(JNDI_ROOT + " = " + System.getProperty(JNDI_ROOT));
        LOGGER.fine(JNDI_DELIM + " = " + System.getProperty(JNDI_DELIM));
    }

    @Override
    protected DataSource createDataSource() throws IOException {
        this.setupJNDIEnvironment();
        DataSource ds = null;
        try {
            GeoTools.init((InitialContext)new InitialContext());
            InitialContext ctx = GeoTools.getInitialContext((Hints)GeoTools.getDefaultHints());
            ds = (DataSource)ctx.lookup("ds");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return ds;
    }
}

