/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Multiply;

public abstract class JDBCFunctionTest
extends JDBCTestSupport {
    static final Logger LOGGER = Logging.getLogger(JDBCFunctionTest.class);
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    SimpleFeatureSource fs;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.fs = this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    public void testStrfunc() throws IOException {
        if (this.skipTests(FilterFunction_strConcat.class)) {
            return;
        }
        Function func = this.ff.function("strConcat", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"abc")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"zeroabc"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrfuncNumbers() throws IOException {
        if (this.skipTests(FilterFunction_strConcat.class)) {
            return;
        }
        Function func = this.ff.function("strConcat", new Expression[]{this.ff.property(this.aname("intProperty")), this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"11"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    public void testStrEndsWith() throws IOException {
        if (this.skipTests(FilterFunction_strEndsWith.class)) {
            return;
        }
        Function func = this.ff.function("strEndsWith", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"o")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0", this.tname("ft1") + ".2");
    }

    public void testStrEndsWithOtherProperty() throws IOException {
        if (this.skipTests(FilterFunction_strEndsWith.class)) {
            return;
        }
        Function func = this.ff.function("strEndsWith", new Expression[]{this.ff.property(this.aname("doubleProperty")), this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0", this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    public void testStrStartsWith() throws IOException {
        if (this.skipTests(FilterFunction_strStartsWith.class)) {
            return;
        }
        Function func = this.ff.function("strStartsWith", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"ze")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrStartsWithOtherProperty() throws IOException {
        if (this.skipTests(FilterFunction_strStartsWith.class)) {
            return;
        }
        Function func = this.ff.function("strStartsWith", new Expression[]{this.ff.property(this.aname("doubleProperty")), this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0", this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    public void testStrIndexOf() throws IOException {
        if (this.skipTests(FilterFunction_strIndexOf.class)) {
            return;
        }
        Function func = this.ff.function("strIndexOf", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"er")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrLength() throws IOException {
        if (this.skipTests(FilterFunction_strLength.class)) {
            return;
        }
        Function func = this.ff.function("strLength", new Expression[]{this.ff.property(this.aname("stringProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(4));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrLower() throws IOException {
        if (this.skipTests(FilterFunction_strToLowerCase.class)) {
            return;
        }
        Function func = this.ff.function("strToLowerCase", new Expression[]{this.ff.property(this.aname("intProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"0"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrUpper() throws IOException {
        if (this.skipTests(FilterFunction_strToUpperCase.class)) {
            return;
        }
        Function func = this.ff.function("strToUpperCase", new Expression[]{this.ff.property(this.aname("stringProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"ZERO"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrEqualsIgnoreCase() throws IOException {
        if (this.skipTests(FilterFunction_strEqualsIgnoreCase.class)) {
            return;
        }
        Function func = this.ff.function("strEqualsIgnoreCase", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"ZeRo")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(true));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrSubstring() throws IOException {
        if (this.skipTests(FilterFunction_strSubstring.class)) {
            return;
        }
        Function func = this.ff.function("strSubstring", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"1"), this.ff.literal(3)});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"er"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrSubstringStart() throws IOException {
        if (this.skipTests(FilterFunction_strSubstringStart.class)) {
            return;
        }
        Function func = this.ff.function("strSubstringStart", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"1")});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"ero"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testStrTrim() throws IOException {
        if (this.skipTests(FilterFunction_strTrim.class) || this.skipTests(FilterFunction_strConcat.class)) {
            return;
        }
        Function func1 = this.ff.function("strConcat", new Expression[]{this.ff.property(this.aname("stringProperty")), this.ff.literal((Object)"   ")});
        Function func2 = this.ff.function("strTrim", new Expression[]{func1});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func2, (Expression)this.ff.literal((Object)"zero"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".0");
    }

    public void testAbs() throws IOException {
        if (this.skipTests(FilterFunction_abs.class)) {
            return;
        }
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs", new Expression[]{mul});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func2, (Expression)this.ff.literal((Object)"1"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    public void testAbs2() throws IOException {
        if (this.skipTests(FilterFunction_abs_2.class)) {
            return;
        }
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs_2", new Expression[]{mul});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func2, (Expression)this.ff.literal((Object)"1"));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    public void testAbs3() throws IOException {
        if (this.skipTests(FilterFunction_abs_3.class)) {
            return;
        }
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs_3", new Expression[]{mul});
        PropertyIsGreaterThanOrEqualTo filter = this.ff.greaterOrEqual((Expression)func2, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    public void testAbs4() throws IOException {
        if (this.skipTests(FilterFunction_abs_4.class)) {
            return;
        }
        Multiply mul = this.ff.multiply((Expression)this.ff.property(this.aname("doubleProperty")), (Expression)this.ff.literal(-1));
        Function func2 = this.ff.function("abs_4", new Expression[]{mul});
        PropertyIsGreaterThanOrEqualTo filter = this.ff.greaterOrEqual((Expression)func2, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1", this.tname("ft1") + ".2");
    }

    public void testCeil() throws IOException {
        if (this.skipTests(FilterFunction_ceil.class)) {
            return;
        }
        Function func = this.ff.function("ceil", new Expression[]{this.ff.property(this.aname("doubleProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(2));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    public void testFloor() throws IOException {
        if (this.skipTests(FilterFunction_ceil.class)) {
            return;
        }
        Function func = this.ff.function("floor", new Expression[]{this.ff.property(this.aname("doubleProperty"))});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal(1));
        this.assertFeatures(this.fs, (Filter)filter, this.tname("ft1") + ".1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertFeatures(SimpleFeatureSource fs2, Filter filter, String ... ids) throws IOException {
        SimpleFeatureIterator fi = null;
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
        int count = 0;
        try {
            fi = this.fs.getFeatures(filter).features();
            while (fi.hasNext()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                JDBCFunctionTest.assertTrue((String)("Found unexpected id " + sf.getID()), (boolean)idSet.contains(sf.getID()));
                ++count;
            }
        }
        finally {
            if (fi != null) {
                fi.close();
            }
        }
        if (count != idSet.size()) {
            JDBCFunctionTest.fail((String)("Expected to find " + idSet.size() + " features, but was " + count));
        }
    }

    protected boolean skipTests(Class<?> fClass) {
        if (!this.dataStore.getFilterCapabilities().supports(fClass)) {
            LOGGER.log(Level.INFO, "Function {0} is not natively supported, skipping test", fClass.getSimpleName());
            return true;
        }
        return false;
    }
}

