/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Set;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.jdbc.JDBCTestSupport;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public abstract class JDBCAggregateFunctionTest
extends JDBCTestSupport {
    boolean visited = false;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.visited = false;
    }

    public void testSum() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)3.3, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testSumWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        PropertyIsLessThan f = ff.less((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(2));
        DefaultQuery q = new DefaultQuery(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts((Query)q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testSumWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        DefaultQuery q = new DefaultQuery(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts((Query)q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMax() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)2.2, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMaxWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        PropertyIsLessThan f = ff.less((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(2));
        DefaultQuery q = new DefaultQuery(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts((Query)q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMaxWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        DefaultQuery q = new DefaultQuery(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts((Query)q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMin() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)0.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMinWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        DefaultQuery q = new DefaultQuery(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts((Query)q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testMinWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        DefaultQuery q = new DefaultQuery(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts((Query)q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        JDBCAggregateFunctionTest.assertEquals((double)0.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    public void testUnique() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionTest.assertEquals((int)3, (int)result.size());
        JDBCAggregateFunctionTest.assertTrue((boolean)result.contains("zero"));
        JDBCAggregateFunctionTest.assertTrue((boolean)result.contains("one"));
        JDBCAggregateFunctionTest.assertTrue((boolean)result.contains("two"));
    }

    public void testUniqueWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionTest.assertEquals((int)2, (int)result.size());
        JDBCAggregateFunctionTest.assertTrue((boolean)result.contains("one"));
        JDBCAggregateFunctionTest.assertTrue((boolean)result.contains("two"));
    }

    public void testUniqueWithLimitOffset() throws Exception {
        if (!this.dataStore.getSQLDialect().isLimitOffsetSupported()) {
            return;
        }
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        JDBCAggregateFunctionTest.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        JDBCAggregateFunctionTest.assertEquals((int)2, (int)result.size());
    }

    class MyUniqueVisitor
    extends UniqueVisitor {
        public MyUniqueVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }
    }

    class MyMinVisitor
    extends MinVisitor {
        public MyMinVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }
    }

    class MyMaxVisitor
    extends MaxVisitor {
        public MyMaxVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }
    }

    class MySumVisitor
    extends SumVisitor {
        public MySumVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionTest.this.visited = true;
        }
    }
}

