/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBC3DTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class JDBC3DTest
extends JDBCTestSupport {
    protected static final String LINE3D = "line3d";
    protected static final String POLY3D = "poly3d";
    protected static final String POINT3D = "point3d";
    protected static final String ID = "id";
    protected static final String GEOM = "geom";
    protected static final String NAME = "name";
    protected static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType poly3DType;
    protected SimpleFeatureType line3DType;
    protected CoordinateReferenceSystem epsg4326;

    @Override
    protected abstract JDBC3DTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.line3DType = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + this.tname(LINE3D)), (String)(this.aname(ID) + ":0," + this.aname(GEOM) + ":LineString:srid=4326," + this.aname(NAME) + ":String"));
        this.line3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.poly3DType = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + "." + this.tname(POLY3D)), (String)(this.aname(ID) + ":0," + this.aname(GEOM) + ":Polygon:srid=4326," + this.aname(NAME) + ":String"));
        this.poly3DType.getGeometryDescriptor().getUserData().put(Hints.COORDINATE_DIMENSION, 3);
        this.epsg4326 = CRS.decode((String)"EPSG:4326");
    }

    protected Integer getNativeSRID() {
        return new Integer(4326);
    }

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.dataStore.getSchema(this.tname(LINE3D));
        CoordinateReferenceSystem crs = schema.getGeometryDescriptor().getCoordinateReferenceSystem();
        JDBC3DTest.assertEquals((Object)new Integer(4326), (Object)CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        JDBC3DTest.assertEquals((Object)this.getNativeSRID(), schema.getGeometryDescriptor().getUserData().get("nativeSRID"));
    }

    public void testReadPoint() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(POINT3D)).getFeatures();
        SimpleFeatureIterator fr = fc.features();
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        Point p = (Point)((SimpleFeature)fr.next()).getDefaultGeometry();
        JDBC3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 1.0).equals((Object)p.getCoordinate()));
        fr.close();
    }

    public void testReadLine() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(LINE3D)).getFeatures();
        SimpleFeatureIterator fr = fc.features();
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        LineString ls = (LineString)((SimpleFeature)fr.next()).getDefaultGeometry();
        JDBC3DTest.assertEquals((int)4, (int)ls.getCoordinates().length);
        JDBC3DTest.assertTrue((boolean)new Coordinate(1.0, 1.0, 0.0).equals3D(ls.getCoordinateN(0)));
        JDBC3DTest.assertTrue((boolean)new Coordinate(2.0, 2.0, 0.0).equals3D(ls.getCoordinateN(1)));
        JDBC3DTest.assertTrue((boolean)new Coordinate(4.0, 2.0, 1.0).equals3D(ls.getCoordinateN(2)));
        JDBC3DTest.assertTrue((boolean)new Coordinate(5.0, 1.0, 1.0).equals3D(ls.getCoordinateN(3)));
        fr.close();
    }

    public void testWriteLine() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0, 0.0), new Coordinate(1.0, 1.0, 1.0)});
        SimpleFeature newFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.line3DType, (Object[])new Object[]{2, ls, "l3"}, null);
        SimpleFeatureStore fs = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname(LINE3D), Transaction.AUTO_COMMIT);
        List fids = fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)newFeature));
        SimpleFeatureIterator fi = fs.getFeatures((Filter)FF.id(new HashSet(fids))).features();
        JDBC3DTest.assertTrue((boolean)fi.hasNext());
        SimpleFeature f = (SimpleFeature)fi.next();
        JDBC3DTest.assertTrue((boolean)ls.equalsExact((Geometry)f.getDefaultGeometry()));
        fi.close();
    }

    public void testCreateSchemaAndInsertPolyTriangle() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{0.0, 0.0, 99.0, 1.0, 0.0, 33.0, 1.0, 1.0, 66.0, 0.0, 0.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, null);
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    public void testCreateSchemaAndInsertPolyRectangle() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{0.0, 0.0, 99.0, 1.0, 0.0, 33.0, 1.0, 1.0, 66.0, 0.0, 1.0, 33.0, 0.0, 0.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, null);
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    public void testCreateSchemaAndInsertPolyRectangleWithHole() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{0.0, 0.0, 99.0, 10.0, 0.0, 33.0, 10.0, 10.0, 66.0, 0.0, 10.0, 66.0, 0.0, 0.0, 99.0}, 3));
        LinearRing hole = gf.createLinearRing(csf.create(new double[]{2.0, 2.0, 99.0, 3.0, 2.0, 44.0, 3.0, 3.0, 99.0, 2.0, 3.0, 99.0, 2.0, 2.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, new LinearRing[]{hole});
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    public void testCreateSchemaAndInsertPolyWithHoleCW() throws Exception {
        LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
        GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)csf);
        LinearRing shell = gf.createLinearRing(csf.create(new double[]{1.0, 1.0, 99.0, 10.0, 1.0, 33.0, 10.0, 10.0, 66.0, 1.0, 10.0, 66.0, 1.0, 1.0, 99.0}, 3));
        LinearRing hole = gf.createLinearRing(csf.create(new double[]{2.0, 2.0, 99.0, 8.0, 2.0, 44.0, 8.0, 8.0, 99.0, 2.0, 8.0, 99.0, 2.0, 2.0, 99.0}, 3));
        Polygon poly = gf.createPolygon(shell, new LinearRing[]{hole});
        this.checkCreateSchemaAndInsert((Geometry)poly);
    }

    private void checkCreateSchemaAndInsert(Geometry poly) throws Exception {
        this.dataStore.createSchema(this.poly3DType);
        SimpleFeatureType actualSchema = this.dataStore.getSchema(this.tname(POLY3D));
        this.assertFeatureTypesEqual(this.poly3DType, actualSchema);
        JDBC3DTest.assertEquals((Object)this.getNativeSRID(), actualSchema.getGeometryDescriptor().getUserData().get("nativeSRID"));
        FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname(POLY3D), Transaction.AUTO_COMMIT);
        SimpleFeature f = (SimpleFeature)fw.next();
        f.setAttribute(this.aname(ID), (Object)0);
        f.setAttribute(this.aname(GEOM), (Object)poly);
        f.setAttribute(this.aname(NAME), (Object)"3dpolygon!");
        fw.write();
        fw.close();
        Hints hints = new Hints();
        hints.put((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        DefaultQuery query = new DefaultQuery(this.tname(POLY3D));
        query.setHints(hints);
        FeatureReader fr = this.dataStore.getFeatureReader((Query)query, Transaction.AUTO_COMMIT);
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        f = (SimpleFeature)fr.next();
        Geometry fgeom = (Geometry)f.getDefaultGeometry();
        JDBC3DTest.assertTrue((String)"2D topology does not match", (boolean)poly.equalsTopo(fgeom));
        JDBC3DTest.assertTrue((String)"Z values do not match", (boolean)JDBC3DTest.hasMatchingZValues(poly, fgeom));
        fr.close();
    }

    private static boolean hasMatchingZValues(Geometry g1, Geometry g2) {
        Coordinate[] pt1 = g1.getCoordinates();
        HashMap<Coordinate, Double> coordZMap = new HashMap<Coordinate, Double>();
        for (int i = 0; i < pt1.length; ++i) {
            coordZMap.put(pt1[i], pt1[i].z);
        }
        Coordinate[] pt2 = g2.getCoordinates();
        for (int i2 = 0; i2 < pt2.length; ++i2) {
            boolean isEqualZ;
            Coordinate p2 = pt2[i2];
            double z = (Double)coordZMap.get(p2);
            boolean bl = isEqualZ = p2.z == z || Double.isNaN(p2.z) && Double.isNaN(z);
            if (isEqualZ) continue;
            return false;
        }
        return true;
    }

    public void testBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(LINE3D)).getBounds();
        Envelope expected = new Envelope(1.0, 5.0, 0.0, 4.0);
        JDBC3DTest.assertEquals((Object)expected, (Object)env);
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)env.getCoordinateReferenceSystem());
    }

    public void testRendererBehaviour() throws Exception {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(LINE3D));
        JDBC3DTest.assertTrue((boolean)fs.getSupportedHints().contains(Hints.JTS_COORDINATE_SEQUENCE_FACTORY));
        DefaultQuery q = new DefaultQuery(this.tname(LINE3D));
        Hints hints = new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        q.setHints(hints);
        ContentFeatureCollection fc = fs.getFeatures((Query)q);
        FeatureType fcSchema = fc.getSchema();
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)fcSchema.getCoordinateReferenceSystem());
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)fcSchema.getGeometryDescriptor().getCoordinateReferenceSystem());
        LineString expected = new GeometryFactory().createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(4.0, 2.0), new Coordinate(5.0, 1.0)});
        FeatureReader fr = this.dataStore.getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)((SimpleFeatureType)fr.getFeatureType()).getCoordinateReferenceSystem());
        JDBC3DTest.assertEquals((Object)this.epsg4326, (Object)((SimpleFeatureType)fr.getFeatureType()).getGeometryDescriptor().getCoordinateReferenceSystem());
        JDBC3DTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature f = (SimpleFeature)fr.next();
        JDBC3DTest.assertTrue((boolean)expected.equalsExact((Geometry)f.getDefaultGeometry()));
        fr.close();
    }
}

