/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.StringWriter;
import java.io.Writer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.NullFilter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLFilterTestSupport;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Add;

public class SQLEncoderTest
extends SQLFilterTestSupport {
    private FilterFactory filterFac = FilterFactoryFinder.createFilterFactory();
    private org.opengis.filter.FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    String dataFolder = "";
    boolean setup = false;

    public SQLEncoderTest(String testName) {
        super(testName);
        LOGGER.finer("running SQLEncoderTests");
        this.dataFolder = System.getProperty("dataFolder");
        if (this.dataFolder == null) {
            this.dataFolder = System.getProperty("basedir");
            this.dataFolder = "file:////" + this.dataFolder + "/tests/unit/testData";
            LOGGER.finer("data folder is " + this.dataFolder);
        }
    }

    public void testConstructor() throws Exception {
        NullFilter tFilter = this.filterFac.createNullFilter();
        Integer testInt = new Integer(5);
        AttributeExpression testAtt = this.filterFac.createAttributeExpression(null, "test");
        tFilter.nullCheckValue((Expression)testAtt);
        LogicFilter notFilter = this.filterFac.createLogicFilter((short)3);
        notFilter.addFilter((org.opengis.filter.Filter)tFilter);
        StringWriter output = new StringWriter();
        SQLEncoder encoder = new SQLEncoder((Writer)output, (Filter)notFilter);
        LOGGER.fine("test filter is " + notFilter + "\n encoding result is " + output.getBuffer());
    }

    public void testInclude() throws Exception {
        StringWriter output = new StringWriter();
        SQLEncoder encoder = new SQLEncoder();
        encoder.encode((Writer)output, (org.opengis.filter.Filter)Filter.INCLUDE);
        SQLEncoderTest.assertEquals((String)output.getBuffer().toString(), (String)"WHERE TRUE");
    }

    public void testExclude() throws Exception {
        StringWriter output = new StringWriter();
        SQLEncoder encoder = new SQLEncoder();
        encoder.encode((Writer)output, (org.opengis.filter.Filter)Filter.EXCLUDE);
        SQLEncoderTest.assertEquals((String)output.getBuffer().toString(), (String)"WHERE FALSE");
    }

    public void testExpression() throws Exception {
        Add a = this.ff.add((org.opengis.filter.expression.Expression)this.ff.property("col"), (org.opengis.filter.expression.Expression)this.ff.literal(5));
        SQLEncoder encoder = new SQLEncoder();
        SQLEncoderTest.assertEquals((String)"col + 5", (String)encoder.encode((org.opengis.filter.expression.Expression)a));
        encoder.setSqlNameEscape("\"");
        SQLEncoderTest.assertEquals((String)"\"col\" + 5", (String)encoder.encode((org.opengis.filter.expression.Expression)a));
    }

    public void testEscapeQuote() throws SQLEncoderException {
        org.opengis.filter.FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo equals = ff.equals((org.opengis.filter.expression.Expression)ff.property("attribute"), (org.opengis.filter.expression.Expression)ff.literal((Object)"A'A"));
        SQLEncoder encoder = new SQLEncoder();
        String result = encoder.encode((org.opengis.filter.Filter)equals);
        SQLEncoderTest.assertEquals((String)"WHERE attribute = 'A''A'", (String)result);
    }
}

