/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class FilterToSQLTest
extends TestCase {
    private FilterFactory filterFac = CommonFactoryFinder.getFilterFactory(null);
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc");
    private SimpleFeatureType integerFType;
    private SimpleFeatureType stringFType;
    private FilterToSQL encoder;
    private StringWriter output;

    public void setUp() throws Exception {
        Level debugLevel = Level.FINE;
        for (Logger log = LOGGER; log != null; log = log.getParent()) {
            log.setLevel(debugLevel);
            for (int i = 0; i < log.getHandlers().length; ++i) {
                Handler h = log.getHandlers()[i];
                h.setLevel(debugLevel);
            }
        }
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", Integer.class);
        this.integerFType = ftb.buildFeatureType();
        ftb.setName("testFeatureType");
        ftb.add("testAttr", String.class);
        this.stringFType = ftb.buildFeatureType();
        this.output = new StringWriter();
        this.encoder = new FilterToSQL((Writer)this.output);
    }

    public void testIntegerContext() throws Exception {
        Literal literal = this.filterFac.literal(5);
        PropertyName prop = this.filterFac.property(((AttributeDescriptor)this.integerFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.filterFac.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.integerFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is an Integer " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = 5");
    }

    public void testStringContext() throws Exception {
        Literal literal = this.filterFac.literal(5);
        PropertyName prop = this.filterFac.property(((AttributeDescriptor)this.stringFType.getAttributeDescriptors().get(0)).getLocalName());
        PropertyIsEqualTo filter = this.filterFac.equals((Expression)prop, (Expression)literal);
        this.encoder.setFeatureType(this.stringFType);
        this.encoder.encode((Filter)filter);
        LOGGER.fine("testAttr is a String " + filter + " -> " + this.output.getBuffer().toString());
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE testAttr = '5'");
    }

    public void testInclude() throws Exception {
        this.encoder.encode((Filter)Filter.INCLUDE);
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE 1 = 1");
    }

    public void testExclude() throws Exception {
        this.encoder.encode((Filter)Filter.EXCLUDE);
        FilterToSQLTest.assertEquals((String)this.output.getBuffer().toString(), (String)"WHERE 0 = 1");
    }

    public void testIdFilter() throws Exception {
    }

    public void testEscapeQuote() throws FilterToSQLException {
        PropertyIsEqualTo equals = this.filterFac.equals((Expression)this.filterFac.property("attribute"), (Expression)this.filterFac.literal((Object)"A'A"));
        this.encoder.encode((Filter)equals);
        FilterToSQLTest.assertEquals((String)"WHERE attribute = 'A''A'", (String)this.output.toString());
    }

    public void testExpression() throws Exception {
        Add a = this.filterFac.add((Expression)this.filterFac.property("testAttr"), (Expression)this.filterFac.literal(5));
        this.encoder.encode((Expression)a);
        FilterToSQLTest.assertEquals((String)"testAttr + 5", (String)this.output.toString());
    }

    public void testEscapeQuoteFancy() throws FilterToSQLException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Object fancyLiteral = new Object(){

            public String toString() {
                return "A'A";
            }
        };
        PropertyIsEqualTo equals = ff.equals((Expression)ff.property("attribute"), (Expression)ff.literal(fancyLiteral));
        StringWriter output = new StringWriter();
        FilterToSQL encoder = new FilterToSQL((Writer)output);
        encoder.encode((Filter)equals);
        FilterToSQLTest.assertEquals((String)"WHERE attribute = 'A''A'", (String)output.toString());
    }

    public void testNumberEscapes() throws Exception {
        Add a = this.filterFac.add((Expression)this.filterFac.property("testAttr"), (Expression)this.filterFac.literal(5));
        PropertyIsEqualTo equal = this.filterFac.equal((Expression)this.filterFac.property("testAttr"), (Expression)a, false);
        StringWriter output = new StringWriter();
        FilterToSQL encoder = new FilterToSQL((Writer)output);
        encoder.encode((Filter)equal);
        FilterToSQLTest.assertEquals((String)"WHERE testAttr = testAttr + 5", (String)output.toString());
    }

    public void testInline() throws Exception {
        PropertyIsEqualTo equal = this.filterFac.equal((Expression)this.filterFac.property("testAttr"), (Expression)this.filterFac.literal(5), false);
        StringWriter output = new StringWriter();
        FilterToSQL encoder = new FilterToSQL((Writer)output);
        encoder.setInline(true);
        encoder.encode((Filter)equal);
        FilterToSQLTest.assertEquals((String)"testAttr = 5", (String)output.toString());
    }
}

