/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.Collections;
import java.util.HashSet;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.Envelope;

public class TestData {
    public String ROAD = "road";
    public String ROAD_ID = "id";
    public String ROAD_GEOM = "geom";
    public String ROAD_NAME = "name";
    public String RIVER = "river";
    public String RIVER_ID = "id";
    public String RIVER_GEOM = "geom";
    public String RIVER_RIVER = "river";
    public String RIVER_FLOW = "flow";
    public int initialFidValue = 0;
    public GeometryFactory gf;
    public FilterFactory ff;
    public String namespace = "http://www.geotools.org/test";
    public SimpleFeatureType roadType;
    public SimpleFeatureType subRoadType;
    public SimpleFeature[] roadFeatures;
    public ReferencedEnvelope roadBounds;
    public ReferencedEnvelope rd12Bounds;
    public Filter rd1Filter;
    public Filter rd2Filter;
    public Filter rd12Filter;
    public SimpleFeature newRoad;
    public SimpleFeatureType riverType;
    public SimpleFeatureType subRiverType;
    public SimpleFeature[] riverFeatures;
    public ReferencedEnvelope riverBounds;
    public Filter rv1Filter;
    public SimpleFeature newRiver;
    public boolean forceLongitudeFirst = false;

    public TestData(int initialFidValue) throws Exception {
        this.initialFidValue = initialFidValue;
        this.gf = new GeometryFactory();
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    public void build() throws Exception {
        this.createRoadData();
        this.createRiverData();
    }

    void createRoadData() throws Exception {
        this.roadType = DataUtilities.createType((String)(this.namespace + "." + this.ROAD), (String)(this.ROAD_ID + ":0," + this.ROAD_GEOM + ":LineString," + this.ROAD_NAME + ":String"));
        this.subRoadType = DataUtilities.createType((String)(this.namespace + this.ROAD), (String)(this.ROAD_ID + ":0," + this.ROAD_GEOM + ":LineString"));
        this.gf = new GeometryFactory();
        this.roadFeatures = new SimpleFeature[3];
        this.roadFeatures[0] = SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{1, this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "r1"}, (String)(this.ROAD + "." + this.initialFidValue));
        this.roadFeatures[1] = SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{2, this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "r2"}, (String)(this.ROAD + "." + (this.initialFidValue + 1)));
        this.roadFeatures[2] = SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{3, this.line(new int[]{3, 2, 4, 2, 5, 3}), "r3"}, (String)(this.ROAD + "." + (this.initialFidValue + 2)));
        this.roadBounds = new ReferencedEnvelope(CRS.decode((String)"EPSG:4326", (boolean)this.forceLongitudeFirst));
        this.roadBounds.expandToInclude((org.locationtech.jts.geom.Envelope)new ReferencedEnvelope(this.roadFeatures[0].getBounds()));
        this.roadBounds.expandToInclude((org.locationtech.jts.geom.Envelope)new ReferencedEnvelope(this.roadFeatures[1].getBounds()));
        this.roadBounds.expandToInclude((org.locationtech.jts.geom.Envelope)new ReferencedEnvelope(this.roadFeatures[2].getBounds()));
        this.rd1Filter = this.ff.id(Collections.singleton(this.ff.featureId(this.ROAD + "." + this.initialFidValue)));
        this.rd2Filter = this.ff.id(Collections.singleton(this.ff.featureId(this.ROAD + "." + (this.initialFidValue + 1))));
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        fids.add(this.ff.featureId(this.ROAD + "." + this.initialFidValue));
        fids.add(this.ff.featureId(this.ROAD + "." + (this.initialFidValue + 1)));
        this.rd12Filter = this.ff.id(fids);
        this.rd12Bounds = new ReferencedEnvelope();
        this.rd12Bounds.expandToInclude((org.locationtech.jts.geom.Envelope)new ReferencedEnvelope(this.roadFeatures[0].getBounds()));
        this.rd12Bounds.expandToInclude((org.locationtech.jts.geom.Envelope)new ReferencedEnvelope(this.roadFeatures[1].getBounds()));
        this.newRoad = SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{4, this.line(new int[]{1, 2, 2, 3}), "r4"}, (String)(this.ROAD + "." + (this.initialFidValue + 3)));
    }

    void createRiverData() throws Exception {
        this.riverType = DataUtilities.createType((String)(this.namespace + "." + this.RIVER), (String)(this.RIVER_ID + ":0," + this.RIVER_GEOM + ":MultiLineString," + this.RIVER_RIVER + ":String," + this.RIVER_FLOW + ":0.0"));
        this.subRiverType = DataUtilities.createType((String)(this.namespace + "." + this.RIVER), (String)(this.RIVER_RIVER + ":String," + this.RIVER_FLOW + ":0.0"));
        this.gf = new GeometryFactory();
        this.riverFeatures = new SimpleFeature[2];
        this.riverFeatures[0] = SimpleFeatureBuilder.build((SimpleFeatureType)this.riverType, (Object[])new Object[]{1, this.lines(new int[][]{{5, 5, 7, 4}, {7, 5, 9, 7, 13, 7}, {7, 5, 9, 3, 11, 3}}), "rv1", 4.5}, (String)(this.RIVER + "." + this.initialFidValue));
        this.riverFeatures[1] = SimpleFeatureBuilder.build((SimpleFeatureType)this.riverType, (Object[])new Object[]{2, this.lines(new int[][]{{4, 6, 4, 8, 6, 10}}), "rv2", 3.0}, (String)(this.RIVER + "." + (this.initialFidValue + 1)));
        this.riverBounds = new ReferencedEnvelope(CRS.decode((String)"EPSG:4326", (boolean)this.forceLongitudeFirst));
        this.riverBounds.expandToInclude((org.locationtech.jts.geom.Envelope)ReferencedEnvelope.reference((Envelope)this.riverFeatures[0].getBounds()));
        this.riverBounds.expandToInclude((org.locationtech.jts.geom.Envelope)ReferencedEnvelope.reference((Envelope)this.riverFeatures[1].getBounds()));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.rv1Filter = ff.id(Collections.singleton(ff.featureId(this.RIVER + ".rv1")));
        this.newRiver = SimpleFeatureBuilder.build((SimpleFeatureType)this.riverType, (Object[])new Object[]{3, this.lines(new int[][]{{9, 5, 11, 5, 13, 3}}), "rv3", 1.5}, (String)(this.RIVER + "." + (this.initialFidValue + 2)));
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return this.gf.createLineString(coords);
    }

    public MultiLineString lines(int[][] xy) {
        LineString[] lines = new LineString[xy.length];
        for (int i = 0; i < xy.length; ++i) {
            lines[i] = this.line(xy[i]);
        }
        return this.gf.createMultiLineString(lines);
    }

    public Polygon polygon(int[] xy) {
        LinearRing shell = this.ring(xy);
        return this.gf.createPolygon(shell, null);
    }

    public Polygon polygon(int[] xy, int[][] holes) {
        if (holes == null || holes.length == 0) {
            return this.polygon(xy);
        }
        LinearRing shell = this.ring(xy);
        LinearRing[] rings = new LinearRing[holes.length];
        for (int i = 0; i < xy.length; ++i) {
            rings[i] = this.ring(holes[i]);
        }
        return this.gf.createPolygon(shell, rings);
    }

    public LinearRing ring(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return this.gf.createLinearRing(coords);
    }
}

