/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCTransactionOnlineTest
extends JDBCTestSupport {
    @Test
    public void testCommit() throws IOException {
        try (DefaultTransaction tx = new DefaultTransaction();
             FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx);){
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttribute(this.aname("intProperty"), (Object)100);
            writer.write();
            writer.close();
            tx.commit();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        Assert.assertEquals((long)4L, (long)fc.size());
    }

    @Test
    public void testNoCommit() throws IOException {
        try (DefaultTransaction tx = new DefaultTransaction();
             FeatureWriter writer = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx);){
            SimpleFeature feature = (SimpleFeature)writer.next();
            feature.setAttribute(this.aname("intProperty"), (Object)100);
            writer.write();
            tx.rollback();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        Assert.assertEquals((long)3L, (long)fc.size());
    }

    @Test
    public void testConcurrentTransactions() throws IOException {
        try (DefaultTransaction tx1 = new DefaultTransaction();
             DefaultTransaction tx2 = new DefaultTransaction();
             FeatureWriter w1 = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx1);
             FeatureWriter w2 = this.dataStore.getFeatureWriterAppend(this.tname("ft1"), (Transaction)tx2);){
            SimpleFeature f1 = (SimpleFeature)w1.next();
            SimpleFeature f2 = (SimpleFeature)w2.next();
            f1.setAttribute(this.aname("intProperty"), (Object)100);
            f2.setAttribute(this.aname("intProperty"), (Object)101);
            w1.write();
            w2.write();
            w1.close();
            w2.close();
            tx1.commit();
            tx2.commit();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname("ft1")).getFeatures();
        Assert.assertEquals((long)5L, (long)fc.size());
    }

    @Test
    public void testSerialTransactions() throws IOException {
        SimpleFeatureStore st = (SimpleFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)st.getSchema());
        b.set(this.aname("intProperty"), (Object)100);
        SimpleFeature f1 = b.buildFeature(null);
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, null);
        features.add(f1);
        try (DefaultTransaction tx1 = new DefaultTransaction();){
            st.setTransaction((Transaction)tx1);
            st.addFeatures((FeatureCollection)features);
            tx1.commit();
        }
        Assert.assertEquals((long)4L, (long)this.dataStore.getFeatureSource(this.tname("ft1")).getCount(Query.ALL));
        try (DefaultTransaction tx2 = new DefaultTransaction();){
            st.setTransaction((Transaction)tx2);
            st.addFeatures((FeatureCollection)features);
            tx2.commit();
        }
        Assert.assertEquals((long)5L, (long)this.dataStore.getFeatureSource(this.tname("ft1")).getCount(Query.ALL));
    }
}

