/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCSkipColumnTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCSkipColumnOnlineTest
extends JDBCTestSupport {
    protected static final String SKIPCOLUMN = "skipcolumn";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String GEOM = "geom";
    protected SimpleFeatureType schema;

    @Override
    protected abstract JDBCSkipColumnTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.schema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + ".skipcolumn"), (String)"id:0,geom:Point,name:String");
    }

    @Test
    public void testSkippedColumn() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(SKIPCOLUMN));
        this.assertFeatureTypesEqual(this.schema, ft);
    }

    @Test
    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(SKIPCOLUMN)).getFeatures();
        Assert.assertEquals((long)1L, (long)fc.size());
        try (SimpleFeatureIterator fr = fc.features();){
            Assert.assertTrue((boolean)fr.hasNext());
            fr.next();
            Assert.assertFalse((boolean)fr.hasNext());
        }
    }

    @Test
    public void testGetBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(SKIPCOLUMN)).getBounds();
        Assert.assertEquals((double)0.0, (double)env.getMinX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)env.getMinY(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)env.getMaxX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)env.getMaxY(), (double)0.0);
    }
}

