/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCDelegatingTestSetup;
import org.geotools.jdbc.JDBCTestSetup;
import org.geotools.util.factory.GeoTools;
import org.mockito.Mockito;

public class JDBCJNDITestSetup
extends JDBCDelegatingTestSetup {
    private BasicDataSource dataSource;

    public JDBCJNDITestSetup(JDBCTestSetup delegate) {
        super(delegate);
    }

    protected void setupJNDIEnvironment(JDBCDataStoreFactory jdbcDataStoreFactory) throws IOException {
        HashMap<Object, Object> params = new HashMap<Object, Object>(this.fixture);
        params.put("passwd", params.get("password"));
        this.dataSource = jdbcDataStoreFactory.createDataSource(params);
        MockInitialDirContextFactory.setDataSource(this.dataSource);
        System.setProperty("java.naming.factory.initial", MockInitialDirContextFactory.class.getName());
        try {
            GeoTools.clearInitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataSource getDataSource() throws IOException {
        System.setProperty("java.naming.factory.initial", MockInitialDirContextFactory.class.getName());
        return super.getDataSource();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.dataSource != null) {
                this.dataSource.close();
            }
            super.tearDown();
        }
        finally {
            System.clearProperty("java.naming.factory.initial");
            GeoTools.clearInitialContext();
        }
    }

    public static class MockInitialDirContextFactory
    implements InitialContextFactory {
        private Context mockContext = null;
        private static BasicDataSource dataSource;

        public static void setDataSource(BasicDataSource dataSource) {
            MockInitialDirContextFactory.dataSource = dataSource;
        }

        public Context getInitialContext(Hashtable environment) throws NamingException {
            this.mockContext = (Context)Mockito.mock(Context.class);
            Mockito.when((Object)this.mockContext.lookup("ds")).thenReturn((Object)dataSource);
            return this.mockContext;
        }
    }
}

