/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.GroupByVisitorBuilder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.geotools.filter.function.DateDifferenceFunction;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;

public abstract class JDBCGroupByVisitorOnlineTest
extends JDBCTestSupport {
    @Test
    public void testSimpleGroupByWithMax() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MAX, "building_type");
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "HOUSE", "6.0");
        this.checkValueContains(value, "FABRIC", "500.0");
        this.checkValueContains(value, "SCHOOL", "60.0");
    }

    @Test
    public void testUnkonwnFunction() throws Exception {
        InternalVolatileFunction aggregateFunction = new InternalVolatileFunction(){

            public Object evaluate(Object object) {
                return String.valueOf(((SimpleFeature)object).getAttribute(JDBCGroupByVisitorOnlineTest.this.aname("building_type"))) + "_foo";
            }
        };
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.MAX, false, new Expression[]{aggregateFunction});
        Assert.assertNotNull(value);
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "HOUSE_foo", "6.0");
        this.checkValueContains(value, "FABRIC_foo", "500.0");
        this.checkValueContains(value, "SCHOOL_foo", "60.0");
    }

    @Test
    public void testAggregateOnMathExpression() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property("energy_consumption");
        Multiply expression = ff.multiply((Expression)pn, (Expression)ff.literal(10));
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, new Expression[]{expression});
        Assert.assertNotNull(value);
        Assert.assertEquals((long)9L, (long)value.size());
        this.checkValueContains(value, "40.0", "1");
        this.checkValueContains(value, "200.0", "2");
        this.checkValueContains(value, "600.0", "1");
        this.checkValueContains(value, "5000.0", "1");
        this.checkValueContains(value, "60.0", "1");
        this.checkValueContains(value, "100.0", "2");
        this.checkValueContains(value, "300.0", "2");
        this.checkValueContains(value, "500.0", "1");
        this.checkValueContains(value, "1500.0", "1");
    }

    @Test
    public void testComputeOnMathExpression() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("energy_consumption"));
        Multiply computeAttribute = ff.multiply((Expression)pn, (Expression)ff.literal(10));
        PropertyName groupAttribute = ff.property(this.aname("building_type"));
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.MAX, (Expression)computeAttribute, true, new Expression[]{groupAttribute});
        Assert.assertNotNull(value);
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "HOUSE", "60.0");
        this.checkValueContains(value, "FABRIC", "5000.0");
        this.checkValueContains(value, "SCHOOL", "600.0");
    }

    @Test
    public void testComputeOnMathExpressionWithLimit() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("energy_consumption"));
        Multiply computeAttribute = ff.multiply((Expression)pn, (Expression)ff.literal(10));
        PropertyName groupAttribute = ff.property(this.aname("building_type"));
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(3, 2), Aggregate.MAX, (Expression)computeAttribute, true, new Expression[]{groupAttribute});
        Assert.assertNotNull(value);
        Assert.assertTrue((value.size() >= 1 && value.size() <= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testNumericHistogram() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("energy_consumption"));
        Function expression = ff.function("floor", new Expression[]{ff.divide((Expression)pn, (Expression)ff.literal(100))});
        boolean expectOptimized = this.dataStore.getFilterCapabilities().supports(FilterFunction_floor.class);
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, expectOptimized, new Expression[]{expression});
        Assert.assertNotNull(value);
        Assert.assertEquals((long)value.size(), (long)3L);
        this.checkValueContains(value, "0", "10");
        this.checkValueContains(value, "1", "1");
        this.checkValueContains(value, "5", "1");
    }

    @Test
    public void testTimestampHistogram() throws Exception {
        this.testTimestampHistogram("last_update");
    }

    protected void testTimestampHistogram(String temporalColumnName) throws ParseException, IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname(temporalColumnName));
        Date baseDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2016-06-03 00:00:00");
        Function difference = ff.function("dateDifference", new Expression[]{pn, ff.literal((Object)baseDate)});
        int dayInMs = 86400000;
        Function expression = ff.function("floor", new Expression[]{ff.divide((Expression)difference, (Expression)ff.literal(dayInMs))});
        FilterCapabilities capabilities = this.dataStore.getFilterCapabilities();
        boolean expectOptimized = capabilities.supports(FilterFunction_floor.class) && capabilities.supports(DateDifferenceFunction.class);
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, expectOptimized, new Expression[]{expression});
        Assert.assertNotNull(value);
        Assert.assertEquals((long)5L, (long)value.size());
        this.checkValueContains(value, "0", "3");
        this.checkValueContains(value, "2", "1");
        this.checkValueContains(value, "3", "2");
        this.checkValueContains(value, "4", "3");
        this.checkValueContains(value, "12", "3");
    }

    @Test
    public void testMultipleGroupByWithMax() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MAX, "building_type", "energy_type");
        Assert.assertEquals((long)11L, (long)value.size());
        this.checkValueContains(value, "SCHOOL", "WIND", "20.0");
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "4.0");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "30.0");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "50.0");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "10.0");
        this.checkValueContains(value, "HOUSE", "FUEL", "6.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "SOLAR", "30.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
        this.checkValueContains(value, "FABRIC", "WIND", "20.0");
    }

    @Test
    public void testMultipleGroupByWithMaxWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.MAX, "building_type", "energy_type");
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
    }

    @Test
    public void testMultipleGroupByWithMaxWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.MAX, "building_type", "energy_type");
        Assert.assertFalse((boolean)value.isEmpty());
        Assert.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleGroupByWithMin() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MIN, "building_type");
        this.checkValueContains(value, "HOUSE", "4.0");
        this.checkValueContains(value, "FABRIC", "20.0");
        this.checkValueContains(value, "SCHOOL", "10.0");
    }

    @Test
    public void testMultipleGroupByWithMin() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.MIN, "building_type", "energy_type");
        this.checkValueContains(value, "SCHOOL", "WIND", "20.0");
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "4.0");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "30.0");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "50.0");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "10.0");
        this.checkValueContains(value, "HOUSE", "FUEL", "6.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "SOLAR", "30.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
        this.checkValueContains(value, "FABRIC", "WIND", "20.0");
    }

    @Test
    public void testMultipleGroupByWithMinWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.MIN, "building_type", "energy_type");
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
    }

    @Test
    public void testMultipleGroupByWithMinWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.MIN, "building_type", "energy_type");
        Assert.assertFalse((boolean)value.isEmpty());
        Assert.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleGroupByWithCount() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.COUNT, "building_type");
        this.checkValueContains(value, "HOUSE", "2");
        this.checkValueContains(value, "FABRIC", "4");
        this.checkValueContains(value, "SCHOOL", "6");
    }

    @Test
    public void testMultipleGroupByWithCount() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.COUNT, "building_type", "energy_type");
        this.checkValueContains(value, "SCHOOL", "WIND", "1");
        this.checkValueContains(value, "SCHOOL", "FUEL", "1");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "1");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "1");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "1");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "2");
        this.checkValueContains(value, "HOUSE", "FUEL", "1");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "1");
        this.checkValueContains(value, "FABRIC", "SOLAR", "1");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "1");
        this.checkValueContains(value, "FABRIC", "WIND", "1");
    }

    @Test
    public void testMultipleGroupByWithCountWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.COUNT, "building_type", "energy_type");
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "SCHOOL", "FUEL", "1");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "1");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "1");
    }

    @Test
    public void testMultipleGroupByWithCountWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.COUNT, "building_type", "energy_type");
        Assert.assertFalse((boolean)value.isEmpty());
        Assert.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleGroupByWithSum() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.SUM, "building_type");
        this.checkValueContains(value, "HOUSE", "10.0");
        this.checkValueContains(value, "FABRIC", "700.0");
        this.checkValueContains(value, "SCHOOL", "180.0");
    }

    protected void testGroupByWithAggregateAllValuesNull(Aggregate aggregate, boolean expectOptimized) throws Exception {
        PropertyName aggregateAttribute = CommonFactoryFinder.getFilterFactory().property(this.aname("fuel_consumption"));
        PropertyName groupBy = this.dataStore.getFilterFactory().property(this.aname("building_type"));
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, aggregate, (Expression)aggregateAttribute, expectOptimized, new Expression[]{groupBy});
        for (Object[] row : value) {
            Assert.assertNull((Object)row[1]);
        }
    }

    @Test
    public void testGroupByWithAggregateAllValuesNull() throws Exception {
        this.testGroupByWithAggregateAllValuesNull(Aggregate.MAX, true);
        this.testGroupByWithAggregateAllValuesNull(Aggregate.MIN, true);
        this.testGroupByWithAggregateAllValuesNull(Aggregate.SUM, true);
        this.testGroupByWithAggregateAllValuesNull(Aggregate.AVERAGE, true);
        this.testGroupByWithAggregateAllValuesNull(Aggregate.MEDIAN, false);
    }

    @Test
    public void testMultipleGroupByWithSum() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(Aggregate.SUM, "building_type", "energy_type");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "SOLAR", "30.0");
        this.checkValueContains(value, "FABRIC", "WIND", "20.0");
        this.checkValueContains(value, "HOUSE", "FUEL", "6.0");
        this.checkValueContains(value, "HOUSE", "NUCLEAR", "4.0");
        this.checkValueContains(value, "SCHOOL", "FLOWING_WATER", "50.0");
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "SCHOOL", "NUCLEAR", "20.0");
        this.checkValueContains(value, "SCHOOL", "SOLAR", "30.0");
        this.checkValueContains(value, "SCHOOL", "WIND", "20.0");
    }

    @Test
    public void testMultipleGroupByWithSumWithFilter() throws Exception {
        List<Object[]> value = this.genericGroupByTestTest(this.energyConsumptionGreaterThan(50.0), Aggregate.SUM, "building_type", "energy_type");
        Assert.assertEquals((long)3L, (long)value.size());
        this.checkValueContains(value, "SCHOOL", "FUEL", "60.0");
        this.checkValueContains(value, "FABRIC", "NUCLEAR", "150.0");
        this.checkValueContains(value, "FABRIC", "FLOWING_WATER", "500.0");
    }

    @Test
    public void testWithMinWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        List<Object[]> value = this.genericGroupByTestTest(this.queryWithLimits(0, 3), Aggregate.SUM, "building_type", "energy_type");
        Assert.assertFalse((boolean)value.isEmpty());
        Assert.assertTrue((value.size() <= 3 ? 1 : 0) != 0);
    }

    private Query queryWithLimits(int lower, int upper) {
        Query query = new Query(this.tname("buildings"));
        query.setStartIndex(Integer.valueOf(lower));
        query.setMaxFeatures(upper);
        return query;
    }

    private Query energyConsumptionGreaterThan(double value) {
        FilterFactory filterFactory = this.dataStore.getFilterFactory();
        PropertyIsGreaterThan filter = filterFactory.greater((Expression)filterFactory.property(this.aname("energy_consumption")), (Expression)filterFactory.literal(value));
        return new Query(this.tname("buildings"), (Filter)filter);
    }

    protected List<Object[]> genericGroupByTestTest(Aggregate aggregateVisitor, String ... groupByAttributes) throws IOException {
        return this.genericGroupByTestTest(Query.ALL, aggregateVisitor, groupByAttributes);
    }

    private List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, String ... groupByAttributes) throws IOException {
        Expression[] expressions = new Expression[groupByAttributes != null ? groupByAttributes.length : 0];
        if (groupByAttributes != null) {
            int i = 0;
            for (String attribute : groupByAttributes) {
                PropertyName property = this.dataStore.getFilterFactory().property(this.aname(attribute));
                expressions[i++] = property;
            }
        }
        return this.genericGroupByTestTest(query, aggregateVisitor, expressions);
    }

    private List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, Expression ... groupByAttributes) throws IOException {
        return this.genericGroupByTestTest(query, aggregateVisitor, true, groupByAttributes);
    }

    protected List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, boolean expectOptimized, Expression ... groupByAttributes) throws IOException {
        PropertyName aggregateAttribute = CommonFactoryFinder.getFilterFactory().property(this.aname("energy_consumption"));
        return this.genericGroupByTestTest(query, aggregateVisitor, (Expression)aggregateAttribute, expectOptimized, groupByAttributes);
    }

    private List<Object[]> genericGroupByTestTest(Query query, Aggregate aggregateVisitor, Expression aggregateAttribute, boolean expectOptimized, Expression ... groupByAttributes) throws IOException {
        List<Object[]> value = this.genericGroupByTestTest("buildings_group_by_tests", query, aggregateVisitor, aggregateAttribute, expectOptimized, groupByAttributes);
        return value;
    }

    private List<Object[]> genericGroupByTestTest(String tableName, Query query, Aggregate aggregateVisitor, Expression aggregateAttribute, boolean expectOptimized, Expression ... groupByAttributes) throws IOException {
        ContentFeatureSource featureSource = this.dataStore.getFeatureSource(this.tname(tableName));
        GroupByVisitorBuilder visitorBuilder = new GroupByVisitorBuilder().withAggregateAttribute(aggregateAttribute).withAggregateVisitor(aggregateVisitor);
        for (Expression groupByAttribute : groupByAttributes) {
            visitorBuilder.withGroupByAttribute(groupByAttribute);
        }
        GroupByVisitor visitor = visitorBuilder.build();
        featureSource.accepts(query, (FeatureVisitor)visitor, null);
        Assert.assertEquals((Object)expectOptimized, (Object)visitor.wasOptimized());
        Assert.assertEquals((Object)(!expectOptimized ? 1 : 0), (Object)visitor.wasVisited());
        List value = visitor.getResult().toList();
        Assert.assertNotNull((Object)value);
        return value;
    }

    protected void checkValueContains(List<Object[]> value, String ... expectedResult) {
        Assert.assertTrue((boolean)value.stream().anyMatch(result -> {
            if (((Object[])result).length != expectedResult.length) {
                return false;
            }
            for (int i = 0; i < ((Object[])result).length; ++i) {
                if (result[i] instanceof Number) {
                    double e;
                    double r = ((Number)result[i]).doubleValue();
                    return r == (e = Double.parseDouble(expectedResult[i]));
                }
                if (result[i].toString().equals(expectedResult[i])) continue;
                return false;
            }
            return true;
        }));
    }

    @Test
    public void testTimestampHistogramDateWithDifferenceInDays() throws ParseException, IOException {
        this.testTimestampHistogramDateWithDifferenceInSpecificTimeUnits("d", 1);
    }

    @Test
    public void testTimestampHistogramDateWithDifferenceInHours() throws ParseException, IOException {
        this.testTimestampHistogramDateWithDifferenceInSpecificTimeUnits("h", 24);
    }

    @Test
    public void testTimestampHistogramDateWithDifferenceInMinutes() throws ParseException, IOException {
        this.testTimestampHistogramDateWithDifferenceInSpecificTimeUnits("m", 1440);
    }

    @Test
    public void testTimestampHistogramDateWithDifferenceInSeconds() throws ParseException, IOException {
        this.testTimestampHistogramDateWithDifferenceInSpecificTimeUnits("s", 86400);
    }

    private void testTimestampHistogramDateWithDifferenceInSpecificTimeUnits(String timeUnits, int multiplyingFactor) throws ParseException, IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName pn = ff.property(this.aname("last_update_date"));
        Date baseDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2016-06-03 00:00:00");
        Function difference = ff.function("dateDifference", new Expression[]{pn, ff.literal((Object)baseDate), ff.literal((Object)timeUnits)});
        FilterCapabilities capabilities = this.dataStore.getFilterCapabilities();
        boolean expectOptimized = capabilities.supports(DateDifferenceFunction.class);
        List<Object[]> value = this.genericGroupByTestTest(Query.ALL, Aggregate.COUNT, expectOptimized, new Expression[]{difference});
        Assert.assertNotNull(value);
        Assert.assertEquals((long)5L, (long)value.size());
        this.checkValueContains(value, Integer.toString(0 * multiplyingFactor), "3");
        this.checkValueContains(value, Integer.toString(2 * multiplyingFactor), "1");
        this.checkValueContains(value, Integer.toString(3 * multiplyingFactor), "2");
        this.checkValueContains(value, Integer.toString(4 * multiplyingFactor), "3");
        this.checkValueContains(value, Integer.toString(12 * multiplyingFactor), "3");
    }

    @Test
    public void testGroupByGeometry() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName aggProperty = ff.property(this.aname("intProperty"));
        PropertyName groupProperty = ff.property(this.aname("geometry"));
        boolean expectOptimized = this.dataStore.getSQLDialect().canGroupOnGeometry();
        List<Object[]> value = this.genericGroupByTestTest("ft1_group_by", Query.ALL, Aggregate.SUM, (Expression)aggProperty, expectOptimized, new Expression[]{groupProperty});
        Assert.assertEquals((long)3L, (long)value.size());
        value.sort(Comparator.comparing(v -> (Geometry)v[0]));
        Object[] v0 = value.get(0);
        Assert.assertEquals((Object)new WKTReader().read("POINT(0 0)"), (Object)v0[0]);
        Assert.assertEquals((long)3L, (long)((Number)v0[1]).intValue());
        Object[] v1 = value.get(1);
        Assert.assertEquals((Object)new WKTReader().read("POINT(1 1)"), (Object)v1[0]);
        Assert.assertEquals((long)33L, (long)((Number)v1[1]).intValue());
        Object[] v2 = value.get(2);
        Assert.assertEquals((Object)new WKTReader().read("POINT(2 2)"), (Object)v2[0]);
        Assert.assertEquals((long)63L, (long)((Number)v2[1]).intValue());
    }

    @Test
    public void testGroupByGeometryFunction() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName aggProperty = ff.property(this.aname("intProperty"));
        Function groupProperty = ff.function("buffer", new Expression[]{ff.property(this.aname("geometry")), ff.literal(1)});
        List<Object[]> value = this.genericGroupByTestTest("ft1_group_by", Query.ALL, Aggregate.SUM, (Expression)aggProperty, false, new Expression[]{groupProperty});
        Assert.assertEquals((long)3L, (long)value.size());
        value.sort(Comparator.comparing(v -> (Geometry)v[0]));
        Object[] v0 = value.get(0);
        Assert.assertEquals((Object)new WKTReader().read("POINT(0 0)").buffer(1.0), (Object)v0[0]);
        Assert.assertEquals((long)3L, (long)((Number)v0[1]).intValue());
        Object[] v1 = value.get(1);
        Assert.assertEquals((Object)new WKTReader().read("POINT(1 1)").buffer(1.0), (Object)v1[0]);
        Assert.assertEquals((long)33L, (long)((Number)v1[1]).intValue());
        Object[] v2 = value.get(2);
        Assert.assertEquals((Object)new WKTReader().read("POINT(2 2)").buffer(1.0), (Object)v2[0]);
        Assert.assertEquals((long)63L, (long)((Number)v2[1]).intValue());
    }
}

