/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.List;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;

public abstract class JDBCFeatureWriterOnlineTest
extends JDBCTestSupport {
    @Test
    public void testNext() throws Exception {
        SimpleFeature feature;
        try (FeatureWriter writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);){
            Assert.assertTrue((boolean)writer.hasNext());
            feature = (SimpleFeature)writer.next();
            Assert.assertEquals((Object)"POINT (0 0)", (Object)feature.getAttribute(0).toString());
            Assert.assertEquals((long)0L, (long)((Integer)feature.getAttribute(1)).intValue());
            Assert.assertEquals((double)0.0, (double)((Double)feature.getAttribute(2)), (double)0.0);
            Assert.assertEquals((Object)"zero", (Object)feature.getAttribute(3));
        }
        writer = this.dataStore.getFeatureWriter(this.tname("ft1"), Transaction.AUTO_COMMIT);
        try {
            Assert.assertTrue((boolean)writer.hasNext());
            feature = (SimpleFeature)writer.next();
            List attributes = feature.getAttributes();
            for (Object attribute : attributes) {
                Assert.assertNotNull(attribute);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

