/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.CurvedGeometries;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.geotools.jdbc.JDBCCurvesTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCCurvesTest
extends JDBCTestSupport {
    @Override
    protected abstract JDBCCurvesTestSetup createTestSetup();

    @Test
    public void testSingleArc() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Single arc");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(SingleCurvedGeometry.class));
        SingleCurvedGeometry curved = (SingleCurvedGeometry)g;
        double[] cp = curved.getControlPoints();
        Assert.assertArrayEquals((double[])new double[]{10.0, 15.0, 15.0, 20.0, 20.0, 15.0}, (double[])cp, (double)0.0);
        Assert.assertEquals((double)0.1, (double)curved.getTolerance(), (double)0.0);
    }

    @Test
    public void testWriteSingleArc() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Single arc");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testSingleArc();
    }

    @Test
    public void testCircularString() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Arc string");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof SingleCurvedGeometry));
        SingleCurvedGeometry curved = (SingleCurvedGeometry)g;
        double[] cp = curved.getControlPoints();
        Assert.assertArrayEquals((double[])new double[]{10.0, 35.0, 15.0, 40.0, 20.0, 35.0, 25.0, 30.0, 30.0, 35.0}, (double[])cp, (double)0.0);
    }

    @Test
    public void testWriteCircularString() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Arc string");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCircularString();
    }

    @Test
    public void testCompoundOpen() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Compound line string");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        List components = compound.getComponents();
        Assert.assertEquals((long)3L, (long)components.size());
        LineString ls1 = (LineString)components.get(0);
        Assert.assertEquals((long)2L, (long)ls1.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(10.0, 45.0), (Object)ls1.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(20.0, 45.0), (Object)ls1.getCoordinateN(1));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 45.0, 23.0, 48.0, 20.0, 51.0}, (double[])cs.getControlPoints(), (double)0.0);
        LineString ls2 = (LineString)components.get(2);
        Assert.assertEquals((long)2L, (long)ls2.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(20.0, 51.0), (Object)ls2.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 51.0), (Object)ls2.getCoordinateN(1));
    }

    @Test
    public void testWriteCompoundOpen() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Compound line string");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCompoundOpen();
    }

    @Test
    public void testCompoundClosed() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Closed mixed line");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)g;
        List components = compound.getComponents();
        Assert.assertEquals((long)2L, (long)components.size());
        LineString ls = (LineString)components.get(0);
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(10.0, 78.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 75.0), (Object)ls.getCoordinateN(1));
        Assert.assertEquals((Object)new Coordinate(20.0, 75.0), (Object)ls.getCoordinateN(2));
        Assert.assertEquals((Object)new Coordinate(20.0, 78.0), (Object)ls.getCoordinateN(3));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{20.0, 78.0, 15.0, 80.0, 10.0, 78.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    @Test
    public void testWriteCompoundClosed() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Closed mixed line");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCompoundClosed();
    }

    @Test
    public void testCircle() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Circle");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof Polygon));
        Polygon p = (Polygon)g;
        Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
        Assert.assertTrue((boolean)(p.getExteriorRing() instanceof CircularRing));
        CircularRing shell = (CircularRing)p.getExteriorRing();
        Assert.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)shell));
        CircularArc arc = shell.getArcN(0);
        Assert.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        Assert.assertEquals((Object)new Coordinate(15.0, 150.0), (Object)arc.getCenter());
    }

    @Test
    public void testWriteCircle() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Circle");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCircle();
    }

    @Test
    public void testCompoundPolygon() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Compound polygon");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof CurvePolygon));
        Polygon p = (Polygon)g;
        Assert.assertEquals((long)0L, (long)p.getNumInteriorRing());
        Assert.assertTrue((boolean)(p.getExteriorRing() instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry compound = (CompoundCurvedGeometry)p.getExteriorRing();
        List components = compound.getComponents();
        Assert.assertEquals((long)2L, (long)components.size());
        LineString ls = (LineString)components.get(0);
        Assert.assertEquals((long)3L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(6.0, 10.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(10.0, 1.0), (Object)ls.getCoordinateN(1));
        Assert.assertEquals((Object)new Coordinate(14.0, 10.0), (Object)ls.getCoordinateN(2));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{14.0, 10.0, 10.0, 14.0, 6.0, 10.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    @Test
    public void testWriteCompoundPolygon() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Compound polygon");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCompoundPolygon();
    }

    @Test
    public void testCompoundPolygonWithHole() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Compound polygon with hole");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        Assert.assertTrue((boolean)(g instanceof Polygon));
        Polygon p = (Polygon)g;
        Assert.assertEquals((long)1L, (long)p.getNumInteriorRing());
        Assert.assertTrue((boolean)(p.getExteriorRing() instanceof CompoundCurvedGeometry));
        CompoundCurvedGeometry shell = (CompoundCurvedGeometry)p.getExteriorRing();
        List components = shell.getComponents();
        Assert.assertEquals((long)2L, (long)components.size());
        LineString ls = (LineString)components.get(0);
        Assert.assertEquals((long)7L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(20.0, 30.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(11.0, 30.0), (Object)ls.getCoordinateN(1));
        Assert.assertEquals((Object)new Coordinate(7.0, 22.0), (Object)ls.getCoordinateN(2));
        Assert.assertEquals((Object)new Coordinate(7.0, 15.0), (Object)ls.getCoordinateN(3));
        Assert.assertEquals((Object)new Coordinate(11.0, 10.0), (Object)ls.getCoordinateN(4));
        Assert.assertEquals((Object)new Coordinate(21.0, 10.0), (Object)ls.getCoordinateN(5));
        Assert.assertEquals((Object)new Coordinate(27.0, 30.0), (Object)ls.getCoordinateN(6));
        CircularString cs = (CircularString)components.get(1);
        Assert.assertArrayEquals((double[])new double[]{27.0, 30.0, 25.0, 27.0, 20.0, 30.0}, (double[])cs.getControlPoints(), (double)0.0);
        Assert.assertTrue((boolean)(p.getInteriorRingN(0) instanceof CircularRing));
        CircularRing hole = (CircularRing)p.getInteriorRingN(0);
        Assert.assertTrue((boolean)CurvedGeometries.isCircle((Geometry)hole));
        CircularArc arc = hole.getArcN(0);
        Assert.assertEquals((double)5.0, (double)arc.getRadius(), (double)0.0);
        Assert.assertEquals((Object)new Coordinate(15.0, 17.0), (Object)arc.getCenter());
    }

    @Test
    public void testWriteCompoundPolygonWithHole() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Compound polygon with hole");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCompoundPolygonWithHole();
    }

    @Test
    public void testMultipolygon() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Multipolygon with curves");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(GeometryCollection.class));
        GeometryCollection mp = (GeometryCollection)g;
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        Polygon p1 = (Polygon)mp.getGeometryN(0);
        Assert.assertTrue((boolean)(p1.getExteriorRing() instanceof CompoundCurvedGeometry));
        Assert.assertEquals((long)2L, (long)((CompoundCurvedGeometry)p1.getExteriorRing()).getComponents().size());
        Assert.assertEquals((long)1L, (long)p1.getNumInteriorRing());
        Assert.assertEquals((long)2L, (long)((CompoundCurvedGeometry)p1.getInteriorRingN(0)).getComponents().size());
        Polygon p2 = (Polygon)mp.getGeometryN(1);
        Assert.assertTrue((boolean)(p2.getExteriorRing() instanceof CompoundCurvedGeometry));
        Assert.assertEquals((long)2L, (long)((CompoundCurvedGeometry)p2.getExteriorRing()).getComponents().size());
        Assert.assertEquals((long)0L, (long)p2.getNumInteriorRing());
    }

    @Test
    public void testWriteMultipolygon() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Multipolygon with curves");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testMultipolygon();
    }

    @Test
    public void testMulticurve() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Multicurve");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(GeometryCollection.class));
        GeometryCollection mls = (GeometryCollection)g;
        LineString ls = (LineString)mls.getGeometryN(0);
        Assert.assertEquals((long)2L, (long)ls.getNumPoints());
        Assert.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)ls.getCoordinateN(0));
        Assert.assertEquals((Object)new Coordinate(5.0, 5.0), (Object)ls.getCoordinateN(1));
        CircularString cs = (CircularString)mls.getGeometryN(1);
        Assert.assertArrayEquals((double[])new double[]{4.0, 0.0, 4.0, 4.0, 8.0, 4.0}, (double[])cs.getControlPoints(), (double)0.0);
    }

    @Test
    public void testWriteMulticurve() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("Multicurve");
        ContentFeatureStore fs = this.cleanTable("curves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testMulticurve();
    }

    @Test
    public void testClosedCircularString() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("circularStrings", "Circle");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvedGeometry.class));
        Assert.assertTrue((boolean)((LineString)g).isClosed());
    }

    @Test
    public void testWriteClosedCircularString() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("circularStrings", "Circle");
        ContentFeatureStore fs = this.cleanTable("circularStrings");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testCircularString();
    }

    @Test
    public void testClosedCompoundCurve() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("compoundCurves", "ClosedHalfCircle");
        Geometry g = (Geometry)feature.getDefaultGeometry();
        Assert.assertNotNull((Object)g);
        MatcherAssert.assertThat((Object)g, (Matcher)CoreMatchers.instanceOf(CurvedGeometry.class));
        Assert.assertTrue((boolean)((LineString)g).isClosed());
    }

    @Test
    public void testWriteClosedCompoundCurve() throws Exception {
        SimpleFeature feature = this.getSingleFeatureByName("compoundCurves", "ClosedHalfCircle");
        ContentFeatureStore fs = this.cleanTable("compoundCurves");
        fs.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        this.testClosedCompoundCurve();
    }

    protected SimpleFeature getSingleFeatureByName(String name) throws IOException {
        return this.getSingleFeatureByName("curves", name);
    }

    protected SimpleFeature getSingleFeatureByName(String tableName, String name) throws IOException {
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname(tableName));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property(this.aname("name")), (Expression)ff.literal((Object)name), true);
        Query q = new Query(this.tname("curves"), (Filter)filter);
        q.getHints().put((Object)Hints.LINEARIZATION_TOLERANCE, (Object)0.1);
        ContentFeatureCollection fc = fs.getFeatures(q);
        Assert.assertEquals((long)1L, (long)fc.size());
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        return feature;
    }

    protected ContentFeatureStore cleanTable(String tableName) throws IOException {
        ContentFeatureStore store = (ContentFeatureStore)this.dataStore.getFeatureSource(this.tname(tableName));
        store.removeFeatures((Filter)Filter.INCLUDE);
        return store;
    }
}

