/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.GroupByVisitorBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumAreaVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueCountVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.SortByImpl;
import org.geotools.filter.function.FilterFunction_area;
import org.geotools.jdbc.JDBCAggregateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public abstract class JDBCAggregateFunctionOnlineTest
extends JDBCTestSupport {
    boolean visited = false;

    @Override
    protected abstract JDBCAggregateTestSetup createTestSetup();

    @Before
    public void resetVisited() {
        this.visited = false;
    }

    @Test
    public void testSum() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)3.3, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testSumArea() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("geom"));
        MySumAreaVisitor v = new MySumAreaVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("aggregate")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertEquals((Object)this.visited, (Object)(!this.dataStore.getFilterCapabilities().supports(FilterFunction_area.class) ? 1 : 0));
        Assert.assertEquals((double)30.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testSumAreaWithGroupBy() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("geom"));
        GroupByVisitor v = new GroupByVisitorBuilder().withAggregateAttribute((Expression)ff.function("area2", new Expression[]{p})).withAggregateVisitor("SumArea").withGroupByAttributes(Collections.singleton(this.aname("name")), this.dataStore.getSchema(this.tname("aggregate"))).build();
        this.dataStore.getFeatureSource(this.tname("aggregate")).accepts(Query.ALL, (FeatureVisitor)v, null);
        if (this.dataStore.getFilterCapabilities().supports(FilterFunction_area.class)) {
            Assert.assertFalse((boolean)this.visited);
        }
        List groups = v.getResult().toList();
        Assert.assertEquals((double)20.0, (double)((Double)((Object[])groups.get(0))[1]), (double)0.01);
        Assert.assertEquals((double)10.0, (double)((Double)((Object[])groups.get(1))[1]), (double)0.01);
    }

    @Test
    public void testSumWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        PropertyIsLessThan f = ff.less((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(2));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testSumWithFunctionFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        PropertyIsEqualTo f = ff.equals((Expression)ff.function("strMatches", new Expression[]{ff.property(this.aname("stringProperty")), ff.literal((Object)"zero*")}), (Expression)ff.literal(false));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertEquals((double)3.3, (double)v.getResult().toDouble(), (double)1.0E-5);
    }

    @Test
    public void testSumWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MySumVisitor v = new MySumVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testMax() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)2.2, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testMaxWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        PropertyIsLessThan f = ff.less((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(2));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testMaxWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMaxVisitor v = new MyMaxVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testMin() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)0.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testMinWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testMinWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyMinVisitor v = new MyMinVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)0.0, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testUnique() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("zero"));
        Assert.assertTrue((boolean)result.contains("one"));
        Assert.assertTrue((boolean)result.contains("two"));
    }

    @Test
    public void testUniqueWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("one"));
        Assert.assertTrue((boolean)result.contains("two"));
    }

    @Test
    public void testUniqueWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testUniqueWithLimitOnVisitor() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        v.setPreserveOrder(true);
        v.setStartIndex(0);
        v.setMaxFeatures(2);
        Query q = new Query(this.tname("ft1"));
        q.setSortBy(new SortBy[]{new SortByImpl(p, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"one", result.iterator().next());
    }

    @Test
    public void testUniqueWithNonMatchingSort() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        v.setStartIndex(0);
        Query q = new Query(this.tname("ft1"));
        PropertyName pNonMatching = ff.property(this.aname("doubleProperty"));
        q.setSortBy(new SortBy[]{new SortByImpl(pNonMatching, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)3L, (long)result.size());
    }

    @Test
    public void testStoreChecksVisitorLimits() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p){

            public boolean hasLimits() {
                return true;
            }
        };
        v.setPreserveOrder(true);
        Query q = new Query(this.tname("ft1"));
        q.setMaxFeatures(1);
        q.setSortBy(new SortBy[]{new SortByImpl(p, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"one", result.iterator().next());
    }

    @Test
    public void testUniqueWithLimitOffsetOnVisitor() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isAggregatedSortSupported("distinct"));
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        MyUniqueVisitor v = new MyUniqueVisitor((Expression)p);
        v.setPreserveOrder(true);
        v.setStartIndex(1);
        v.setMaxFeatures(2);
        Query q = new Query(this.tname("ft1"));
        q.setSortBy(new SortBy[]{new SortByImpl(p, SortOrder.ASCENDING)});
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"two", result.iterator().next());
    }

    @Test
    public void testNearest() throws IOException {
        this.testNearest("ft1", "stringProperty", "two", "two");
        this.testNearest("ft1", "stringProperty", "aaa", "one");
        this.testNearest("ft1", "stringProperty", "rrr", "one", "two");
        this.testNearest("ft1", "stringProperty", "zzz", "zero");
        this.testNearest("ft1", "intProperty", 1, 1);
        this.testNearest("ft1", "intProperty", -10, 0);
        this.testNearest("ft1", "intProperty", 10, 2);
        this.testNearest("ft1", "doubleProperty", 1.1, 1.1);
        this.testNearest("ft1", "doubleProperty", -10.0, 0.0);
        this.testNearest("ft1", "doubleProperty", 1.3, 1.1);
        this.testNearest("ft1", "doubleProperty", 1.9, 2.2);
        this.testNearest("ft1", "doubleProperty", 10.0, 2.2);
    }

    private void testNearest(String typeName, String attributeName, Object target, Object ... validResults) throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyName expr = ff.property(this.aname(attributeName));
        MyNearestVisitor v = new MyNearestVisitor((Expression)expr, target);
        this.dataStore.getFeatureSource(this.tname(typeName)).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Object nearestMatch = v.getNearestMatch();
        if (validResults.length == 0) {
            Assert.assertNull((Object)nearestMatch);
        } else {
            boolean found = false;
            for (Object object : validResults) {
                if (!object.equals(Converters.convert((Object)nearestMatch, object.getClass()))) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Could not match nearest " + String.valueOf(nearestMatch) + " among valid values " + String.valueOf(Arrays.asList(validResults))), (boolean)found);
        }
    }

    @Test
    public void testAverage() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyAverageVisitor v = new MyAverageVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.1, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testAverageWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyAverageVisitor v = new MyAverageVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)1.65, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testAverageWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyAverageVisitor v = new MyAverageVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)0.55, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testStandardDeviation() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyStandardDeviationVisitor v = new MyStandardDeviationVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)0.89, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testStandardDeviationWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyStandardDeviationVisitor v = new MyStandardDeviationVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)0.55, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testStandardDeviationWithLimitOffset() throws Exception {
        Assume.assumeTrue((boolean)this.dataStore.getSQLDialect().isLimitOffsetSupported());
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("doubleProperty"));
        MyStandardDeviationVisitor v = new MyStandardDeviationVisitor((Expression)p);
        Query q = new Query(this.tname("ft1"));
        q.setStartIndex(Integer.valueOf(0));
        q.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Assert.assertEquals((double)0.55, (double)v.getResult().toDouble(), (double)0.01);
    }

    @Test
    public void testUniqueCount() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        UniqueCountVisitor v = new UniqueCountVisitor((Expression)p);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        int result = v.getResult().toInt();
        Assert.assertEquals((long)0L, (long)v.getUnique().size());
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testUniqueCountWithFilter() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        UniqueCountVisitor v = new UniqueCountVisitor((Expression)p);
        PropertyIsGreaterThan f = ff.greater((Expression)ff.property(this.aname("doubleProperty")), (Expression)ff.literal(1));
        Query q = new Query(this.tname("ft1"), (Filter)f);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(q, (FeatureVisitor)v, null);
        Assert.assertFalse((boolean)this.visited);
        Set result = v.getUnique();
        Assert.assertEquals((long)0L, (long)result.size());
        Assert.assertEquals((long)2L, (long)v.getResult().toInt());
    }

    @Test
    public void testUniqueCountWithLimit() throws Exception {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyName p = ff.property(this.aname("stringProperty"));
        UniqueCountVisitor v = new UniqueCountVisitor((Expression)p);
        v.setMaxFeatures(2);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        int result = v.getResult().toInt();
        Assert.assertEquals((long)0L, (long)v.getUnique().size());
        Assert.assertEquals((long)2L, (long)result);
    }

    @Test
    public void testUniqueMultipleAttributes() throws Exception {
        UniqueVisitor v = new UniqueVisitor(new String[]{"stringProperty", "doubleProperty"});
        this.dataStore.getFeatureSource(this.tname("ft4")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Set result = v.getResult().toSet();
        this.convertNumbers(result, new int[]{1}, new Class[]{Double.class});
        HashSet expected = new HashSet();
        this.addValues(expected, "zero", 0.0);
        this.addValues(expected, "one", 1.1);
        this.addValues(expected, "one_2", 1.1);
        this.addValues(expected, "two", 2.2);
        this.addValues(expected, "two_2", 2.2);
        this.addValues(expected, "three", 3.3);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }

    @Test
    public void testUniqueMultipleAttributes2() throws Exception {
        UniqueVisitor v = new UniqueVisitor(new String[]{"intProperty", "doubleProperty"});
        this.dataStore.getFeatureSource(this.tname("ft4")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Set result = v.getResult().toSet();
        this.convertNumbers(result, new int[]{0, 1}, new Class[]{Integer.class, Double.class});
        HashSet expected = new HashSet();
        this.addValues(expected, 0, 0.0);
        this.addValues(expected, 1, 1.1);
        this.addValues(expected, 2, 2.2);
        this.addValues(expected, 3, 3.3);
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }

    @Test
    public void testUniqueMultipleAttributes3() throws Exception {
        UniqueVisitor v = new UniqueVisitor(new String[]{"intProperty", "doubleProperty", "stringProperty"});
        this.dataStore.getFeatureSource(this.tname("ft4")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Set result = v.getResult().toSet();
        this.convertNumbers(result, new int[]{0, 1}, new Class[]{Integer.class, Double.class});
        HashSet expected = new HashSet();
        this.addValues(expected, 0, 0.0, "zero");
        this.addValues(expected, 1, 1.1, "one");
        this.addValues(expected, 1, 1.1, "one_2");
        this.addValues(expected, 2, 2.2, "two");
        this.addValues(expected, 2, 2.2, "two_2");
        this.addValues(expected, 3, 3.3, "three");
        Assert.assertEquals((long)expected.size(), (long)result.size());
        Assert.assertTrue((boolean)expected.containsAll(result));
    }

    @Test
    public void testUniqueMultipleAttrOneResult() throws Exception {
        UniqueVisitor v = new UniqueVisitor(new String[]{"intProperty", "doubleProperty"});
        v.setMaxFeatures(1);
        this.dataStore.getFeatureSource(this.tname("ft1")).accepts(Query.ALL, (FeatureVisitor)v, null);
        Set result = v.getResult().toSet();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.iterator().next() instanceof List));
    }

    private void addValues(Set set, final Object ... values) {
        LinkedList list = new LinkedList(){
            {
                for (Object val : values) {
                    this.add(val);
                }
            }
        };
        set.add(list);
    }

    private void convertNumbers(Set values, int[] indexes, Class<?>[] clazz) {
        for (Object o : values) {
            List uniques = (List)o;
            for (int i = 0; i < indexes.length; ++i) {
                Object val = uniques.get(indexes[i]);
                Object result = Converters.convert(val, clazz[i]);
                uniques.set(indexes[i], result);
            }
        }
    }

    class MyStandardDeviationVisitor
    extends StandardDeviationVisitor {
        public MyStandardDeviationVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyAverageVisitor
    extends AverageVisitor {
        public MyAverageVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyNearestVisitor
    extends NearestVisitor {
        public MyNearestVisitor(Expression expr, Object valueToMatch) {
            super(expr, valueToMatch);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit((Feature)feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyUniqueVisitor
    extends UniqueVisitor {
        public MyUniqueVisitor(Expression expr) throws IllegalFilterException {
            super(new Expression[]{expr});
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyMinVisitor
    extends MinVisitor {
        public MyMinVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MyMaxVisitor
    extends MaxVisitor {
        public MyMaxVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MySumAreaVisitor
    extends SumAreaVisitor {
        public MySumAreaVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }

    class MySumVisitor
    extends SumVisitor {
        public MySumVisitor(Expression expr) throws IllegalFilterException {
            super(expr);
        }

        public void visit(Feature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }

        public void visit(SimpleFeature feature) {
            super.visit(feature);
            JDBCAggregateFunctionOnlineTest.this.visited = true;
        }
    }
}

