/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.awt.RenderingHints;
import java.util.Collections;
import org.geotools.jdbc.RegexpValidator;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;

public class EscapeSqlTest {
    @Test
    public void testSqlEscaping() throws Exception {
        VirtualTable vt = new VirtualTable("test", "%param1%");
        vt.setEscapeSql(true);
        vt.addParameter(new VirtualTableParameter("param1", "default_value", (VirtualTableParameter.Validator)new RegexpValidator(".*")));
        String singleQuote = vt.expandParameters(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("param1", "o'shea")));
        Assert.assertEquals((String)"single quotes should be doubled", (Object)"o''shea\n", (Object)singleQuote);
        String doubleQuote = vt.expandParameters(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("param1", "If you hear a voice within you say \"you cannot paint,\" then by all means paint, and that voice will be silenced.")));
        Assert.assertEquals((String)"double quotes should be doubled", (Object)"If you hear a voice within you say \"\"you cannot paint,\"\" then by all means paint, and that voice will be silenced.\n", (Object)doubleQuote);
        String backslash = vt.expandParameters(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, Collections.singletonMap("param1", "abc\\n")));
        Assert.assertEquals((String)"backslashes should be removed", (Object)"abcn\n", (Object)backslash);
    }
}

