/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.jdbc.JoinInfo;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class JDBCJoiningFilteringFeatureReader
implements DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> {
    FeatureReader<SimpleFeatureType, SimpleFeature> delegate;
    JoinInfo join;
    SimpleFeature next;

    public JDBCJoiningFilteringFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> delegate, JoinInfo join) {
        this.delegate = delegate;
        this.join = join;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getDelegate() {
        return this.delegate;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.delegate.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            SimpleFeature peek = (SimpleFeature)this.delegate.next();
            for (JoinInfo.JoinPart part : this.join.getParts()) {
                if (part.getPostFilter() == null) continue;
                SimpleFeature f = (SimpleFeature)peek.getAttribute(part.getAttributeName());
                if (part.getPostFilter().evaluate((Object)f)) continue;
                peek = null;
                break;
            }
            if (peek == null) continue;
            this.next = peek;
            break;
        }
        return this.next != null;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more features");
        }
        SimpleFeature f = this.next;
        this.next = null;
        return f;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

