/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCTransactionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JDBCTransactionStateTest {
    private Connection mockConnection = (Connection)Mockito.mock(Connection.class);
    private Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
    private Handler mockLogHandler = (Handler)Mockito.mock(Handler.class);
    private JDBCDataStore dataStore;
    private int warningsCount;

    @Before
    public void setUp() {
        ((Handler)Mockito.doAnswer(invocation -> {
            Object[] arguments = invocation.getArguments();
            LogRecord logRecord = (LogRecord)arguments[0];
            if (logRecord.getLevel() == Level.WARNING && !logRecord.getSourceMethodName().equals("finalize")) {
                ++this.warningsCount;
            }
            return null;
        }).when((Object)this.mockLogHandler)).publish((LogRecord)ArgumentMatchers.any(LogRecord.class));
        this.dataStore = new JDBCDataStore();
        this.dataStore.getLogger().addHandler(this.mockLogHandler);
    }

    @After
    public void tearDown() {
        this.dataStore.getLogger().removeHandler(this.mockLogHandler);
        this.dataStore.dispose();
    }

    @Test
    public void testSetTransactionNullWithInternalConnection() throws IOException, SQLException {
        JDBCTransactionState state = new JDBCTransactionState(this.mockConnection, this.dataStore);
        state.setTransaction(this.mockTransaction);
        state.setTransaction(null);
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)1))).close();
        this.testLogWarnings(state);
    }

    @Test
    public void testSetTransactionNullWithExternalConnection() throws Exception {
        JDBCTransactionState state = new JDBCTransactionState(this.mockConnection, this.dataStore, true);
        state.setTransaction(this.mockTransaction);
        state.setTransaction(null);
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)0))).close();
        this.testLogWarnings(state);
    }

    void testLogWarnings(JDBCTransactionState state) {
        Assert.assertEquals((String)"Regular close, no warnings expected.", (long)0L, (long)this.warningsCount);
        state.setTransaction(null);
        Assert.assertEquals((String)"Duplicate close, warning expected.", (long)1L, (long)this.warningsCount);
    }
}

