/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.geotools.data.Query;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.jdbc.JDBCDateTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class JDBCTimeZoneDateOnlineTest
extends JDBCTestSupport {
    TimeZone originalTimeZone;

    @Override
    protected abstract JDBCDateTestSetup createTestSetup();

    public void setTimeZone(TimeZone zone) {
        if (this.originalTimeZone == null) {
            this.originalTimeZone = TimeZone.getDefault();
        }
        TimeZone.setDefault(zone);
    }

    @Test
    public void testFiltersByDate() throws Exception {
        this.setup.setUpData();
        FilterFactory ff = this.dataStore.getFilterFactory();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-dd-MM");
        ContentFeatureSource fs = this.dataStore.getFeatureSource(this.tname("dates"));
        PropertyIsLessThanOrEqualTo f = ff.lessOrEqual((Expression)ff.property(this.aname("d")), (Expression)ff.literal((Object)df.parse("2009-28-06")));
        Assert.assertEquals((String)("wrong number of records for " + TimeZone.getDefault().getDisplayName()), (long)2L, (long)fs.getCount(new Query(this.tname("dates"), (Filter)f)));
        TimeZone.setDefault(this.originalTimeZone);
        this.setup.setUpData();
    }
}

