/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCGeometrylessTestSetup;
import org.geotools.jdbc.JDBCTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCGeometrylessOnlineTest
extends JDBCTestSupport {
    protected SimpleFeatureType personSchema;
    protected SimpleFeatureType zipCodeSchema;
    protected static final String PERSON = "person";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String AGE = "age";
    protected static final String ZIPCODE = "zipcode";
    protected static final String CODE = "code";

    @Override
    protected abstract JDBCGeometrylessTestSetup createTestSetup();

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.personSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + ".person"), (String)"id:0,name:String,age:0");
        this.zipCodeSchema = DataUtilities.createType((String)(this.dataStore.getNamespaceURI() + ".zipcode"), (String)"id:0,code:String");
    }

    @Test
    public void testPersonSchema() throws Exception {
        SimpleFeatureType ft = this.dataStore.getSchema(this.tname(PERSON));
        this.assertFeatureTypesEqual(this.personSchema, ft);
    }

    @Test
    public void testReadFeatures() throws Exception {
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(PERSON)).getFeatures();
        Assert.assertEquals((long)2L, (long)fc.size());
        try (SimpleFeatureIterator fr = fc.features();){
            Assert.assertTrue((boolean)fr.hasNext());
            fr.next();
            Assert.assertTrue((boolean)fr.hasNext());
            fr.next();
            Assert.assertFalse((boolean)fr.hasNext());
        }
    }

    @Test
    public void testGetBounds() throws Exception {
        ReferencedEnvelope env = this.dataStore.getFeatureSource(this.tname(PERSON)).getBounds();
        Assert.assertTrue((boolean)env.isEmpty());
    }

    @Test
    public void testCreate() throws Exception {
        this.dataStore.createSchema(this.zipCodeSchema);
        this.assertFeatureTypesEqual(this.zipCodeSchema, this.dataStore.getSchema(this.tname(ZIPCODE)));
    }

    @Test
    public void testWriteFeatures() throws Exception {
        try (FeatureWriter fw = this.dataStore.getFeatureWriterAppend(this.tname(PERSON), Transaction.AUTO_COMMIT);){
            SimpleFeature f = (SimpleFeature)fw.next();
            f.setAttribute(this.aname(NAME), (Object)"Joe");
            f.setAttribute(this.aname(AGE), (Object)27);
            fw.write();
        }
        ContentFeatureCollection fc = this.dataStore.getFeatureSource(this.tname(PERSON)).getFeatures();
        Assert.assertEquals((long)3L, (long)fc.size());
    }
}

