/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.geotools.data.CollectionFeatureReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.jdbc.FeatureEventWatcher;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCTestSupport;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;

public abstract class JDBCFeatureStoreOnlineTest
extends JDBCTestSupport {
    JDBCFeatureStore featureStore;

    @Override
    protected void connect() throws Exception {
        super.connect();
        this.featureStore = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.tname("ft1"));
    }

    @Test
    public void testAddFeatures() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        for (int i = 3; i < 6; ++i) {
            b.set(this.aname("intProperty"), (Object)i);
            b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            collection.add(b.buildFeature(null));
        }
        this.featureStore.addFeatureListener((FeatureListener)watcher);
        List fids = this.featureStore.addFeatures((FeatureCollection)collection);
        Assert.assertEquals((Object)watcher.bounds, (Object)collection.getBounds());
        Assert.assertEquals((long)3L, (long)fids.size());
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Assert.assertEquals((long)6L, (long)features.size());
        FilterFactory ff = this.dataStore.getFilterFactory();
        for (FeatureId identifier : fids) {
            String fid = identifier.getID();
            Id filter = ff.id(Collections.singleton(identifier));
            features = this.featureStore.getFeatures((Filter)filter);
            Assert.assertEquals((long)1L, (long)features.size());
            SimpleFeatureIterator iterator = features.features();
            try {
                Assert.assertTrue((boolean)iterator.hasNext());
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Assert.assertEquals((Object)fid, (Object)feature.getID());
                Assert.assertFalse((boolean)iterator.hasNext());
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreadedAddFeatures() throws IOException, InterruptedException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        ExecutorService executor = Executors.newFixedThreadPool(8);
        ExecutorCompletionService<Void> cs = new ExecutorCompletionService<Void>(executor);
        try {
            int i;
            int LOOPS = 32;
            for (i = 0; i < 32; ++i) {
                String theProperty = this.aname("intProperty");
                Integer theValue = i + 3;
                b.set(theProperty, (Object)theValue);
                SimpleFeature feature = b.buildFeature(null);
                cs.submit(() -> {
                    List ids = this.featureStore.addFeatures(Arrays.asList(feature));
                    Id filter = this.dataStore.getFilterFactory().id(Collections.singleton((FeatureId)ids.get(0)));
                    ContentFeatureCollection features = this.featureStore.getFeatures((Filter)filter);
                    Assert.assertEquals((long)1L, (long)features.size());
                    SimpleFeature found = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
                    Assert.assertEquals((Object)theValue, (Object)found.getAttribute(theProperty));
                    return null;
                });
            }
            for (i = 0; i < 32; ++i) {
                cs.take();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testAddFeaturesUseProvidedFid() throws IOException {
        Assert.assertTrue((boolean)this.featureStore.getQueryCapabilities().isUseProvidedFIDSupported());
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        String typeName = b.getFeatureType().getTypeName();
        for (int i = 3; i < 6; ++i) {
            b.set(this.aname("intProperty"), (Object)i);
            b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            b.featureUserData((Object)Hints.USE_PROVIDED_FID, (Object)Boolean.TRUE);
            collection.add(b.buildFeature(typeName + "." + i * 10));
        }
        List fids = this.featureStore.addFeatures((FeatureCollection)collection);
        Assert.assertEquals((long)3L, (long)fids.size());
        Assert.assertTrue((boolean)fids.contains(SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)(typeName + ".30"))));
        Assert.assertTrue((boolean)fids.contains(SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)(typeName + ".40"))));
        Assert.assertTrue((boolean)fids.contains(SimpleFeatureBuilder.createDefaultFeatureIdentifier((String)(typeName + ".50"))));
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Assert.assertEquals((long)6L, (long)features.size());
        FilterFactory ff = this.dataStore.getFilterFactory();
        for (FeatureId identifier : fids) {
            Id filter = ff.id(Collections.singleton(identifier));
            features = this.featureStore.getFeatures((Filter)filter);
            Assert.assertEquals((long)1L, (long)features.size());
        }
    }

    @Test
    public void testAddInTransaction() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        b.set(this.aname("intProperty"), (Object)3);
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        collection.add(b.buildFeature(null));
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        try (DefaultTransaction t = new DefaultTransaction();){
            this.featureStore.setTransaction((Transaction)t);
            this.featureStore.addFeatureListener((FeatureListener)watcher);
            JDBCFeatureStore featureStore2 = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.featureStore.getName().getLocalPart());
            List fids = this.featureStore.addFeatures((FeatureCollection)collection);
            Assert.assertEquals((long)1L, (long)fids.size());
            Assert.assertEquals((long)4L, (long)this.featureStore.getFeatures().size());
            Assert.assertEquals((long)3L, (long)featureStore2.getFeatures().size());
            t.commit();
            Assert.assertEquals((long)4L, (long)this.featureStore.getFeatures().size());
            Assert.assertEquals((long)4L, (long)featureStore2.getFeatures().size());
        }
    }

    @Test
    public void testExternalConnection() throws IOException, SQLException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        b.set(this.aname("intProperty"), (Object)3);
        b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate(3.0, 3.0)));
        collection.add(b.buildFeature(null));
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        try (Connection conn = this.setup.getDataSource().getConnection();){
            conn.setAutoCommit(false);
            try (Transaction t = this.dataStore.buildTransaction(conn);){
                this.featureStore.setTransaction(t);
                this.featureStore.addFeatureListener((FeatureListener)watcher);
                JDBCFeatureStore featureStore2 = (JDBCFeatureStore)this.dataStore.getFeatureSource(this.featureStore.getName().getLocalPart());
                List fids = this.featureStore.addFeatures((FeatureCollection)collection);
                Assert.assertEquals((long)1L, (long)fids.size());
                Assert.assertEquals((long)4L, (long)this.featureStore.getFeatures().size());
                Assert.assertEquals((long)3L, (long)featureStore2.getFeatures().size());
                t.commit();
                Assert.assertEquals((long)4L, (long)this.featureStore.getFeatures().size());
                Assert.assertEquals((long)3L, (long)featureStore2.getFeatures().size());
                conn.commit();
                Assert.assertEquals((long)4L, (long)this.featureStore.getFeatures().size());
                Assert.assertEquals((long)4L, (long)featureStore2.getFeatures().size());
                Assert.assertFalse((boolean)conn.isClosed());
            }
        }
    }

    @Test
    public void testAddNullAttributes() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        SimpleFeature nullFeature = b.buildFeature("testId");
        this.featureStore.addFeatures(Arrays.asList(nullFeature));
    }

    @Test
    public void testModifyNullAttributes() throws IOException {
        String[] attributeNames = new String[this.featureStore.getSchema().getAttributeCount()];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = this.featureStore.getSchema().getDescriptor(i).getLocalName();
        }
        Object[] nulls = new Object[attributeNames.length];
        this.featureStore.modifyFeatures(attributeNames, nulls, (Filter)Filter.INCLUDE);
    }

    @Test
    public void testSetFeatures() throws IOException {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(this.featureStore.getSchema());
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, this.featureStore.getSchema());
        for (int i = 3; i < 6; ++i) {
            b.set(this.aname("intProperty"), (Object)i);
            b.set(this.aname("geometry"), (Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            collection.add(b.buildFeature(null));
        }
        try (CollectionFeatureReader reader = new CollectionFeatureReader((SimpleFeatureCollection)collection, collection.getSchema());){
            this.featureStore.setFeatures((FeatureReader)reader);
        }
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Assert.assertEquals((long)3L, (long)features.size());
        try (SimpleFeatureIterator iterator = features.features();){
            HashSet<Integer> numbers = new HashSet<Integer>();
            numbers.add(3);
            numbers.add(4);
            numbers.add(5);
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Assert.assertTrue((boolean)numbers.contains(((Number)feature.getAttribute(this.aname("intProperty"))).intValue()));
                numbers.remove(feature.getAttribute(this.aname("intProperty")));
            }
        }
    }

    @Test
    public void testModifyFeatures() throws IOException {
        FeatureEventWatcher watcher = new FeatureEventWatcher();
        this.featureStore.addFeatureListener((FeatureListener)watcher);
        this.featureStore.modifyFeatures(new Name[]{new NameImpl(this.aname("stringProperty"))}, new Object[]{"foo"}, (Filter)Filter.INCLUDE);
        Assert.assertTrue((String)"check that at least one event was issued", (watcher.count > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should be an update event", (Object)FeatureEvent.Type.CHANGED, (Object)watcher.type);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)watcher.filter);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        try (SimpleFeatureIterator i = features.features();){
            Assert.assertTrue((boolean)i.hasNext());
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Assert.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
            }
        }
    }

    @Test
    public void testModifyGeometry() throws IOException {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(-10.0, 0.0));
        this.featureStore.modifyFeatures(new Name[]{new NameImpl(this.aname("geometry"))}, new Object[]{point}, (Filter)Filter.INCLUDE);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        try (SimpleFeatureIterator i = features.features();){
            Assert.assertTrue((boolean)i.hasNext());
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Assert.assertTrue((boolean)point.equalsExact((Geometry)feature.getAttribute(this.aname("geometry"))));
            }
        }
    }

    @Test
    public void testModifyMadeUpGeometry() throws IOException {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(-10.0, 0.0));
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.binding(Point.class);
        this.featureStore.modifyFeatures((Name)new NameImpl(this.aname("geometry")), (Object)point, (Filter)Filter.INCLUDE);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        try (SimpleFeatureIterator i = features.features();){
            Assert.assertTrue((boolean)i.hasNext());
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Assert.assertTrue((boolean)point.equalsExact((Geometry)feature.getAttribute(this.aname("geometry"))));
            }
        }
    }

    @Test
    public void testModifyFeaturesSingleAttribute() throws IOException {
        this.featureStore.modifyFeatures((Name)new NameImpl(this.aname("stringProperty")), (Object)"foo", (Filter)Filter.INCLUDE);
        ContentFeatureCollection features = this.featureStore.getFeatures();
        try (SimpleFeatureIterator i = features.features();){
            Assert.assertTrue((boolean)i.hasNext());
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Assert.assertEquals((Object)"foo", (Object)feature.getAttribute(this.aname("stringProperty")));
            }
        }
    }

    @Test(expected=Exception.class)
    public void testModifyFeaturesInvalidFilter() throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        this.featureStore.modifyFeatures((Name)new NameImpl(this.aname("stringProperty")), (Object)"foo", (Filter)f);
    }

    @Test
    public void testRemoveFeatures() throws IOException {
        FilterFactory ff = this.dataStore.getFilterFactory();
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property(this.aname("intProperty")), (Expression)ff.literal(1));
        ContentFeatureCollection features = this.featureStore.getFeatures();
        Assert.assertEquals((long)3L, (long)features.size());
        this.featureStore.removeFeatures((Filter)filter);
        Assert.assertEquals((long)2L, (long)features.size());
        this.featureStore.removeFeatures((Filter)Filter.INCLUDE);
        Assert.assertEquals((long)0L, (long)features.size());
    }

    @Test(expected=Exception.class)
    public void testRemoveFeaturesWithInvalidFilter() throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo f = ff.equals((Expression)ff.property("invalidAttribute"), (Expression)ff.literal(5));
        this.featureStore.removeFeatures((Filter)f);
    }
}

