/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.mockrunner.mock.jdbc.JDBCMockObjectFactory;
import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDataSource;
import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockStatement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCCallbackFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCReaderCallback;
import org.geotools.jdbc.NullPrimaryKey;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.feature.type.GeometryDescriptor;

public class JDBCDataStoreTest {
    @Test
    public void testMappingInitialisationIsThreadSafe() throws InterruptedException, ExecutionException {
        int nThreads = Math.min(Runtime.getRuntime().availableProcessors(), 2);
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        for (int i = 0; i < 100; ++i) {
            CountDownLatch latch = new CountDownLatch(nThreads);
            JDBCDataStore jdbcDataStore = new JDBCDataStore();
            BasicSQLDialect sqlDialect = new BasicSQLDialect(jdbcDataStore){

                public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
                }

                public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
                }

                public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
                    return null;
                }

                public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
                    return null;
                }
            };
            jdbcDataStore.setSQLDialect((SQLDialect)sqlDialect);
            ArrayList futures = new ArrayList();
            for (int j = 0; j < nThreads; ++j) {
                Future<?> future = executorService.submit(() -> {
                    try {
                        latch.countDown();
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return;
                    }
                    jdbcDataStore.getMapping(DateSubClass.class);
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        executorService.shutdown();
        executorService.awaitTermination(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testReaderCallback() throws Exception {
        final JDBCReaderCallback callback = (JDBCReaderCallback)Mockito.mock(JDBCReaderCallback.class);
        JDBCDataStore store = new JDBCDataStore();
        store.setNamespaceURI("http://geotools.org");
        store.setPrimaryKeyFinder(new PrimaryKeyFinder(){

            public PrimaryKey getPrimaryKey(JDBCDataStore store, String schema, String table, Connection cx) throws SQLException {
                return new NullPrimaryKey(table);
            }
        });
        store.setCallbackFactory(new JDBCCallbackFactory(){

            public String getName() {
                return "mock";
            }

            public JDBCReaderCallback createReaderCallback() {
                return callback;
            }
        });
        store.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        JDBCMockObjectFactory jdbcMock = new JDBCMockObjectFactory();
        store.setDataSource((DataSource)jdbcMock.getMockDataSource());
        MockResultSet tableTypes = new MockResultSet("tableTypes");
        tableTypes.addColumn("TABLE_TYPE", Arrays.asList("TABLE"));
        MockResultSet tables = new MockResultSet("tables");
        tables.addColumn("TABLE_NAME", Arrays.asList("foo"));
        tables.addColumn("TABLE_SCHEM", Arrays.asList(""));
        MockDatabaseMetaData meta = new MockDatabaseMetaData();
        meta.setTableTypes((ResultSet)tableTypes);
        meta.setTables((ResultSet)tables);
        MockConnection cx = jdbcMock.getMockConnection();
        cx.setMetaData((DatabaseMetaData)meta);
        BasicSQLDialect dialect = (BasicSQLDialect)Mockito.mock(BasicSQLDialect.class);
        Mockito.when((Object)dialect.getDesiredTablesType()).thenReturn((Object)new String[]{"TABLE"});
        Mockito.when((Object)dialect.includeTable(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Connection)ArgumentMatchers.any(Connection.class))).thenReturn((Object)true);
        store.setSQLDialect((SQLDialect)dialect);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("foo");
        tb.setNamespaceURI("http://geotools.org");
        tb.add("name", String.class);
        JDBCFeatureSource source = (JDBCFeatureSource)Mockito.mock(JDBCFeatureSource.class);
        Mockito.when((Object)source.getDataStore()).thenReturn((Object)store);
        MockResultSet rowData = new MockResultSet("foo");
        rowData.addColumn("name", Arrays.asList("foo", "bar", "baz"));
        rowData.setStatement((Statement)new MockStatement((Connection)cx));
        JDBCFeatureReader reader = new JDBCFeatureReader((ResultSet)rowData, (Connection)cx, 0, source, tb.buildFeatureType(), new Query());
        while (reader.hasNext()) {
            reader.next();
        }
        ((JDBCReaderCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).init(reader);
        ((JDBCReaderCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)4))).beforeNext((ResultSet)rowData);
        ((JDBCReaderCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)3))).afterNext((ResultSet)rowData, true);
        ((JDBCReaderCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).afterNext((ResultSet)rowData, false);
        ((JDBCReaderCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).finish(reader);
    }

    @Test
    public void testGetConnectionAutocommit() throws Exception {
        JDBCMockObjectFactory jdbcMock = new JDBCMockObjectFactory();
        MockDataSource dataSource = jdbcMock.getMockDataSource();
        dataSource.setupConnection((Connection)jdbcMock.getMockConnection());
        JDBCDataStore store = new JDBCDataStore();
        store.setSQLDialect((SQLDialect)Mockito.mock(BasicSQLDialect.class));
        store.setDataSource((DataSource)dataSource);
        try (Connection conn = store.getConnection(Transaction.AUTO_COMMIT);){
            Assert.assertEquals((Object)Boolean.TRUE, (Object)conn.getAutoCommit());
        }
        try (DefaultTransaction transaction = new DefaultTransaction();
             Connection conn2 = store.getConnection((Transaction)transaction);){
            Assert.assertEquals((Object)Boolean.FALSE, (Object)conn2.getAutoCommit());
        }
        Assert.assertThrows(Exception.class, () -> {
            Connection connection = store.getConnection((Transaction)null);
            if (connection != null) {
                connection.close();
            }
        });
    }

    public static class DateSubClass
    extends Timestamp {
        public DateSubClass(long time) {
            super(time);
        }
    }
}

