/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.singlestore;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.singlestore.SingleStoreDialect;
import org.geotools.data.singlestore.SingleStoreFilterToSQL;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class SingleStoreDialectBasic
extends BasicSQLDialect {
    SingleStoreDialect delegate;

    public SingleStoreDialectBasic(JDBCDataStore dataStore) {
        this(dataStore, false);
    }

    public SingleStoreDialectBasic(JDBCDataStore dataStore, boolean usePreciseSpatialOps) {
        super(dataStore);
        this.delegate = new SingleStoreDialect(dataStore);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    public Class<?> getMapping(String sqlTypeName) {
        if (sqlTypeName.equalsIgnoreCase("geography")) {
            return Geometry.class;
        }
        if (sqlTypeName.equalsIgnoreCase("geographypoint")) {
            return Point.class;
        }
        return super.getMapping(sqlTypeName);
    }

    public String getNameEscape() {
        return this.delegate.getNameEscape();
    }

    public String getGeometryTypeName(Integer type) {
        return this.delegate.getGeometryTypeName(type);
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public void encodeColumnName(String prefix, String raw, StringBuffer sql) {
        this.delegate.encodeColumnName(prefix, raw, sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql) {
        this.delegate.encodeColumnName(prefix, gatt.getLocalName(), sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, prefix, srid, hints, sql);
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        this.delegate.encodeColumnType(sqlTypeName, sql);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        this.delegate.registerSqlTypeToClassMappings(mappings);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        this.delegate.registerSqlTypeNameToClassMappings(mappings);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        this.delegate.registerSqlTypeToSqlTypeNameOverrides(overrides);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        this.delegate.encodePostColumnCreateTable(att, sql);
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getNextAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        if (value != null) {
            if (value instanceof Point) {
                sql.append(String.format("'%s'", value));
                return;
            } else if (value instanceof LineString) {
                sql.append(String.format("'%s'", value));
                return;
            } else {
                if (!(value instanceof Polygon)) throw new IOException("Unsupported geometry type: " + value.getClass().getSimpleName());
                sql.append(String.format("'%s'", value));
            }
            return;
        } else {
            sql.append("NULL");
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            WKTReader wktReader = new WKTReader(factory);
            Geometry geometry = wktReader.read(new String(bytes, StandardCharsets.UTF_8));
            return geometry;
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02X", b));
        }
        return hex.toString();
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }

    public FilterToSQL createFilterToSQL() {
        SingleStoreFilterToSQL fts = new SingleStoreFilterToSQL();
        return fts;
    }

    public void dropIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, String indexName) throws SQLException {
        this.delegate.dropIndex(cx, schema, databaseSchema, indexName);
    }

    public boolean canGroupOnGeometry() {
        return this.delegate.canGroupOnGeometry();
    }

    public Filter[] splitFilter(Filter filter, SimpleFeatureType schema) {
        return this.delegate.splitFilter(filter, schema);
    }
}

