/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.singlestore;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.singlestore.SingleStoreLargeGeometryPreProcessor;
import org.geotools.geometry.jts.Geometries;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public class SingleStoreDialect
extends SQLDialect {
    public SingleStoreDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if ("geometry_columns".equalsIgnoreCase(tableName)) {
            return false;
        }
        return super.includeTable(schemaName, tableName, cx);
    }

    public String getNameEscape() {
        return "";
    }

    public String getGeometryTypeName(Integer type) {
        return super.getGeometryTypeName(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sql = String.format("SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '%s' AND COLUMN_NAME = '%s'", tableName, columnName);
        this.dataStore.getLogger().fine(sql);
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Integer n = 4326;
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.encodeColumnName(null, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        try {
            String wkt = rs.getString(column);
            if (wkt == null) {
                return null;
            }
            Geometry geom = new WKTReader().read(wkt);
            return geom.getEnvelopeInternal();
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb for envelope";
            throw new IOException(msg, e);
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String name, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(name);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        if (att instanceof GeometryDescriptor && !att.isNillable() && !sql.toString().trim().endsWith(" NOT NULL")) {
            sql.append(" NOT NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        block17: {
            DatabaseMetaData md = cx.getMetaData();
            ResultSet rs = md.getTables(null, this.dataStore.escapeNamePattern(md, schemaName), this.dataStore.escapeNamePattern(md, "geometry_columns"), new String[]{"TABLE"});
            try {
                if (rs.next()) break block17;
                Statement st = cx.createStatement();
                try {
                    StringBuffer sqlb = new StringBuffer("CREATE TABLE ");
                    this.encodeTableName("geometry_columns", sqlb);
                    sqlb.append("(");
                    this.encodeColumnName(null, "f_table_schema", sqlb);
                    sqlb.append(" varchar(255), ");
                    this.encodeColumnName(null, "f_table_name", sqlb);
                    sqlb.append(" varchar(255), ");
                    this.encodeColumnName(null, "f_geometry_column", sqlb);
                    sqlb.append(" varchar(255), ");
                    this.encodeColumnName(null, "coord_dimension", sqlb);
                    sqlb.append(" int, ");
                    this.encodeColumnName(null, "srid", sqlb);
                    sqlb.append(" int, ");
                    this.encodeColumnName(null, "type", sqlb);
                    sqlb.append(" varchar(32)");
                    sqlb.append(")");
                    String sql = sqlb.toString();
                    LOGGER.fine(sql);
                    st.execute(sql);
                }
                finally {
                    this.dataStore.closeSafe(st);
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)ad;
            if (!ad.isNillable()) {
                StringBuffer sql = new StringBuffer("ALTER TABLE ");
                this.encodeTableName(featureType.getTypeName(), sql);
                sql.append(" ADD SPATIAL INDEX (");
                this.encodeColumnName(null, gd.getLocalName(), sql);
                sql.append(")");
                LOGGER.fine(sql.toString());
                Statement st = cx.createStatement();
                try {
                    st.execute(sql.toString());
                }
                finally {
                    this.dataStore.closeSafe(st);
                }
            }
            CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
            int srid = 0;
            if (crs != null) {
                Integer i = null;
                try {
                    i = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.FINER, "Could not determine epsg code", e);
                }
                srid = i != null ? i : srid;
            }
            StringBuffer sql = new StringBuffer("INSERT INTO ");
            this.encodeTableName("geometry_columns", sql);
            sql.append(" (");
            this.encodeColumnName(null, "f_table_schema", sql);
            sql.append(", ");
            this.encodeColumnName(null, "f_table_name", sql);
            sql.append(", ");
            this.encodeColumnName(null, "f_geometry_column", sql);
            sql.append(", ");
            this.encodeColumnName(null, "coord_dimension", sql);
            sql.append(", ");
            this.encodeColumnName(null, "srid", sql);
            sql.append(", ");
            this.encodeColumnName(null, "type", sql);
            sql.append(") ");
            sql.append(" VALUES (");
            sql.append((String)(schemaName != null ? "'" + schemaName + "'" : "NULL")).append(", ");
            sql.append("'").append(featureType.getTypeName()).append("', ");
            sql.append("'").append(ad.getLocalName()).append("', ");
            sql.append("2, ");
            sql.append(srid).append(", ");
            Class gc = gd.getType().getBinding();
            Geometries g = Geometries.getForBinding((Class)gc);
            sql.append("'").append(g != null ? g.getName().toUpperCase() : "GEOMETRY").append("')");
            LOGGER.fine(sql.toString());
            Statement st = cx.createStatement();
            try {
                st.execute(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(st);
            }
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" int AUTO_INCREMENT PRIMARY KEY");
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT last_insert_id()";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            if (offset > 0) {
                sql.append(" LIMIT " + offset + ", " + limit);
            } else {
                sql.append(" LIMIT " + limit);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT " + offset + ", 9223372036854775807");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, String indexName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String escape = this.getNameEscape();
        sql.append("DROP INDEX ");
        if (databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        sql.append(escape).append(indexName).append(escape);
        sql.append(" on ");
        if (databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        this.encodeTableName(schema.getTypeName(), sql);
        Statement st = null;
        try {
            st = cx.createStatement();
            st.execute(sql.toString());
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(st);
            this.dataStore.closeSafe(cx);
        }
    }

    public boolean canGroupOnGeometry() {
        return true;
    }

    public Filter[] splitFilter(Filter filter, SimpleFeatureType schema) {
        Filter[] prePost = super.splitFilter(filter, schema);
        Filter pre = prePost[0];
        Filter post = prePost[1];
        pre = (Filter)pre.accept((FilterVisitor)new SingleStoreLargeGeometryPreProcessor(), null);
        return new Filter[]{pre, post};
    }
}

