/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.singlestore;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.data.singlestore.SingleStoreDialectBasic;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class SingleStoreDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"singlestore", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)3306);
    public static final DataAccessFactory.Param ENHANCED_SPATIAL_SUPPORT = new DataAccessFactory.Param("enhancedSpatialSupport", Boolean.class, "Enhanced Spatial Support", false, (Object)false);
    protected boolean enhancedSpatialSupport;

    public SingleStoreDataStoreFactory() {
        this.enhancedSpatialSupport = (Boolean)SingleStoreDataStoreFactory.ENHANCED_SPATIAL_SUPPORT.sample;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new SingleStoreDialectBasic(dataStore, this.enhancedSpatialSupport);
    }

    public String getDisplayName() {
        return "SingleStore";
    }

    protected String getDriverClassName() {
        return "com.singlestore.jdbc.Driver";
    }

    protected String getDatabaseID() {
        return (String)SingleStoreDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "SingleStore Database";
    }

    protected String getValidationQuery() {
        return "select version()";
    }

    protected void setupParameters(Map<String, Object> parameters) {
        super.setupParameters(parameters);
        parameters.put(SingleStoreDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(SingleStoreDataStoreFactory.PORT.key, PORT);
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        Boolean enhancedSpatialFlag = (Boolean)ENHANCED_SPATIAL_SUPPORT.lookUp(params);
        this.enhancedSpatialSupport = enhancedSpatialFlag != null && enhancedSpatialFlag != false;
        return dataStore;
    }
}

